/*
 * Decompiled with CFR 0.152.
 */
package artifacts.loot;

import artifacts.Artifacts;
import artifacts.registry.ModLootConditions;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.class_3518;
import net.minecraft.class_47;
import net.minecraft.class_5335;
import net.minecraft.class_5341;
import net.minecraft.class_5342;

public class ConfigValueChance
implements class_5341 {
    private final ChanceConfig chanceConfig;

    private ConfigValueChance(ChanceConfig chanceConfig) {
        this.chanceConfig = chanceConfig;
    }

    public class_5342 method_29325() {
        return ModLootConditions.CONFIG_VALUE_CHANCE.get();
    }

    public boolean test(class_47 context) {
        return context.method_294().method_43058() < this.chanceConfig.value.get();
    }

    public static class_5341.class_210 archaeologyChance() {
        return () -> new ConfigValueChance(ChanceConfig.ARCHAEOLOGY);
    }

    public static class_5341.class_210 entityEquipmentChance() {
        return () -> new ConfigValueChance(ChanceConfig.ENTITY_EQUIPMENT);
    }

    public static class_5341.class_210 everlastingBeefChance() {
        return () -> new ConfigValueChance(ChanceConfig.EVERLASTING_BEEF);
    }

    private static enum ChanceConfig {
        ARCHAEOLOGY("archaeology", () -> Artifacts.CONFIG.common.archaeologyChance),
        ENTITY_EQUIPMENT("entity_equipment", () -> Artifacts.CONFIG.common.entityEquipmentChance),
        EVERLASTING_BEEF("everlasting_beef", () -> Artifacts.CONFIG.common.everlastingBeefChance);

        final String name;
        final Supplier<Double> value;

        private ChanceConfig(String name, Supplier<Double> value) {
            this.name = name;
            this.value = value;
        }

        static ChanceConfig byName(String name) {
            return ChanceConfig.valueOf(name.toUpperCase(Locale.ROOT));
        }
    }

    public static class Serializer
    implements class_5335<ConfigValueChance> {
        public void serialize(JsonObject object, ConfigValueChance condition, JsonSerializationContext context) {
            object.addProperty("config", condition.chanceConfig.name);
        }

        public ConfigValueChance deserialize(JsonObject object, JsonDeserializationContext context) {
            ChanceConfig config = ChanceConfig.byName(class_3518.method_15265((JsonObject)object, (String)"config"));
            return new ConfigValueChance(config);
        }
    }
}

