/*
 * Decompiled with CFR 0.152.
 */
package net.sssubtlety.automated_crafting;

import com.google.common.collect.Streams;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.base.CombinedStorage;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2621;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3908;
import net.minecraft.class_3914;
import net.minecraft.class_3955;
import net.minecraft.class_3956;
import net.minecraft.class_5250;
import net.sssubtlety.automated_crafting.AutoCrafterBlock;
import net.sssubtlety.automated_crafting.AutomatedCrafting;
import net.sssubtlety.automated_crafting.FeatureControl;
import net.sssubtlety.automated_crafting.Registrar;
import net.sssubtlety.automated_crafting.Validator;
import net.sssubtlety.automated_crafting.gui.AutoCrafterGuiDescription;
import net.sssubtlety.automated_crafting.inventory.ArrayInventory;
import net.sssubtlety.automated_crafting.inventory.CraftingView;
import net.sssubtlety.automated_crafting.inventory.DefaultedStackView;
import net.sssubtlety.automated_crafting.inventory.InputInventory;
import net.sssubtlety.automated_crafting.inventory.SingleOutputInventory;
import net.sssubtlety.automated_crafting.inventory.TemplateInventory;
import net.sssubtlety.automated_crafting.inventory.TrimmableInventory;

public class AutoCrafterBlockEntity
extends class_2621
implements class_1278,
TrimmableInventory,
class_3908 {
    public static final int MAX_STACK_SIZE = 1;
    public static final int[] AVAILABLE_INDICES;
    public static final Validator validator;
    public static final class_5250 NAME;
    protected final TemplateInventory templateInventory = new TemplateInventory(new DefaultedStackView(9));
    protected final InputInventory inputInventory = new InputInventory(new DefaultedStackView(9), this.templateInventory, this::tryCraftContinuously);
    protected final SingleOutputInventory output = new SingleOutputInventory(this::tryCraftContinuously);
    protected final CombinedStorage<ItemVariant, Storage<ItemVariant>> inputAndOutputStorage;
    protected final Validator.Validation validation;
    protected class_3955 recipeCache;

    public static boolean templatePredicate(class_1799 inputStack, class_1799 templateStack) {
        return templateStack.method_31574(inputStack.method_7909()) && class_1799.method_31577((class_1799)templateStack, (class_1799)inputStack);
    }

    public static Storage<ItemVariant> getStorage(AutoCrafterBlockEntity blockEntity, class_2350 direction) {
        if (direction == class_2350.field_11033) {
            return blockEntity.inputAndOutputStorage;
        }
        return blockEntity.inputInventory.storage;
    }

    public AutoCrafterBlockEntity(class_2338 pos, class_2680 state) {
        super(Registrar.BLOCK_ENTITY_TYPE, pos, state);
        this.inputAndOutputStorage = new CombinedStorage(List.of(this.output.storage, this.inputInventory.storage));
        this.recipeCache = null;
        this.validation = validator.getValidation();
    }

    protected boolean misMatchesTemplate(int slot, class_1799 inputStack) {
        class_1799 templateStack = this.templateInventory.method_5438(slot);
        return !AutoCrafterBlockEntity.templatePredicate(inputStack, templateStack);
    }

    public int method_5444() {
        return 1;
    }

    public boolean method_5443(class_1657 player) {
        return true;
    }

    public boolean method_5437(int slot, class_1799 stack) {
        if (slot > 18) {
            return false;
        }
        if (slot == 18) {
            return true;
        }
        if (slot >= 9) {
            return this.inputInventory.method_5437(Slots.toInputSlot(slot), stack);
        }
        return this.templateInventory.method_5437(slot, stack);
    }

    public int method_18861(class_1792 item) {
        int count = this.templateInventory.method_18861(item);
        count += this.inputInventory.method_18861(item);
        if (this.output.getItem() == item) {
            count += this.output.getCount();
        }
        return count;
    }

    public boolean method_18862(Set<class_1792> items) {
        return items.contains(this.output.getItem()) || this.templateInventory.method_18862(items) || this.inputInventory.method_18862(items);
    }

    public void method_11007(class_2487 nbt) {
        super.method_11007(nbt);
        class_2371<class_1799> invStackList = this.method_11282();
        class_1262.method_5426((class_2487)nbt, invStackList);
    }

    public void method_11014(class_2487 nbt) {
        super.method_11014(nbt);
        class_2371 invStackList = class_2371.method_10213((int)19, (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)nbt, (class_2371)invStackList);
        this.method_11281((class_2371<class_1799>)invStackList);
    }

    public void tryCraft() {
        Optional<class_3955> optRecipe = this.getRecipe();
        if (optRecipe.isPresent()) {
            class_3955 recipe = optRecipe.get();
            class_1799 output1 = recipe.method_8116((class_1263)this.templateInventory, this.field_11863.method_30349());
            OutputAction outputAction = this.checkOutput(output1);
            if (outputAction != OutputAction.FAIL) {
                class_2371 remainingStacks = recipe.method_8111((class_1263)this.inputInventory);
                for (int i = 0; i < 9; ++i) {
                    class_1799 slotRemainder = (class_1799)remainingStacks.get(i);
                    if (slotRemainder.method_7960()) {
                        this.inputInventory.method_5434(i, 1);
                        continue;
                    }
                    this.inputInventory.method_5447(i, slotRemainder);
                }
                if (outputAction == OutputAction.SET) {
                    this.output.set(output1);
                } else {
                    this.output.get().method_7933(output1.method_7947());
                }
            } else {
                this.tryPlayFailSound();
            }
        } else {
            this.tryPlayFailSound();
        }
    }

    protected void tryPlayFailSound() {
        if (this.field_11863 != null && !FeatureControl.doesCraftContinuously()) {
            this.field_11863.method_20290(1001, this.field_11867, 0);
        }
    }

    protected OutputAction checkOutput(class_1799 output) {
        if (this.output.method_5442()) {
            return OutputAction.SET;
        }
        if (class_1799.method_31577((class_1799)output, (class_1799)this.output.get()) && this.output.getMaxCount() >= this.output.getCount() + output.method_7947()) {
            return OutputAction.INCREMENT;
        }
        return OutputAction.FAIL;
    }

    protected Optional<class_3955> getRecipe() {
        if (this.field_11863 == null) {
            AutomatedCrafting.LOGGER.error("Trying to get recipe before world is initialized!");
            return Optional.empty();
        }
        if (FeatureControl.isSimpleMode() && this.inputMisMatchesTemplate()) {
            return Optional.empty();
        }
        if (this.recipeCache == null || this.validation.invalid() || !this.recipeCache.method_8115((class_1263)this.inputInventory, this.field_11863)) {
            this.recipeCache = this.field_11863.method_8433().method_8132(class_3956.field_17545, (class_1263)this.inputInventory, this.field_11863).orElse(null);
        }
        return Optional.ofNullable(this.recipeCache);
    }

    private boolean inputMisMatchesTemplate() {
        for (int slot = 0; slot < 9; ++slot) {
            if (!this.misMatchesTemplate(slot, this.inputInventory.method_5438(slot))) continue;
            return true;
        }
        return false;
    }

    protected void tryCraftContinuously() {
        if (FeatureControl.doesCraftContinuously() && this.field_11863 != null && ((Boolean)this.field_11863.method_8320(this.field_11867).method_11654((class_2769)AutoCrafterBlock.POWERED)).booleanValue()) {
            this.tryCraft();
        }
    }

    public int[] method_5494(class_2350 side) {
        return AVAILABLE_INDICES;
    }

    public boolean method_5492(int slot, class_1799 stack, class_2350 dir) {
        int inputSlot = Slots.toInputSlot(slot);
        return CraftingView.Grid.contains(inputSlot);
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        if (slot == 18 || !FeatureControl.isSimpleMode()) {
            return true;
        }
        int inputSlot = Slots.toInputSlot(slot);
        return CraftingView.Grid.contains(inputSlot) && this.misMatchesTemplate(inputSlot, stack);
    }

    public class_1799 method_5434(int slot, int amount) {
        class_1799 removedStack = slot == 18 ? this.output.split(amount) : (slot >= 9 ? this.inputInventory.method_5434(Slots.toInputSlot(slot), amount) : this.templateInventory.method_5434(slot, amount));
        return removedStack;
    }

    public class_1799 method_5441(int slot) {
        class_1799 removedStack;
        if (slot == 18) {
            removedStack = this.output.get();
            this.output.set(class_1799.field_8037);
        } else {
            removedStack = slot >= 9 ? this.inputInventory.method_5441(Slots.toInputSlot(slot)) : this.templateInventory.method_5441(slot);
        }
        this.tryCraftContinuously();
        return removedStack;
    }

    public void method_5447(int slot, class_1799 stack) {
        this.setStackWithoutCrafting(slot, stack);
        this.tryCraftContinuously();
    }

    protected void setStackWithoutCrafting(int slot, class_1799 stack) {
        if (slot == 18) {
            this.output.set(stack);
        } else if (slot >= 9) {
            this.inputInventory.method_5447(Slots.toInputSlot(slot), stack);
        } else {
            this.templateInventory.method_5447(slot, stack);
        }
        this.method_5431();
    }

    protected class_2371<class_1799> method_11282() {
        class_2371 stacks = class_2371.method_10211();
        stacks.addAll(this.templateInventory.getStacks());
        stacks.addAll(this.inputInventory.getStacks());
        stacks.add((Object)this.output.get());
        return stacks;
    }

    protected void method_11281(class_2371<class_1799> list) {
        int i;
        int size = list.size();
        for (i = 0; i < 9; ++i) {
            this.templateInventory.method_5447(i, i < size ? (class_1799)list.get(i) : class_1799.field_8037);
        }
        int iInput = 0;
        while (i < 18) {
            this.inputInventory.method_5447(iInput, i < size ? (class_1799)list.get(i) : class_1799.field_8037);
            ++iInput;
            ++i;
        }
        this.output.set(i < size ? (class_1799)list.get(i) : class_1799.field_8037);
    }

    protected class_2561 method_17823() {
        return NAME;
    }

    public class_1703 method_5465(int syncId, class_1661 playerInventory) {
        return AutoCrafterGuiDescription.create(syncId, playerInventory, class_3914.method_17392((class_1937)this.field_11863, (class_2338)this.field_11867));
    }

    public int method_5439() {
        return 19;
    }

    public boolean method_5442() {
        return this.output.method_5442() && this.templateInventory.method_5442() && this.inputInventory.method_5442();
    }

    public class_1799 method_5438(int slot) {
        if (slot == 18) {
            return this.output.get();
        }
        if (slot >= 9) {
            return this.inputInventory.method_5438(Slots.toInputSlot(slot));
        }
        return this.templateInventory.method_5438(slot);
    }

    public void method_5448() {
        this.templateInventory.method_5448();
        this.inputInventory.method_5448();
        this.output.set(class_1799.field_8037);
    }

    public int getComparatorOutput() {
        if (FeatureControl.doesComparatorReadOutput() && !this.output.method_5442()) {
            return 15;
        }
        return this.inputInventory.getComparatorOutput();
    }

    @Override
    public class_1263 getTrimmed() {
        return new ArrayInventory(this.getTrimmedStream());
    }

    @Override
    public Stream<class_1799> getTrimmedStream() {
        Stream<class_1799> trimmedInput = this.inputInventory.getTrimmedStream();
        if (this.output.method_5442()) {
            return trimmedInput;
        }
        return Streams.concat((Stream[])new Stream[]{trimmedInput, Stream.of(this.output.get())});
    }

    static {
        validator = new Validator();
        NAME = class_2561.method_43471((String)"block.automated_crafting.auto_crafter");
        AVAILABLE_INDICES = new int[10];
        AutoCrafterBlockEntity.AVAILABLE_INDICES[0] = 18;
        for (int i = 1; i < 10; ++i) {
            AutoCrafterBlockEntity.AVAILABLE_INDICES[i] = i + 8;
        }
    }

    public static interface Slots {
        public static final int TEMPLATE_START = 0;
        public static final int INPUT_START = 9;
        public static final int LAST_TEMPLATE_SLOT = 8;
        public static final int INPUT_PLUS_OUTPUT_SIZE = 10;
        public static final int OUTPUT_SLOT = 18;
        public static final int INVENTORY_SIZE = 19;

        public static int toInputSlot(int slot) {
            return slot - 9;
        }
    }

    public static enum OutputAction {
        FAIL,
        SET,
        INCREMENT;

    }
}

