/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.render;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import mod.azure.azurelib.rewrite.animation.AzAnimator;
import mod.azure.azurelib.rewrite.model.AzBone;
import mod.azure.azurelib.rewrite.render.AzLayerRenderer;
import mod.azure.azurelib.rewrite.render.AzModelRenderer;
import mod.azure.azurelib.rewrite.render.AzRendererPipeline;
import mod.azure.azurelib.rewrite.render.AzRendererPipelineContext;
import mod.azure.azurelib.rewrite.render.layer.AzRenderLayer;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class AzRendererConfig<T> {
    protected final Supplier<@Nullable AzAnimator<T>> animatorProvider;
    protected final Function<T, class_2960> modelLocationProvider;
    private final BiFunction<AzRendererPipeline<T>, AzLayerRenderer<T>, AzModelRenderer<T>> modelRendererProvider;
    private final Function<AzRendererPipeline<T>, AzRendererPipelineContext<T>> pipelineContextFunction;
    protected final Function<T, class_1921> renderTypeFunction;
    private final Function<AzRendererPipelineContext<T>, AzRendererPipelineContext<T>> preRenderEntry;
    private final Function<AzRendererPipelineContext<T>, AzRendererPipelineContext<T>> renderEntry;
    private final Function<AzRendererPipelineContext<T>, AzRendererPipelineContext<T>> postRenderEntry;
    protected final List<AzRenderLayer<T>> renderLayers;
    protected final Function<T, class_2960> textureLocationProvider;
    private final Function<T, Float> alphaFunction;
    private final Function<T, Float> scaleHeight;
    private final Function<T, Float> scaleWidth;
    @Nullable
    private final Function<AzBone, class_2960> boneTextureOverrideProvider;
    @Nullable
    private final Function<AzBone, class_1921> boneRenderTypeOverrideProvider;

    public AzRendererConfig(Supplier<AzAnimator<T>> animatorProvider, Function<T, class_2960> modelLocationProvider, BiFunction<AzRendererPipeline<T>, AzLayerRenderer<T>, AzModelRenderer<T>> modelRendererProvider, Function<AzRendererPipeline<T>, AzRendererPipelineContext<T>> pipelineContextFunction, Function<T, class_1921> renderTypeFunction, List<AzRenderLayer<T>> renderLayers, Function<AzRendererPipelineContext<T>, AzRendererPipelineContext<T>> preRenderEntry, Function<AzRendererPipelineContext<T>, AzRendererPipelineContext<T>> renderEntry, Function<AzRendererPipelineContext<T>, AzRendererPipelineContext<T>> postRenderEntry, Function<T, class_2960> textureLocationProvider, Function<T, Float> alphaFunction, Function<T, Float> scaleHeight, Function<T, Float> scaleWidth, Function<AzBone, class_2960> boneTextureOverrideProvider, Function<AzBone, class_1921> boneRenderTypeOverrideProvider) {
        this.animatorProvider = animatorProvider;
        this.modelLocationProvider = modelLocationProvider;
        this.modelRendererProvider = modelRendererProvider;
        this.pipelineContextFunction = pipelineContextFunction;
        this.renderTypeFunction = renderTypeFunction;
        this.renderLayers = Collections.unmodifiableList(renderLayers);
        this.preRenderEntry = preRenderEntry;
        this.renderEntry = renderEntry;
        this.postRenderEntry = postRenderEntry;
        this.textureLocationProvider = textureLocationProvider;
        this.scaleHeight = scaleHeight;
        this.scaleWidth = scaleWidth;
        this.alphaFunction = alphaFunction;
        this.boneTextureOverrideProvider = boneTextureOverrideProvider;
        this.boneRenderTypeOverrideProvider = boneRenderTypeOverrideProvider;
    }

    @Nullable
    public AzAnimator<T> createAnimator() {
        return this.animatorProvider.get();
    }

    public class_2960 modelLocation(T animatable) {
        return this.modelLocationProvider.apply(animatable);
    }

    public AzRendererPipelineContext<T> pipelineContext(AzRendererPipeline<T> pipeline) {
        return this.pipelineContextFunction.apply(pipeline);
    }

    public AzModelRenderer<T> modelRendererProvider(AzRendererPipeline<T> pipeline, AzLayerRenderer<T> layerRenderer) {
        return this.modelRendererProvider.apply(pipeline, layerRenderer);
    }

    public class_2960 textureLocation(T animatable) {
        return this.textureLocationProvider.apply(animatable);
    }

    public class_1921 getRenderType(T entity) {
        return this.renderTypeFunction.apply(entity);
    }

    public List<AzRenderLayer<T>> renderLayers() {
        return this.renderLayers;
    }

    public AzRendererPipelineContext<T> preRenderEntry(AzRendererPipelineContext<T> animatable) {
        return this.preRenderEntry.apply(animatable);
    }

    public AzRendererPipelineContext<T> renderEntry(AzRendererPipelineContext<T> animatable) {
        return this.renderEntry.apply(animatable);
    }

    public AzRendererPipelineContext<T> postRenderEntry(AzRendererPipelineContext<T> animatable) {
        return this.postRenderEntry.apply(animatable);
    }

    public float alpha(T entity) {
        return this.alphaFunction.apply(entity).floatValue();
    }

    public float scaleHeight(T entity) {
        return this.scaleHeight.apply(entity).floatValue();
    }

    public float scaleWidth(T entity) {
        return this.scaleWidth.apply(entity).floatValue();
    }

    @Nullable
    public class_2960 boneTextureOverrideProvider(AzBone bone) {
        return this.boneTextureOverrideProvider.apply(bone);
    }

    @Nullable
    public class_1921 boneRenderTypeOverrideProvider(AzBone bone) {
        return this.boneRenderTypeOverrideProvider.apply(bone);
    }

    public static class Builder<T> {
        private final Function<T, class_2960> modelLocationProvider;
        protected BiFunction<AzRendererPipeline<T>, AzLayerRenderer<T>, AzModelRenderer<T>> modelRendererProvider;
        protected Function<AzRendererPipeline<T>, AzRendererPipelineContext<T>> pipelineContextFunction;
        protected Function<T, class_1921> renderTypeProvider;
        private final List<AzRenderLayer<T>> renderLayers;
        protected Function<AzRendererPipelineContext<T>, AzRendererPipelineContext<T>> preRenderEntry;
        protected Function<AzRendererPipelineContext<T>, AzRendererPipelineContext<T>> renderEntry;
        protected Function<AzRendererPipelineContext<T>, AzRendererPipelineContext<T>> postRenderEntry;
        protected final Function<T, class_2960> textureLocationProvider;
        protected Supplier<@Nullable AzAnimator<T>> animatorProvider = () -> null;
        protected Function<T, Float> alphaFunction;
        protected Function<T, Float> scaleHeight;
        protected Function<T, Float> scaleWidth;
        @Nullable
        private Function<AzBone, class_2960> boneTextureOverrideProvider;
        @Nullable
        private Function<AzBone, class_1921> boneRenderTypeOverrideProvider;

        protected Builder(Function<T, class_2960> modelLocationProvider, Function<T, class_2960> textureLocationProvider) {
            this.modelLocationProvider = modelLocationProvider;
            this.modelRendererProvider = AzModelRenderer::new;
            this.pipelineContextFunction = null;
            this.renderTypeProvider = $ -> class_1921.method_23576((class_2960)((class_2960)textureLocationProvider.apply($)));
            this.renderLayers = new ObjectArrayList();
            this.preRenderEntry = $ -> $;
            this.renderEntry = $ -> $;
            this.postRenderEntry = $ -> $;
            this.textureLocationProvider = textureLocationProvider;
            this.alphaFunction = $ -> Float.valueOf(1.0f);
            this.scaleHeight = $ -> Float.valueOf(1.0f);
            this.scaleWidth = $ -> Float.valueOf(1.0f);
            this.boneTextureOverrideProvider = $ -> null;
            this.boneRenderTypeOverrideProvider = $ -> null;
        }

        public Builder<T> setBoneTextureOverrideProvider(Function<AzBone, class_2960> boneTextureOverrideProvider) {
            this.boneTextureOverrideProvider = boneTextureOverrideProvider;
            return this;
        }

        public Builder<T> setBoneRenderTypeOverrideProvider(Function<AzBone, class_1921> boneRenderTypeOverrideProvider) {
            this.boneRenderTypeOverrideProvider = boneRenderTypeOverrideProvider;
            return this;
        }

        public Builder<T> setAnimatorProvider(Supplier<@Nullable AzAnimator<T>> animatorProvider) {
            this.animatorProvider = animatorProvider;
            return this;
        }

        public Builder<T> addRenderLayer(AzRenderLayer<T> renderLayer) {
            this.renderLayers.add(renderLayer);
            return this;
        }

        public Builder<T> setModelRenderer(BiFunction<AzRendererPipeline<T>, AzLayerRenderer<T>, AzModelRenderer<T>> modelRendererProvider) {
            this.modelRendererProvider = modelRendererProvider;
            return this;
        }

        public Builder<T> setPipelineContext(Function<AzRendererPipeline<T>, AzRendererPipelineContext<T>> pipelineContextFunction) {
            this.pipelineContextFunction = pipelineContextFunction;
            return this;
        }

        public Builder<T> setPrerenderEntry(Function<AzRendererPipelineContext<T>, AzRendererPipelineContext<T>> preRenderEntry) {
            this.preRenderEntry = preRenderEntry;
            return this;
        }

        public Builder<T> setRenderEntry(Function<AzRendererPipelineContext<T>, AzRendererPipelineContext<T>> renderEntry) {
            this.renderEntry = renderEntry;
            return this;
        }

        public Builder<T> setPostRenderEntry(Function<AzRendererPipelineContext<T>, AzRendererPipelineContext<T>> postRenderEntry) {
            this.postRenderEntry = postRenderEntry;
            return this;
        }

        public Builder<T> setAlpha(Function<T, Float> alphaFunction) {
            this.alphaFunction = alphaFunction;
            return this;
        }

        public Builder<T> setAlpha(float alpha) {
            this.alphaFunction = $ -> Float.valueOf(alpha);
            return this;
        }

        public Builder<T> setScale(float scale) {
            return this.setScale(scale, scale);
        }

        public Builder<T> setScale(float scaleWidth, float scaleHeight) {
            this.scaleHeight = $ -> Float.valueOf(scaleHeight);
            this.scaleWidth = $ -> Float.valueOf(scaleWidth);
            return this;
        }

        public Builder<T> setScale(Function<T, Float> scaleFunction) {
            this.scaleHeight = scaleFunction;
            this.scaleWidth = scaleFunction;
            return this;
        }

        public Builder<T> setScale(Function<T, Float> scaleHeightFunction, Function<T, Float> scaleWidthFunction) {
            this.scaleHeight = scaleHeightFunction;
            this.scaleWidth = scaleWidthFunction;
            return this;
        }

        public AzRendererConfig<T> build() {
            return new AzRendererConfig<T>(this.animatorProvider, this.modelLocationProvider, this.modelRendererProvider, this.pipelineContextFunction, this.renderTypeProvider, this.renderLayers, this.preRenderEntry, this.renderEntry, this.postRenderEntry, this.textureLocationProvider, this.alphaFunction, this.scaleHeight, this.scaleWidth, this.boneTextureOverrideProvider, this.boneRenderTypeOverrideProvider);
        }
    }
}

