/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.render;

import it.unimi.dsi.fastutil.ints.IntIntPair;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Objects;
import mod.azure.azurelib.core.object.Color;
import mod.azure.azurelib.rewrite.model.AzBakedModel;
import mod.azure.azurelib.rewrite.render.AzRendererPipeline;
import mod.azure.azurelib.util.RenderUtils;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;

public abstract class AzRendererPipelineContext<T> {
    public class_2960 textureOverride;
    private final AzRendererPipeline<T> rendererPipeline;
    protected T animatable;
    private AzBakedModel bakedModel;
    private class_4597 multiBufferSource;
    private int packedLight;
    private int packedOverlay;
    private float partialTick;
    private class_4587 poseStack;
    private float red;
    private float green;
    private float blue;
    private float alpha;
    private class_1921 renderType;
    private class_4588 vertexConsumer;
    protected static final Map<class_2960, IntIntPair> TEXTURE_DIMENSIONS_CACHE = new Object2ObjectOpenHashMap();

    protected AzRendererPipelineContext(AzRendererPipeline<T> rendererPipeline) {
        this.rendererPipeline = rendererPipeline;
    }

    public void populate(T animatable, AzBakedModel bakedModel, class_4597 multiBufferSource, int packedLight, float partialTick, class_4587 poseStack, class_1921 renderType, class_4588 vertexConsumer) {
        this.animatable = animatable;
        this.bakedModel = bakedModel;
        this.multiBufferSource = multiBufferSource;
        this.packedLight = packedLight;
        this.packedOverlay = this.getPackedOverlay(animatable, 0.0f, partialTick);
        this.partialTick = partialTick;
        this.poseStack = poseStack;
        this.renderType = renderType;
        this.vertexConsumer = vertexConsumer;
        Color renderColor = this.getRenderColor(animatable, partialTick, packedLight);
        this.red = renderColor.getRedFloat();
        this.green = renderColor.getGreenFloat();
        this.blue = renderColor.getBlueFloat();
        this.alpha = renderColor.getAlphaFloat();
        if (renderType == null) {
            class_2960 textureLocation = this.rendererPipeline.config().textureLocation(animatable);
            this.renderType = this.getDefaultRenderType(animatable, textureLocation, multiBufferSource, partialTick, this.rendererPipeline.config().getRenderType(animatable), this.rendererPipeline.config().alpha(animatable));
        }
        Objects.requireNonNull(this.renderType);
        if (vertexConsumer == null) {
            this.vertexConsumer = multiBufferSource.getBuffer(this.renderType);
        }
    }

    public abstract class_1921 getDefaultRenderType(T var1, class_2960 var2, class_4597 var3, float var4, class_1921 var5, float var6);

    public Color getRenderColor(T animatable, float partialTick, int packedLight) {
        return Color.WHITE;
    }

    protected int getPackedOverlay(T animatable, float u, float partialTick) {
        return class_4608.field_21444;
    }

    public AzRendererPipeline<T> rendererPipeline() {
        return this.rendererPipeline;
    }

    public T animatable() {
        return this.animatable;
    }

    public AzBakedModel bakedModel() {
        return this.bakedModel;
    }

    public class_4597 multiBufferSource() {
        return this.multiBufferSource;
    }

    public float red() {
        return this.red;
    }

    public float green() {
        return this.green;
    }

    public float blue() {
        return this.blue;
    }

    public float alpha() {
        return this.alpha;
    }

    public void setRed(float red) {
        this.red = red;
    }

    public void setGreen(float green) {
        this.green = green;
    }

    public void setBlue(float blue) {
        this.blue = blue;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    public void setColor(Color color) {
        this.red = color.getRedFloat();
        this.green = color.getGreenFloat();
        this.blue = color.getBlueFloat();
    }

    public int packedLight() {
        return this.packedLight;
    }

    public void setPackedLight(int packedLight) {
        this.packedLight = packedLight;
    }

    public int packedOverlay() {
        return this.packedOverlay;
    }

    public void setPackedOverlay(int packedOverlay) {
        this.packedOverlay = packedOverlay;
    }

    public float partialTick() {
        return this.partialTick;
    }

    public class_4587 poseStack() {
        return this.poseStack;
    }

    public class_1921 renderType() {
        return this.renderType;
    }

    public void setRenderType(class_1921 renderType) {
        this.renderType = renderType;
    }

    public class_4588 vertexConsumer() {
        return this.vertexConsumer;
    }

    public void setVertexConsumer(class_4588 vertexConsumer) {
        this.vertexConsumer = vertexConsumer;
    }

    public void setTextureOverride(class_2960 textureOverride) {
        this.textureOverride = textureOverride;
    }

    public class_2960 getTextureOverride() {
        return this.textureOverride;
    }

    public IntIntPair computeTextureSize(class_2960 texture) {
        return TEXTURE_DIMENSIONS_CACHE.computeIfAbsent(texture, RenderUtils::getTextureDimensions);
    }
}

