/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.rewrite.render.block;

import mod.azure.azurelib.cache.texture.AnimatableTexture;
import mod.azure.azurelib.rewrite.render.AzLayerRenderer;
import mod.azure.azurelib.rewrite.render.AzModelRenderer;
import mod.azure.azurelib.rewrite.render.AzRendererConfig;
import mod.azure.azurelib.rewrite.render.AzRendererPipeline;
import mod.azure.azurelib.rewrite.render.AzRendererPipelineContext;
import mod.azure.azurelib.rewrite.render.block.AzBlockEntityRenderer;
import mod.azure.azurelib.rewrite.render.block.AzBlockEntityRendererConfig;
import mod.azure.azurelib.rewrite.render.block.AzBlockEntityRendererPipelineContext;
import net.minecraft.class_2586;
import net.minecraft.class_4587;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class AzBlockEntityRendererPipeline<T extends class_2586>
extends AzRendererPipeline<T> {
    private final AzBlockEntityRenderer<T> blockEntityRenderer;
    protected Matrix4f entityRenderTranslations = new Matrix4f();
    protected Matrix4f modelRenderTranslations = new Matrix4f();

    public AzBlockEntityRendererPipeline(AzBlockEntityRendererConfig<T> config, AzBlockEntityRenderer<T> blockEntityRenderer) {
        super(config);
        this.blockEntityRenderer = blockEntityRenderer;
    }

    @Override
    protected AzBlockEntityRendererPipelineContext<T> createContext(AzRendererPipeline<T> rendererPipeline) {
        return (AzBlockEntityRendererPipelineContext)this.config.pipelineContext(this);
    }

    @Override
    protected AzModelRenderer<T> createModelRenderer(AzLayerRenderer<T> layerRenderer) {
        return this.config.modelRendererProvider(this, layerRenderer);
    }

    @Override
    protected AzLayerRenderer<T> createLayerRenderer(AzRendererConfig<T> config) {
        return new AzLayerRenderer(config::renderLayers);
    }

    @Override
    public void updateAnimatedTextureFrame(T entity) {
        AnimatableTexture.setAndUpdate(this.config.textureLocation(entity));
    }

    @Override
    public void preRender(AzRendererPipelineContext<T> context, boolean isReRender) {
        class_4587 poseStack = context.poseStack();
        this.entityRenderTranslations.set((Matrix4fc)poseStack.method_23760().method_23761());
        float scaleWidth = this.config.scaleWidth((class_2586)context.animatable());
        float scaleHeight = this.config.scaleHeight((class_2586)context.animatable());
        this.scaleModelForRender(context, scaleWidth, scaleHeight, isReRender);
        if (this.config.alpha((class_2586)context.animatable()) < 1.0f) {
            context.setAlpha(this.config.alpha((class_2586)context.animatable()));
        }
        this.config.preRenderEntry(context);
    }

    @Override
    public void postRender(AzRendererPipelineContext<T> context, boolean isReRender) {
        this.config.postRenderEntry(context);
    }

    public AzBlockEntityRenderer<T> getRenderer() {
        return this.blockEntityRenderer;
    }
}

