/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelibarmor.core.animation;

import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import mod.azure.azurelibarmor.core.animatable.GeoAnimatable;
import mod.azure.azurelibarmor.core.animation.AnimationController;
import mod.azure.azurelibarmor.core.object.DataTicket;
import mod.azure.azurelibarmor.core.state.BoneSnapshot;

public class AnimatableManager<T extends GeoAnimatable> {
    private final Map<String, BoneSnapshot> boneSnapshotCollection = new Object2ObjectOpenHashMap();
    private final Map<String, AnimationController<T>> animationControllers;
    private Map<DataTicket<?>, Object> extraData;
    private double lastUpdateTime;
    private boolean isFirstTick = true;
    private double firstTickTime = -1.0;

    public AnimatableManager(GeoAnimatable animatable) {
        ControllerRegistrar registrar = new ControllerRegistrar();
        animatable.registerControllers(registrar);
        this.animationControllers = registrar.build();
    }

    public void addController(AnimationController<T> controller) {
        this.animationControllers.put(controller.getName(), controller);
    }

    public void removeController(String name) {
        this.animationControllers.remove(name);
    }

    public Map<String, AnimationController<T>> getAnimationControllers() {
        return this.animationControllers;
    }

    public Map<String, BoneSnapshot> getBoneSnapshotCollection() {
        return this.boneSnapshotCollection;
    }

    public void clearSnapshotCache() {
        this.boneSnapshotCollection.clear();
    }

    public double getLastUpdateTime() {
        return this.lastUpdateTime;
    }

    public void updatedAt(double updateTime) {
        this.lastUpdateTime = updateTime;
    }

    public double getFirstTickTime() {
        return this.firstTickTime;
    }

    public void startedAt(double time) {
        this.firstTickTime = time;
    }

    public boolean isFirstTick() {
        return this.isFirstTick;
    }

    protected void finishFirstTick() {
        this.isFirstTick = false;
    }

    public <D> void setData(DataTicket<D> dataTicket, D data) {
        if (this.extraData == null) {
            this.extraData = new Object2ObjectOpenHashMap();
        }
        this.extraData.put(dataTicket, data);
    }

    public <D> D getData(DataTicket<D> dataTicket) {
        return this.extraData != null ? (D)dataTicket.getData(this.extraData) : null;
    }

    public void tryTriggerAnimation(String animName) {
        for (AnimationController<T> controller : this.getAnimationControllers().values()) {
            if (!controller.tryTriggerAnimation(animName)) continue;
            return;
        }
    }

    public void tryTriggerAnimation(String controllerName, String animName) {
        AnimationController<T> controller = this.getAnimationControllers().get(controllerName);
        if (controller != null) {
            controller.tryTriggerAnimation(animName);
        }
    }

    public static final class ControllerRegistrar {
        private final List<AnimationController<? extends GeoAnimatable>> controllers = new ObjectArrayList(4);

        public ControllerRegistrar add(AnimationController<?> ... controllers) {
            this.controllers.addAll(Arrays.asList(controllers));
            return this;
        }

        public ControllerRegistrar remove(String name) {
            this.controllers.removeIf(controller -> controller.getName().equals(name));
            return this;
        }

        private <T extends GeoAnimatable> Object2ObjectArrayMap<String, AnimationController<T>> build() {
            Object2ObjectArrayMap map = new Object2ObjectArrayMap(this.controllers.size());
            this.controllers.forEach(controller -> map.put((Object)controller.getName(), controller));
            return map;
        }
    }
}

