/*
 * Decompiled with CFR 0.152.
 */
package com.khazoda.basicstorage.block;

import com.khazoda.basicstorage.block.entity.CrateBlockEntity;
import com.khazoda.basicstorage.registry.BlockRegistry;
import com.khazoda.basicstorage.registry.ItemRegistry;
import com.khazoda.basicstorage.registry.SoundRegistry;
import com.khazoda.basicstorage.storage.CrateSlot;
import com.khazoda.basicstorage.storage.CrateStationHelper;
import com.khazoda.basicstorage.util.BlockUtils;
import com.khazoda.basicstorage.util.NumberFormatter;
import java.util.List;
import java.util.Random;
import net.fabricmc.fabric.api.event.player.UseBlockCallback;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.item.PlayerInventoryStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageUtil;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_10;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2415;
import net.minecraft.class_2464;
import net.minecraft.class_2470;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5250;
import net.minecraft.class_5712;
import net.minecraft.class_8567;
import org.jetbrains.annotations.Nullable;

public class CrateBlock
extends class_2237
implements class_2343 {
    public static final class_2753 FACING = class_2741.field_12481;
    private static Random random;

    public CrateBlock(class_4970.class_2251 settings) {
        super(settings);
        random = new Random();
        this.method_9590((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)FACING, (Comparable)class_2350.field_11043));
    }

    public static void initOnUseMethod() {
        UseBlockCallback.EVENT.register((player, world, hand, hit) -> {
            if (!world.method_8320(hit.method_17777()).method_27852(BlockRegistry.CRATE_BLOCK)) {
                return class_1269.field_5811;
            }
            if (!player.method_7294() || player.method_7325()) {
                return class_1269.field_5811;
            }
            class_2338 pos = hit.method_17777();
            class_2680 state = world.method_8320(pos);
            class_2586 be = world.method_8321(pos);
            class_2350 facing = (class_2350)state.method_11654((class_2769)class_2741.field_12481);
            if (be == null) {
                return class_1269.field_5811;
            }
            if (facing != hit.method_17780()) {
                return class_1269.field_5811;
            }
            CrateBlockEntity cbe = (CrateBlockEntity)be;
            class_1799 playerStack = player.method_6047();
            if (playerStack.method_31574(ItemRegistry.CRATE_HAMMER_ITEM)) {
                return class_1269.field_5811;
            }
            CrateSlot slot = cbe.storage;
            if (playerStack.method_31574(class_1802.field_8688)) {
                return CrateBlock.debugInitOnUseMethod(player, slot);
            }
            try (Transaction t = Transaction.openOuter();){
                int inserted = 0;
                if (player.method_5715()) {
                    if (!CrateBlock.canInsert(playerStack, slot, true)) {
                        class_1269 class_12692 = CrateBlock.listExactContents(player, slot);
                        return class_12692;
                    }
                    inserted = CrateBlock.insertMaximum(player, playerStack, slot, t);
                } else if (!player.method_5715()) {
                    if (!CrateBlock.canInsert(playerStack, slot, false)) {
                        class_1269 class_12693 = CrateBlock.listExactContents(player, slot);
                        return class_12693;
                    }
                    inserted = CrateBlock.insertOne(playerStack, slot, t);
                }
                if (inserted == 0) {
                    t.abort();
                    class_1269 class_12694 = class_1269.field_33562;
                    return class_12694;
                }
                t.commit();
                if (inserted == 1) {
                    world.method_8486((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), SoundRegistry.HANDLE_ONE, class_3419.field_15245, 1.0f, 1.0f + (-1.0f + random.nextFloat() * 2.0f) / 10.0f, false);
                }
                if (inserted > 1) {
                    world.method_8486((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), SoundRegistry.HANDLE_MANY, class_3419.field_15245, 1.0f, 1.0f, false);
                }
                state.method_30101((class_1936)world, pos, 1);
                cbe.refresh();
                world.method_8455(pos, state.method_26204());
                player.method_7259(class_3468.field_15372.method_14956((Object)playerStack.method_7909()));
                world.method_33596((class_1297)player, class_5712.field_28733, pos);
                class_1269 class_12695 = class_1269.field_5812;
                return class_12695;
            }
        });
    }

    private static int insertOne(class_1799 playerStack, CrateSlot slot, Transaction t) {
        if (playerStack.method_7960()) {
            return 0;
        }
        int inserted = (int)slot.insert(ItemVariant.of((class_1799)playerStack), 1L, (TransactionContext)t);
        playerStack.method_7934(inserted);
        return inserted;
    }

    private static int insertMaximum(class_1657 player, class_1799 playerStack, CrateSlot slot, Transaction transaction) {
        if (slot.isBlank() && playerStack.method_7960()) {
            return 0;
        }
        if (slot.isBlank() && !playerStack.method_7960()) {
            int i = (int)slot.insert(ItemVariant.of((class_1799)playerStack), (long)playerStack.method_7947(), (TransactionContext)transaction);
            playerStack.method_7934(i);
            return i;
        }
        return (int)StorageUtil.move((Storage)PlayerInventoryStorage.of((class_1657)player), (Storage)slot, itemVariant -> true, (long)Integer.MAX_VALUE, (TransactionContext)transaction);
    }

    private static class_1269 listExactContents(class_1657 player, CrateSlot slot) {
        class_5250 message = slot.isBlank() ? class_2561.method_43471((String)"message.basicstorage.crate.empty").method_27694(s -> s.method_36139(0xFFDD99)) : class_2561.method_43470((String)(NumberFormatter.toFormattedNumber(slot.getAmount()) + " " + slot.getResource().getItem().method_7848().getString())).method_27694(s -> s.method_36139(0xFFDD99));
        player.method_7353((class_2561)message, true);
        return class_1269.field_21466;
    }

    public static boolean canInsert(class_1799 stack, CrateSlot slot, boolean insertingMultiple) {
        if (insertingMultiple) {
            return !slot.isBlank() || CrateBlock.canInsert(stack, slot, false);
        }
        if (stack.method_7960()) {
            return false;
        }
        if (stack.method_7986()) {
            return false;
        }
        if (stack.method_31574(BlockRegistry.CRATE_BLOCK.method_8389()) && stack.method_7948().method_10562("BlockEntityTag").method_10545("crate_contents")) {
            return false;
        }
        if (!ItemVariant.of((class_1799)stack).equals(slot.getResource()) && !slot.isBlank()) {
            return false;
        }
        return slot.isBlank() || stack.method_31574(slot.getResource().getItem());
    }

    public void method_9606(class_2680 state, class_1937 world, class_2338 pos, class_1657 player) {
        if (!player.method_7294()) {
            return;
        }
        CrateBlockEntity cbe = (CrateBlockEntity)world.method_8321(pos);
        if (cbe == null) {
            return;
        }
        if (cbe.storage.isBlank()) {
            return;
        }
        class_3965 hit = BlockUtils.getHitResult(player, pos);
        if (hit.method_17783() == class_239.class_240.field_1333) {
            return;
        }
        class_2350 facing = (class_2350)state.method_11654((class_2769)class_2741.field_12481);
        if (facing != hit.method_17780()) {
            return;
        }
        try (Transaction t = Transaction.openOuter();){
            ItemVariant item = cbe.storage.getResource();
            int extracted = (int)cbe.storage.extract(item, player.method_5715() ? (long)item.getItem().method_7882() : 1L, (TransactionContext)t);
            if (extracted == 0) {
                t.abort();
                return;
            }
            player.method_31548().method_7398(item.toStack(extracted));
            t.commit();
            if (extracted == 1) {
                world.method_8486((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), SoundRegistry.HANDLE_ONE, class_3419.field_15245, 0.6f, 1.2f + (-1.0f + random.nextFloat() * 2.0f) / 10.0f, false);
            }
            if (extracted > 1) {
                world.method_8486((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), SoundRegistry.HANDLE_MANY, class_3419.field_15245, 0.75f, 1.0f, false);
            }
            world.method_8486((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), class_3417.field_15197, class_3419.field_15245, 0.35f, 1.0f, false);
        }
        cbe.refresh();
        state.method_30101((class_1936)world, pos, 1);
        world.method_8455(pos, state.method_26204());
        world.method_33596((class_1297)player, class_5712.field_28733, pos);
    }

    public void method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        class_2586 be = world.method_8321(pos);
        if (be != null) {
            CrateBlockEntity cbe = (CrateBlockEntity)be;
            if (!world.method_8608() && player.method_7337() && !cbe.storage.getResource().toStack().method_7960()) {
                CrateBlock.method_9609((class_2680)state, (class_3218)((class_3218)world), (class_2338)pos, (class_2586)cbe, (class_1297)player, (class_1799)player.method_5998(class_1268.field_5808)).forEach(stack -> class_1264.method_5449((class_1937)world, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), (class_1799)stack));
            }
        }
    }

    public List<class_1799> method_9560(class_2680 state, class_8567.class_8568 builder) {
        return super.method_9560(state, builder);
    }

    public void method_9568(class_1799 stack, @Nullable class_1922 world, List<class_2561> tooltip, class_1836 options) {
        class_2487 nbt = stack.method_7948().method_10562("BlockEntityTag");
        if (!nbt.method_10545("crate_contents")) {
            return;
        }
        class_2487 crateContents = nbt.method_10562("crate_contents");
        ItemVariant item = ItemVariant.fromNbt((class_2487)nbt.method_10562("item"));
        int count = crateContents.method_10550("count");
        class_5250 contents_line_2 = class_2561.method_43470((String)item.getItem().method_7848().getString()).method_27694(s -> s.method_36139(0xCCAA77));
        class_5250 contents_line_1 = class_2561.method_43470((String)("x" + NumberFormatter.toFormattedNumber(count))).method_27694(s -> s.method_36139(0xFFDD99));
        tooltip.add((class_2561)contents_line_1);
        tooltip.add((class_2561)contents_line_2);
    }

    public static class_2350 getFront(class_2680 state) {
        return (class_2350)state.method_11654((class_2769)FACING);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING});
    }

    public boolean method_9516(class_2680 state, class_1922 world, class_2338 pos, class_10 type) {
        return false;
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new CrateBlockEntity(pos, state);
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        return (class_2680)this.method_9564().method_11657((class_2769)class_2741.field_12481, (Comparable)ctx.method_8042().method_10153());
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        if (state.method_27852(newState.method_26204())) {
            return;
        }
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof CrateBlockEntity) {
            world.method_8455(pos, state.method_26204());
            CrateStationHelper.notifyNearbyStations(world, pos);
            world.method_33596(null, class_5712.field_28165, pos);
        }
        super.method_9536(state, world, pos, newState, moved);
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return (class_2680)state.method_11657((class_2769)FACING, (Comparable)rotation.method_10503((class_2350)state.method_11654((class_2769)FACING)));
    }

    public class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_26186(mirror.method_10345((class_2350)state.method_11654((class_2769)FACING)));
    }

    public boolean method_9498(class_2680 state) {
        return true;
    }

    public int method_9572(class_2680 state, class_1937 world, class_2338 pos) {
        class_2586 be = world.method_8321(pos);
        if (be instanceof CrateBlockEntity) {
            CrateBlockEntity cbe = (CrateBlockEntity)be;
            return BlockUtils.getComparatorOutputStrength(Math.toIntExact(cbe.storage.getAmount()));
        }
        return 0;
    }

    private static class_1269 debugInitOnUseMethod(class_1657 player, CrateSlot slot) {
        try (Transaction t = Transaction.openOuter();){
            if (slot.isBlank()) {
                class_1269 class_12692 = class_1269.field_5811;
                return class_12692;
            }
            if (player.method_5715()) {
                slot.extract(slot.getResource(), 10000L, (TransactionContext)t);
            }
            if (!player.method_5715()) {
                slot.insert(slot.getResource(), 100000L, (TransactionContext)t);
            }
            t.commit();
        }
        slot.triggerRefresh();
        return class_1269.field_5812;
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        super.method_9567(world, pos, state, placer, itemStack);
        CrateStationHelper.notifyNearbyStations(world, pos);
        world.method_33596((class_1297)placer, class_5712.field_28164, pos);
    }
}

