/*
 * Decompiled with CFR 0.152.
 */
package com.khazoda.basicstorage.block.entity;

import com.khazoda.basicstorage.block.entity.CrateBlockEntity;
import com.khazoda.basicstorage.registry.BlockEntityRegistry;
import com.khazoda.basicstorage.storage.CrateSlot;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;

public class CrateStationBlockEntity
extends class_2586 {
    private final Map<ItemVariant, List<class_2338>> crateRegistry = new HashMap<ItemVariant, List<class_2338>>();
    private final Set<class_2338> connectedCrates = new HashSet<class_2338>();
    public static final int MAX_RADIUS = 16;
    private boolean needsCacheUpdate = true;

    public CrateStationBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntityRegistry.CRATE_STATION_BLOCK_ENTITY, pos, state);
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, CrateStationBlockEntity be) {
        if (be.needsCacheUpdate) {
            be.buildCrateCache();
            be.needsCacheUpdate = false;
        }
    }

    private void buildCrateCache() {
        if (this.field_11863 == null || this.field_11863.field_9236) {
            return;
        }
        this.crateRegistry.clear();
        this.connectedCrates.clear();
        LinkedList<class_2338> toExplore = new LinkedList<class_2338>();
        HashSet<class_2338> visited = new HashSet<class_2338>();
        toExplore.add(this.field_11867);
        while (!toExplore.isEmpty()) {
            class_2338 current = (class_2338)toExplore.poll();
            if (visited.contains(current) || !this.isWithinRange(current)) continue;
            visited.add(current);
            class_2586 be = this.field_11863.method_8321(current);
            if (be instanceof CrateStationBlockEntity) {
                this.addDirectionsToExplore(toExplore, current);
            }
            if (!(be instanceof CrateBlockEntity)) continue;
            CrateBlockEntity crate = (CrateBlockEntity)be;
            this.registerCrate(current, crate.storage);
            this.addDirectionsToExplore(toExplore, current);
        }
        this.method_5431();
    }

    private void addDirectionsToExplore(Queue<class_2338> blockPositionExplorationQueue, class_2338 currentBlockPosition) {
        for (class_2350 dir : class_2350.values()) {
            blockPositionExplorationQueue.add(currentBlockPosition.method_10093(dir));
        }
    }

    private void registerCrate(class_2338 cratePos, CrateSlot storage) {
        if (!storage.isBlank()) {
            ItemVariant variant = storage.getResource();
            this.crateRegistry.computeIfAbsent(variant, k -> new ArrayList()).add(cratePos);
            this.connectedCrates.add(cratePos);
        }
    }

    private boolean isWithinRange(class_2338 target) {
        return Math.abs(target.method_10263() - this.field_11867.method_10263()) <= 16 && Math.abs(target.method_10264() - this.field_11867.method_10264()) <= 16 && Math.abs(target.method_10260() - this.field_11867.method_10260()) <= 16;
    }

    public void method_11012() {
        this.crateRegistry.clear();
        this.connectedCrates.clear();
        super.method_11012();
    }

    public void markCacheForUpdate() {
        this.needsCacheUpdate = true;
        this.method_5431();
    }

    public Set<class_2338> getConnectedCrates() {
        return this.connectedCrates;
    }

    public Map<ItemVariant, List<class_2338>> getCrateRegistry() {
        return this.crateRegistry;
    }
}

