/*
 * Decompiled with CFR 0.152.
 */
package com.khazoda.basicstorage.config;

import com.khazoda.basicstorage.Constants;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;
import net.fabricmc.loader.api.FabricLoader;

public class ModConfig {
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("basicstorage.properties");
    private static ModConfig INSTANCE;
    private final Properties properties = new Properties();

    private ModConfig() {
    }

    public static ModConfig getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ModConfig();
        }
        return INSTANCE;
    }

    public void load() {
        try {
            if (!Files.exists(CONFIG_PATH, new LinkOption[0])) {
                Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
                try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_PATH, new OpenOption[0]);){
                    writer.write("# Basic Storage Configuration\n\n");
                    writer.write("# If true, crates can only be broken using the Crate Hammer.\n");
                    writer.write("# If false, crates can also be broken with an axe or by hand.\n");
                    writer.write("breakOnlyWithHammer=false\n\n");
                    writer.write("# The durability of the Crate Hammer.\n");
                    writer.write("# Default: 0 (Does not lose durability; Any value above 0 will give the hammer durability)\n");
                    writer.write("crateHammerDurability=0\n");
                }
            }
            try (BufferedReader reader = Files.newBufferedReader(CONFIG_PATH);){
                this.properties.load(reader);
            }
            Constants.BS_LOG.info("[Basic Storage] Config loaded successfully");
        }
        catch (IOException e) {
            Constants.BS_LOG.error("[Basic Storage] Failed to load config: " + e.getMessage());
        }
    }

    public void save() {
        try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_PATH, new OpenOption[0]);){
            this.properties.store(writer, "Basic Storage Configuration");
        }
        catch (IOException e) {
            Constants.BS_LOG.error("[Basic Storage] Failed to save config: " + e.getMessage());
        }
    }

    public boolean isbreakOnlyWithHammer() {
        return Boolean.parseBoolean(this.properties.getProperty("breakOnlyWithHammer", "false"));
    }

    public int getCrateHammerDurability() {
        try {
            return Math.max(0, Integer.parseInt(this.properties.getProperty("crateHammerDurability", "0")));
        }
        catch (NumberFormatException e) {
            Constants.BS_LOG.warn("[Basic Storage] Invalid crateHammerDurability value in config, using default");
            return 0;
        }
    }
}

