/*
 * Decompiled with CFR 0.152.
 */
package com.khazoda.basicstorage.renderer;

import com.khazoda.basicstorage.block.CrateBlock;
import com.khazoda.basicstorage.block.entity.CrateBlockEntity;
import com.khazoda.basicstorage.mixin.RenderSystemAccessor;
import com.khazoda.basicstorage.util.NumberFormatter;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.minecraft.class_1087;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5614;
import net.minecraft.class_746;
import net.minecraft.class_761;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import net.minecraft.class_827;
import net.minecraft.class_918;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

@Environment(value=EnvType.CLIENT)
public class CrateBlockEntityRenderer
implements class_827<CrateBlockEntity> {
    private static final Quaternionf ITEM_LIGHT_ROTATION_3D = class_7833.field_40714.rotationDegrees(-15.0f).mul((Quaternionfc)class_7833.field_40716.rotationDegrees(15.0f));
    private static final Quaternionf ITEM_LIGHT_ROTATION_FLAT = class_7833.field_40714.rotationDegrees(-45.0f);
    private final class_918 itemRenderer;
    private final class_327 textRenderer;

    public CrateBlockEntityRenderer(class_5614.class_5615 context) {
        this.itemRenderer = context.method_43335();
        this.textRenderer = context.method_32143();
    }

    public void render(CrateBlockEntity be, float tickDelta, class_4587 matrices, class_4597 vertexConsumers, int light, int overlay) {
        class_2350 horizontalDir = (class_2350)be.method_11010().method_11654((class_2769)CrateBlock.FACING);
        class_2350 dir = CrateBlock.getFront(be.method_11010());
        class_1937 world = be.method_10997();
        ItemVariant itemVariant = be.storage.getResource();
        String itemCount = String.valueOf(be.storage.getAmount());
        class_2338 pos = be.method_11016();
        if (!this.shouldRenderBE(be, dir)) {
            return;
        }
        matrices.method_22903();
        this.alignMatrices(matrices, horizontalDir);
        light = class_761.method_23794((class_1920)((class_1920)Objects.requireNonNull(be.method_10997())), (class_2338)pos.method_10093(dir));
        this.renderCrateInfo(itemVariant, itemCount, matrices, vertexConsumers, light, (int)pos.method_10063(), pos, world);
        matrices.method_22909();
    }

    public void renderCrateInfo(ItemVariant item, @Nullable String amount, class_4587 matrices, class_4597 vertexConsumers, int light, int seed, class_2338 pos, class_1937 world) {
        if (amount == null || amount.equals("0")) {
            return;
        }
        class_746 player = class_310.method_1551().field_1724;
        class_243 playerPos = player == null ? class_243.method_24953((class_2382)pos) : player.method_19538();
        int distance = 0;
        if (player != null) {
            distance = player.method_31550() ? 100 : 40;
        }
        if (pos.method_19769((class_2374)playerPos, (double)distance)) {
            this.renderText(amount, light, matrices, vertexConsumers);
            this.renderItem(item, light, matrices, vertexConsumers, world, seed);
        }
    }

    public void renderItem(ItemVariant item, int light, class_4587 matrices, class_4597 vertexConsumers, class_1937 world, int seed) {
        if (item.isBlank()) {
            return;
        }
        matrices.method_22903();
        matrices.method_46416(0.0f, 0.125f, 0.0f);
        matrices.method_22905(0.5f, 0.5f, 0.5f);
        matrices.method_22905(0.75f, 0.75f, 1.0f);
        matrices.method_23760().method_23761().mul((Matrix4fc)new Matrix4f().scale(1.0f, 1.0f, 0.01f));
        class_1799 stack = item.toStack();
        class_1087 model = this.itemRenderer.method_4019(stack, world, null, seed);
        Vector3f[] lights = new Vector3f[2];
        System.arraycopy(RenderSystemAccessor.getShaderLightDirections(), 0, lights, 0, 2);
        if (model.method_24304()) {
            matrices.method_23760().method_23762().rotate((Quaternionfc)ITEM_LIGHT_ROTATION_3D);
            class_308.method_24211();
        } else {
            matrices.method_23760().method_23762().rotate((Quaternionfc)ITEM_LIGHT_ROTATION_FLAT);
            class_308.method_24210();
        }
        this.itemRenderer.method_23179(stack, class_811.field_4317, false, matrices, vertexConsumers, light, class_4608.field_21444, model);
        System.arraycopy(lights, 0, RenderSystemAccessor.getShaderLightDirections(), 0, 2);
        matrices.method_22909();
    }

    public void renderText(String count, int light, class_4587 matrices, class_4597 vertexConsumers) {
        matrices.method_22903();
        matrices.method_22907(class_7833.field_40714.rotationDegrees(180.0f));
        matrices.method_46416(0.0f, 0.21f, -0.01f);
        String formattedCount = NumberFormatter.format(Integer.parseInt(count));
        matrices.method_22905(0.02f, 0.02f, 0.02f);
        this.textRenderer.method_27521(formattedCount, (float)(-this.textRenderer.method_1727(formattedCount)) / 2.0f, 0.0f, 0xFFDD99, false, matrices.method_23760().method_23761(), vertexConsumers, class_327.class_6415.field_33993, 0, light);
        matrices.method_22909();
    }

    protected void alignMatrices(class_4587 matrices, class_2350 dir) {
        Vector3f pos = dir.method_23955();
        matrices.method_22904((double)(pos.x / 2.0f) + 0.5, (double)(pos.y / 2.0f) + 0.5, (double)(pos.z / 2.0f) + 0.5);
        matrices.method_23760().method_23761().rotate((Quaternionfc)dir.method_23224());
        matrices.method_23760().method_23761().rotate((Quaternionfc)class_7833.field_40714.rotationDegrees(-90.0f));
        matrices.method_22904(0.0, 0.0, 0.01);
    }

    public final boolean shouldRenderBE(class_2586 be, class_2350 facing) {
        class_1937 world = be.method_10997();
        if (world == null) {
            return false;
        }
        class_2338 pos = be.method_11016();
        class_2680 state = be.method_11010();
        return class_2248.method_9607((class_2680)state, (class_1922)world, (class_2338)pos, (class_2350)facing, (class_2338)pos.method_10093(facing));
    }
}

