/*
 * Decompiled with CFR 0.152.
 */
package com.khazoda.basicstorage.storage;

import com.khazoda.basicstorage.block.CrateBlock;
import com.khazoda.basicstorage.block.entity.CrateBlockEntity;
import com.khazoda.basicstorage.storage.CrateStationHelper;
import com.khazoda.basicstorage.storage.CrateStorage;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.ResourceAmount;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_2487;
import net.minecraft.class_2520;

public final class CrateSlot
extends SnapshotParticipant<Snapshot>
implements SingleSlotStorage<ItemVariant>,
CrateStorage {
    private ItemVariant item = ItemVariant.blank();
    private int count;
    private final CrateBlockEntity owner;
    private boolean markedDirty;

    public CrateSlot(CrateBlockEntity owner) {
        this.owner = owner;
        this.markedDirty = false;
    }

    @Override
    public CrateBlockEntity getOwner() {
        return this.owner;
    }

    public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        boolean wasBlank = this.isBlank();
        if (!CrateBlock.canInsert(resource.toStack(), this, maxAmount > 1L)) {
            return 0L;
        }
        if (maxAmount > 1L && !resource.equals(this.getResource()) && !this.isBlank()) {
            return 0L;
        }
        int inserted = (int)Math.min(this.getCapacity() - (long)this.count, maxAmount);
        if (inserted > 0) {
            this.updateSnapshots(transaction);
            this.count += inserted;
            if (this.item.isBlank()) {
                this.item = resource;
                this.markedDirty = true;
            }
            if (wasBlank) {
                transaction.addOuterCloseCallback(result -> {
                    if (this.owner.method_10997() != null) {
                        CrateStationHelper.notifyNearbyStations(this.owner.method_10997(), this.owner.method_11016());
                    }
                });
            }
        } else if (inserted < 0) {
            return 0L;
        }
        return inserted;
    }

    public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        long amountBefore = this.count;
        if (!resource.equals(this.item)) {
            return 0L;
        }
        int extracted = (int)Math.min((long)this.count, maxAmount);
        if (extracted > 0) {
            this.updateSnapshots(transaction);
            this.count -= extracted;
            if (this.count == 0) {
                this.item = ItemVariant.blank();
                this.markedDirty = true;
            }
            if (amountBefore == (long)extracted) {
                transaction.addOuterCloseCallback(result -> {
                    if (this.owner.method_10997() != null) {
                        CrateStationHelper.notifyNearbyStations(this.owner.method_10997(), this.owner.method_11016());
                    }
                });
            }
        } else if (extracted < 0) {
            return 0L;
        }
        return extracted;
    }

    public boolean isResourceBlank() {
        return this.item.isBlank();
    }

    public ItemVariant getResource() {
        return this.item;
    }

    public long getAmount() {
        return this.count;
    }

    @Override
    public long getCapacity() {
        return 1000000000L;
    }

    protected Snapshot createSnapshot() {
        return new Snapshot((ResourceAmount<ItemVariant>)new ResourceAmount((Object)this.item, (long)this.count), this.markedDirty);
    }

    protected void readSnapshot(Snapshot snapshot) {
        this.item = (ItemVariant)snapshot.contents.resource();
        this.count = (int)snapshot.contents.amount();
        this.markedDirty = snapshot.itemChanged;
    }

    protected void onFinalCommit() {
        this.triggerRefresh();
    }

    public void readNbt(class_2487 nbt) {
        this.item = ItemVariant.fromNbt((class_2487)nbt.method_10562("item"));
        this.count = (int)nbt.method_10537("count");
        if (this.item.isBlank()) {
            this.count = 0;
        }
    }

    public void writeNbt(class_2487 nbt) {
        nbt.method_10566("item", (class_2520)this.item.toNbt());
        nbt.method_10544("count", (long)this.count);
    }

    @Override
    public boolean isBlank() {
        return this.isResourceBlank();
    }

    protected record Snapshot(ResourceAmount<ItemVariant> contents, boolean itemChanged) {
    }
}

