/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.batsgalore;

import com.nyfaria.batsgalore.Constants;
import com.nyfaria.batsgalore.block.WoodCollection;
import com.nyfaria.batsgalore.init.BlockInit;
import com.nyfaria.batsgalore.init.ItemInit;
import com.nyfaria.batsgalore.init.TagInit;
import com.nyfaria.batsgalore.init.WorldGenInit;
import com.nyfaria.batsgalore.init.entity.EntityInit;
import com.nyfaria.batsgalore.worldgen.BatsGaloreOverworldRegion;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.class_1959;
import net.minecraft.class_2248;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_3195;
import net.minecraft.class_5321;
import net.minecraft.class_6796;
import net.minecraft.class_7924;
import terrablender.api.Region;
import terrablender.api.Regions;

public class CommonClass {
    public static List<LocalDate> BIGGEST_FAN_SPAWN_DATES = new ArrayList<LocalDate>();
    public static final class_5321<class_1959> SPOOKY_OAK_FOREST = class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)new class_2960("batsgalore", "spooky_oak_forest"));
    public static final class_5321<class_1959> CHRISTMAS_FOREST = class_5321.method_29179((class_5321)class_7924.field_41236, (class_2960)new class_2960("batsgalore", "christmas_forest"));
    public static final class_5321<class_6796> SPOOKY_OAK_TREE = class_5321.method_29179((class_5321)class_7924.field_41245, (class_2960)new class_2960("batsgalore", "spooky_oak"));
    public static final class_5321<class_6796> WHITE_PINE_TREE = class_5321.method_29179((class_5321)class_7924.field_41245, (class_2960)new class_2960("batsgalore", "white_pine"));
    public static final class_5321<class_6796> MEGA_WHITE_PINE_TREE = class_5321.method_29179((class_5321)class_7924.field_41245, (class_2960)new class_2960("batsgalore", "mega_white_pine"));
    public static final class_5321<class_6796> DECORATED_WHITE_PINE_TREE = class_5321.method_29179((class_5321)class_7924.field_41245, (class_2960)new class_2960("batsgalore", "decorated_white_pine"));
    public static final class_5321<class_6796> DECORATED_MEGA_WHITE_PINE_TREE = class_5321.method_29179((class_5321)class_7924.field_41245, (class_2960)new class_2960("batsgalore", "decorated_mega_white_pine"));
    public static final class_5321<class_3195> ALTAR_OF_TURMOIL = class_5321.method_29179((class_5321)class_7924.field_41246, (class_2960)new class_2960("batsgalore", "altar_of_turmoil"));
    public static final class_5321<class_2975<?, ?>> SPOOKY_OAK_TREE_CF = class_5321.method_29179((class_5321)class_7924.field_41239, (class_2960)new class_2960("batsgalore", "spooky_oak"));
    public static final class_5321<class_2975<?, ?>> WHITE_PINE_TREE_CF = class_5321.method_29179((class_5321)class_7924.field_41239, (class_2960)new class_2960("batsgalore", "white_pine"));
    public static final class_5321<class_2975<?, ?>> DECORATED_WHITE_PINE_TREE_CF = class_5321.method_29179((class_5321)class_7924.field_41239, (class_2960)new class_2960("batsgalore", "decorated_white_pine"));
    public static final class_5321<class_2975<?, ?>> MEGA_WHITE_PINE_TREE_CF = class_5321.method_29179((class_5321)class_7924.field_41239, (class_2960)new class_2960("batsgalore", "mega_white_pine"));
    public static final class_5321<class_2975<?, ?>> DECORATED_MEGA_WHITE_PINE_TREE_CF = class_5321.method_29179((class_5321)class_7924.field_41239, (class_2960)new class_2960("batsgalore", "decorated_mega_white_pine"));

    public static void init() {
        ItemInit.loadClass();
        BlockInit.loadClass();
        EntityInit.loadClass();
        TagInit.loadClass();
        WorldGenInit.loadClass();
        try {
            HttpURLConnection spawnListURL = (HttpURLConnection)new URL("https://raw.githubusercontent.com/Nyfaria/SpookyBats/1.20.x/biggest_fan_spawn_dates.txt").openConnection();
            spawnListURL.setConnectTimeout(1000);
            spawnListURL.connect();
            if (200 != spawnListURL.getResponseCode()) {
                Constants.LOG.warn("Failed to connect to biggest fan spawn dates list, bat will not spawn");
            } else {
                String inputLine;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(spawnListURL.getInputStream()));
                while ((inputLine = bufferedReader.readLine()) != null) {
                    String[] date = inputLine.split("/");
                    BIGGEST_FAN_SPAWN_DATES.add(LocalDate.of(Integer.parseInt(date[0]), Integer.parseInt(date[1]), Integer.parseInt(date[2])));
                }
                bufferedReader.close();
            }
        }
        catch (IOException ignored) {
            Constants.LOG.warn("Failed to connect to biggest fan spawn dates list, bat will not spawn");
        }
    }

    public static void setupTerraBlender() {
        Regions.register((Region)new BatsGaloreOverworldRegion(1));
    }

    public static void setupBlockEntities() {
        HashSet hangingSignBlocks = new HashSet(class_2591.field_40330.field_19315);
        HashSet signBlocks = new HashSet(class_2591.field_11911.field_19315);
        WoodCollection.WOOD_COLLECTIONS.forEach(woodCollection -> {
            hangingSignBlocks.add((class_2248)woodCollection.hangingSign().get());
            hangingSignBlocks.add((class_2248)woodCollection.hangingWallSign().get());
            signBlocks.add((class_2248)woodCollection.sign().get());
            signBlocks.add((class_2248)woodCollection.wallSign().get());
        });
        class_2591.field_40330.field_19315 = hangingSignBlocks;
        class_2591.field_11911.field_19315 = signBlocks;
    }
}

