/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.batsgalore.init.entity;

import com.nyfaria.batsgalore.entity.BlockProjectile;
import com.nyfaria.batsgalore.entity.ModBoat;
import com.nyfaria.batsgalore.entity.ModChestBoat;
import com.nyfaria.batsgalore.entity.api.ModBat;
import com.nyfaria.batsgalore.init.ItemInit;
import com.nyfaria.batsgalore.init.entity.ChristmasBatEntityInit;
import com.nyfaria.batsgalore.init.entity.SpookyBatEntityInit;
import com.nyfaria.batsgalore.platform.Services;
import com.nyfaria.batsgalore.registration.RegistrationProvider;
import com.nyfaria.batsgalore.registration.RegistryObject;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1792;
import net.minecraft.class_5132;
import net.minecraft.class_7924;

public class EntityInit {
    public static final List<RegistryObject<? extends class_1299<? extends class_1309>>> BATS = new ArrayList<RegistryObject<? extends class_1299<? extends class_1309>>>();
    public static final RegistrationProvider<class_1299<?>> ENTITIES = RegistrationProvider.get(class_7924.field_41266, "batsgalore");
    public static final List<AttributesRegister<?>> attributeSuppliers = new ArrayList();
    public static final RegistryObject<class_1299<ModBat>> BIGGEST_FAN_BAT = EntityInit.registerEntityWithEgg("biggest_fan_bat", () -> class_1299.class_1300.method_5903(ModBat::new, (class_1311)class_1311.field_6302), ModBat::createBatAttributes, 0xBF1F1F, 4449522);
    public static final RegistryObject<class_1299<BlockProjectile>> BLOCK_PROJECTILE = EntityInit.registerEntity("block_projectile", () -> class_1299.class_1300.method_5903(BlockProjectile::new, (class_1311)class_1311.field_17715).method_17687(1.0f, 1.0f));
    public static final RegistryObject<class_1299<ModBoat>> MOD_BOAT = EntityInit.registerEntity("mod_boat", () -> class_1299.class_1300.method_5903(ModBoat::new, (class_1311)class_1311.field_17715).method_17687(1.375f, 0.5625f).method_27299(10));
    public static final RegistryObject<class_1299<ModChestBoat>> MOD_CHEST_BOAT = EntityInit.registerEntity("mod_chest_boat", () -> class_1299.class_1300.method_5903(ModChestBoat::new, (class_1311)class_1311.field_17715).method_17687(1.375f, 0.5625f).method_27299(10));

    protected static <T extends class_1297> RegistryObject<class_1299<T>> registerEntity(String name, Supplier<class_1299.class_1300<T>> supplier) {
        return ENTITIES.register(name, () -> ((class_1299.class_1300)supplier.get()).method_5905("batsgalore:" + name));
    }

    protected static <T extends class_1309> RegistryObject<class_1299<T>> registerLivingEntity(String name, Supplier<class_1299.class_1300<T>> supplier, Supplier<class_5132.class_5133> attributeSupplier) {
        RegistryObject<class_1299<T>> entityTypeSupplier = EntityInit.registerEntity(name, supplier);
        attributeSuppliers.add(new AttributesRegister(entityTypeSupplier, attributeSupplier));
        return entityTypeSupplier;
    }

    protected static <T extends class_1309> RegistryObject<class_1299<T>> registerEntityWithEgg(String name, Supplier<class_1299.class_1300<T>> supplier, Supplier<class_5132.class_5133> attributeSupplier, int secondaryColor) {
        return EntityInit.registerEntityWithEgg(name, supplier, attributeSupplier, 3747620, secondaryColor);
    }

    protected static <T extends class_1309> RegistryObject<class_1299<T>> registerEntityWithEgg(String name, Supplier<class_1299.class_1300<T>> supplier, Supplier<class_5132.class_5133> attributeSupplier, int primaryColor, int secondaryColor) {
        RegistryObject entityTypeSupplier = EntityInit.registerLivingEntity(name, supplier, attributeSupplier);
        RegistryObject<class_1792> item = ItemInit.ITEMS.register(name + "_spawn_egg", () -> Services.PLATFORM.createSpawnEggItem(entityTypeSupplier, primaryColor, secondaryColor));
        ItemInit.SPAWN_EGG_LIST.add(item);
        BATS.add(entityTypeSupplier);
        return entityTypeSupplier;
    }

    public static void loadClass() {
        SpookyBatEntityInit.loadClass();
        ChristmasBatEntityInit.loadClass();
    }

    public record AttributesRegister<E extends class_1309>(Supplier<class_1299<E>> entityTypeSupplier, Supplier<class_5132.class_5133> factory) {
    }
}

