/*
 * Decompiled with CFR 0.152.
 */
package net.bettercombat.api;

import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public final class WeaponAttributes {
    private final double attack_range;
    @Nullable
    private final String pose;
    @Nullable
    private final String off_hand_pose;
    private final Boolean two_handed;
    @Nullable
    private final String category;
    private final Attack[] attacks;

    public WeaponAttributes(double attack_range, @Nullable String pose, @Nullable String off_hand_pose, Boolean isTwoHanded, String category, Attack[] attacks) {
        this.attack_range = attack_range;
        this.pose = pose;
        this.off_hand_pose = off_hand_pose;
        this.two_handed = isTwoHanded;
        this.category = category;
        this.attacks = attacks;
    }

    public double attackRange() {
        return this.attack_range;
    }

    @Nullable
    public String pose() {
        return this.pose;
    }

    @Nullable
    public String offHandPose() {
        return this.off_hand_pose;
    }

    @Nullable
    public String category() {
        return this.category;
    }

    public boolean isTwoHanded() {
        return this.two_handed != null ? this.two_handed : false;
    }

    public Boolean two_handed() {
        return this.two_handed;
    }

    public Attack[] attacks() {
        return this.attacks;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        WeaponAttributes that = (WeaponAttributes)obj;
        return Double.doubleToLongBits(this.attack_range) == Double.doubleToLongBits(that.attack_range) && Objects.equals(this.pose, that.pose) && Objects.equals(this.two_handed, that.two_handed) && Objects.equals(this.attacks, that.attacks);
    }

    public int hashCode() {
        return Objects.hash(this.attack_range, this.two_handed, this.attacks);
    }

    public String toString() {
        return "WeaponAttributes[attack_range=" + this.attack_range + ", pose=" + this.pose + ", isTwoHanded=" + this.two_handed + ", attacks=" + String.valueOf(this.attacks) + "]";
    }

    public static final class Attack {
        private Condition[] conditions;
        private HitBoxShape hitbox;
        private double damage_multiplier = 1.0;
        private double angle = 0.0;
        private double upswing = 0.0;
        private String animation = null;
        private Sound swing_sound = null;
        private Sound impact_sound = null;

        public Attack() {
        }

        public Attack(Condition[] conditions, HitBoxShape hitbox, double damage_multiplier, double angle, double upswing, String animation, Sound swing_sound, Sound impact_sound) {
            this.conditions = conditions;
            this.hitbox = hitbox;
            this.damage_multiplier = damage_multiplier;
            this.angle = angle;
            this.upswing = upswing;
            this.animation = animation;
            this.swing_sound = swing_sound;
            this.impact_sound = impact_sound;
        }

        @Nullable
        public Condition[] conditions() {
            return this.conditions;
        }

        public HitBoxShape hitbox() {
            return this.hitbox;
        }

        public double damageMultiplier() {
            return this.damage_multiplier;
        }

        public double angle() {
            return this.angle;
        }

        public double upswing() {
            return this.upswing;
        }

        public String animation() {
            return this.animation;
        }

        public Sound swingSound() {
            return this.swing_sound;
        }

        public Sound impactSound() {
            return this.impact_sound;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Attack that = (Attack)obj;
            return Objects.equals((Object)this.hitbox, (Object)that.hitbox) && Double.doubleToLongBits(this.damage_multiplier) == Double.doubleToLongBits(that.damage_multiplier) && Double.doubleToLongBits(this.angle) == Double.doubleToLongBits(that.angle) && Double.doubleToLongBits(this.upswing) == Double.doubleToLongBits(that.upswing) && Objects.equals(this.animation, that.animation) && Objects.equals(this.swing_sound, that.swing_sound) && Objects.equals(this.impact_sound, that.impact_sound);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.hitbox, this.damage_multiplier, this.angle, this.upswing, this.animation, this.swing_sound, this.impact_sound});
        }

        public String toString() {
            return "Attack[hitbox=" + String.valueOf((Object)this.hitbox) + ", damage_multiplier=" + this.damage_multiplier + ", angle=" + this.angle + ", upswing=" + this.upswing + ", animation=" + this.animation + ", swing_sound=" + String.valueOf(this.swing_sound) + ", impact_sound=" + String.valueOf(this.impact_sound) + "]";
        }
    }

    public static final class Sound {
        private String id = null;
        private float volume = 1.0f;
        private float pitch = 1.0f;
        private float randomness = 0.1f;

        public Sound() {
        }

        public Sound(String id) {
            this.id = id;
        }

        public String id() {
            return this.id;
        }

        public float volume() {
            return this.volume;
        }

        public float pitch() {
            return this.pitch;
        }

        public float randomness() {
            return this.randomness;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            Sound that = (Sound)obj;
            return Objects.equals(this.id, that.id) && Float.floatToIntBits(this.volume) == Float.floatToIntBits(that.volume) && Float.floatToIntBits(this.pitch) == Float.floatToIntBits(that.pitch) && Float.floatToIntBits(this.randomness) == Float.floatToIntBits(that.randomness);
        }

        public int hashCode() {
            return Objects.hash(this.id, Float.valueOf(this.volume), Float.valueOf(this.pitch), Float.valueOf(this.randomness));
        }

        public String toString() {
            return "SoundV2[id=" + this.id + ", volume=" + this.volume + ", pitch=" + this.pitch + ", randomness=" + this.randomness + "]";
        }
    }

    public static enum Condition {
        NOT_DUAL_WIELDING,
        DUAL_WIELDING_ANY,
        DUAL_WIELDING_SAME,
        DUAL_WIELDING_SAME_CATEGORY,
        NO_OFFHAND_ITEM,
        OFF_HAND_SHIELD,
        MAIN_HAND_ONLY,
        OFF_HAND_ONLY,
        MOUNTED,
        NOT_MOUNTED;

    }

    public static enum HitBoxShape {
        FORWARD_BOX,
        VERTICAL_PLANE,
        HORIZONTAL_PLANE;

    }
}

