/*
 * Decompiled with CFR 0.152.
 */
package net.bettercombat.mixin.client;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Objects;
import me.shedaniel.autoconfig.AutoConfig;
import net.bettercombat.BetterCombat;
import net.bettercombat.PlatformClient;
import net.bettercombat.api.AttackHand;
import net.bettercombat.api.MinecraftClient_BetterCombat;
import net.bettercombat.api.WeaponAttributes;
import net.bettercombat.api.client.BetterCombatClientEvents;
import net.bettercombat.client.BetterCombatClient;
import net.bettercombat.client.BetterCombatKeybindings;
import net.bettercombat.client.animation.PlayerAttackAnimatable;
import net.bettercombat.client.collision.TargetFinder;
import net.bettercombat.config.ClientConfigWrapper;
import net.bettercombat.logic.AnimatedHand;
import net.bettercombat.logic.PlayerAttackHelper;
import net.bettercombat.logic.PlayerAttackProperties;
import net.bettercombat.logic.WeaponRegistry;
import net.bettercombat.mixin.client.MinecraftClientAccessor;
import net.bettercombat.network.Packets;
import net.bettercombat.utils.PatternMatching;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1074;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import net.minecraft.class_542;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_310.class})
public abstract class MinecraftClientInject
implements MinecraftClient_BetterCombat {
    @Shadow
    public class_638 field_1687;
    @Shadow
    @Nullable
    public class_746 field_1724;
    @Shadow
    private int field_1752;
    @Shadow
    @Final
    public class_327 field_1772;
    @Shadow
    public int field_1771;
    private boolean isHoldingAttackInput = false;
    private boolean isHarvesting = false;
    private String textToRender = null;
    private int textFade = 0;
    private class_1799 upswingStack;
    private class_1799 lastAttacedWithItemStack;
    private int upswingTicks = 0;
    private int lastAttacked = 1000;
    private float lastSwingDuration = 0.0f;
    private int comboReset = 0;
    private List<class_1297> targetsInReach = null;

    private class_310 thisClient() {
        return (class_310)this;
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void postInit(class_542 args, CallbackInfo ci) {
        this.setupTextRenderer();
    }

    @Inject(method={"disconnect(Lnet/minecraft/client/gui/screen/Screen;)V"}, at={@At(value="TAIL")})
    private void disconnect_TAIL(class_437 screen, CallbackInfo ci) {
        BetterCombatClient.ENABLED = false;
    }

    private void setupTextRenderer() {
        HudRenderCallback.EVENT.register((context, f) -> {
            if (this.textToRender != null && !this.textToRender.isEmpty()) {
                class_310 client = class_310.method_1551();
                class_327 textRenderer = client.field_1705.method_1756();
                int scaledWidth = client.method_22683().method_4486();
                int scaledHeight = client.method_22683().method_4502();
                int i = textRenderer.method_1727(this.textToRender);
                int j = (scaledWidth - i) / 2;
                int k = scaledHeight - 59 - 14;
                int l = 0;
                if (!client.field_1761.method_2908()) {
                    k += 14;
                }
                if ((l = (int)((float)this.textFade * 256.0f / 10.0f)) > 255) {
                    l = 255;
                }
                if (l > 0) {
                    RenderSystem.enableBlend();
                    RenderSystem.defaultBlendFunc();
                    Objects.requireNonNull(textRenderer);
                    context.method_25294(j - 2, k - 2, j + i + 2, k + 9 + 2, client.field_1690.method_19344(0));
                    context.method_25303(textRenderer, this.textToRender, j, k, 0xFFFFFF + (l << 24));
                    RenderSystem.disableBlend();
                }
            }
            if (this.textFade <= 0) {
                this.textToRender = null;
            }
        });
    }

    @Inject(method={"doAttack"}, at={@At(value="HEAD")}, cancellable=true)
    private void pre_doAttack(CallbackInfoReturnable<Boolean> info) {
        if (!BetterCombatClient.ENABLED) {
            return;
        }
        class_310 client = this.thisClient();
        WeaponAttributes attributes = WeaponRegistry.getAttributes(client.field_1724.method_6047());
        if (attributes != null && attributes.attacks() != null) {
            if (this.isTargetingMineableBlock() || this.isHarvesting) {
                this.isHarvesting = true;
                return;
            }
            this.startUpswing(attributes);
            info.setReturnValue((Object)false);
            info.cancel();
        }
    }

    @Inject(method={"handleBlockBreaking"}, at={@At(value="HEAD")}, cancellable=true)
    private void pre_handleBlockBreaking(boolean bl, CallbackInfo ci) {
        if (!BetterCombatClient.ENABLED) {
            return;
        }
        class_310 client = this.thisClient();
        WeaponAttributes attributes = WeaponRegistry.getAttributes(client.field_1724.method_6047());
        if (attributes != null && attributes.attacks() != null) {
            boolean isPressed = client.field_1690.field_1886.method_1434();
            if (isPressed && !this.isHoldingAttackInput) {
                if (this.isTargetingMineableBlock() || this.isHarvesting) {
                    this.isHarvesting = true;
                    return;
                }
                ci.cancel();
            }
            if (BetterCombatClient.config.isHoldToAttackEnabled && isPressed) {
                this.isHoldingAttackInput = true;
                this.startUpswing(attributes);
                ci.cancel();
            } else {
                this.isHarvesting = false;
                this.isHoldingAttackInput = false;
            }
        }
    }

    @Inject(method={"doItemUse"}, at={@At(value="HEAD")}, cancellable=true)
    private void pre_doItemUse(CallbackInfo ci) {
        if (!BetterCombatClient.ENABLED) {
            return;
        }
        AttackHand hand = this.getCurrentHand();
        if (hand == null) {
            return;
        }
        double upswingRate = hand.upswingRate();
        if (this.upswingTicks > 0 || (double)this.field_1724.method_7261(0.0f) < 1.0 - upswingRate) {
            ci.cancel();
        }
    }

    private boolean isTargetingMineableBlock() {
        class_1799 itemStack;
        String id;
        if (!BetterCombatClient.config.isMiningWithWeaponsEnabled) {
            return false;
        }
        String regex = BetterCombatClient.config.mineWithWeaponBlacklist;
        if (regex != null && !regex.isEmpty() && PatternMatching.matches(id = class_7923.field_41178.method_10221((Object)(itemStack = this.field_1724.method_6047()).method_7909()).toString(), regex)) {
            return false;
        }
        if (BetterCombatClient.config.isAttackInsteadOfMineWhenEnemiesCloseEnabled && this.hasTargetsInReach()) {
            return false;
        }
        class_310 client = this.thisClient();
        class_239 crosshairTarget = client.field_1765;
        if (crosshairTarget != null && crosshairTarget.method_17783() == class_239.class_240.field_1332) {
            class_3965 blockHitResult = (class_3965)crosshairTarget;
            class_2338 pos = blockHitResult.method_17777();
            class_2680 clicked = this.field_1687.method_8320(pos);
            if (this.shouldSwingThruGrass()) {
                if (!clicked.method_26220((class_1922)this.field_1687, pos).method_1110() || clicked.method_26214((class_1922)this.field_1687, pos) != 0.0f) {
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    private boolean shouldSwingThruGrass() {
        if (!BetterCombatClient.config.isSwingThruGrassEnabled) {
            return false;
        }
        String regex = BetterCombatClient.config.swingThruGrassBlacklist;
        if (regex == null || regex.isEmpty()) {
            return true;
        }
        class_1799 itemStack = this.field_1724.method_6047();
        String id = class_7923.field_41178.method_10221((Object)itemStack.method_7909()).toString();
        return !PatternMatching.matches(id, regex);
    }

    private void startUpswing(WeaponAttributes attributes) {
        if (this.field_1724.method_3144()) {
            return;
        }
        AttackHand hand = this.getCurrentHand();
        if (hand == null) {
            return;
        }
        float upswingRate = (float)hand.upswingRate();
        if (this.upswingTicks > 0 || this.field_1771 > 0 || this.field_1724.method_6115() || (double)this.field_1724.method_7261(0.0f) < 1.0 - (double)upswingRate) {
            return;
        }
        this.field_1724.method_6075();
        this.lastAttacked = 0;
        this.upswingStack = this.field_1724.method_6047();
        float attackCooldownTicksFloat = PlayerAttackHelper.getAttackCooldownTicksCapped((class_1657)this.field_1724);
        int attackCooldownTicks = Math.round(attackCooldownTicksFloat);
        this.comboReset = Math.round(attackCooldownTicksFloat * BetterCombat.config.combo_reset_rate);
        this.upswingTicks = Math.max(Math.round(attackCooldownTicksFloat * upswingRate), 1);
        this.lastSwingDuration = attackCooldownTicksFloat;
        this.field_1752 = attackCooldownTicks;
        this.setMiningCooldown(attackCooldownTicks);
        String animationName = hand.attack().animation();
        boolean isOffHand = hand.isOffHand();
        AnimatedHand animatedHand = AnimatedHand.from(isOffHand, attributes.isTwoHanded());
        ((PlayerAttackAnimatable)this.field_1724).playAttackAnimation(animationName, animatedHand, attackCooldownTicksFloat, upswingRate);
        ClientPlayNetworking.send((class_2960)Packets.AttackAnimation.ID, (class_2540)new Packets.AttackAnimation(this.field_1724.method_5628(), animatedHand, animationName, attackCooldownTicksFloat, upswingRate).write());
        BetterCombatClientEvents.ATTACK_START.invoke(handler -> handler.onPlayerAttackStart(this.field_1724, hand));
    }

    private void cancelSwingIfNeeded() {
        if (this.upswingStack != null && !MinecraftClientInject.areItemStackEqual(this.field_1724.method_6047(), this.upswingStack)) {
            this.cancelWeaponSwing();
            return;
        }
    }

    private void attackFromUpswingIfNeeded() {
        if (this.upswingTicks > 0) {
            --this.upswingTicks;
            if (this.upswingTicks == 0) {
                this.performAttack();
                this.upswingStack = null;
            }
        }
    }

    private void resetComboIfNeeded() {
        if (this.lastAttacked > this.comboReset && this.getComboCount() > 0) {
            this.setComboCount(0);
        }
        if (!PlayerAttackHelper.shouldAttackWithOffHand((class_1657)this.field_1724, this.getComboCount()) && (this.field_1724.method_6047() == null || this.lastAttacedWithItemStack != null && !this.lastAttacedWithItemStack.method_7909().equals(this.field_1724.method_6047().method_7909()))) {
            this.setComboCount(0);
        }
    }

    private boolean shouldUpdateTargetsInReach() {
        if (BetterCombatClient.config.isHighlightCrosshairEnabled || BetterCombatClient.config.isAttackInsteadOfMineWhenEnemiesCloseEnabled) {
            return this.targetsInReach == null;
        }
        return false;
    }

    private void updateTargetsInReach(List<class_1297> targets) {
        this.targetsInReach = targets;
    }

    private void updateTargetsIfNeeded() {
        if (this.shouldUpdateTargetsInReach()) {
            AttackHand hand = PlayerAttackHelper.getCurrentAttack((class_1657)this.field_1724, this.getComboCount());
            if (hand == null) {
                return;
            }
            WeaponAttributes attributes = WeaponRegistry.getAttributes(this.field_1724.method_6047());
            List<class_1297> targets = List.of();
            if (attributes != null && attributes.attacks() != null) {
                targets = TargetFinder.findAttackTargets((class_1657)this.field_1724, this.getCursorTarget(), hand.attack(), attributes.attackRange());
            }
            this.updateTargetsInReach(targets);
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void pre_Tick(CallbackInfo ci) {
        if (this.field_1724 == null) {
            return;
        }
        this.targetsInReach = null;
        ++this.lastAttacked;
        this.cancelSwingIfNeeded();
        this.attackFromUpswingIfNeeded();
        this.updateTargetsIfNeeded();
        this.resetComboIfNeeded();
    }

    @Inject(method={"tick"}, at={@At(value="TAIL")})
    private void post_Tick(CallbackInfo ci) {
        if (this.field_1724 == null) {
            return;
        }
        if (BetterCombatKeybindings.toggleMineKeyBinding.method_1436()) {
            BetterCombatClient.config.isMiningWithWeaponsEnabled = !BetterCombatClient.config.isMiningWithWeaponsEnabled;
            AutoConfig.getConfigHolder(ClientConfigWrapper.class).save();
            this.textToRender = class_1074.method_4662((String)(BetterCombatClient.config.isMiningWithWeaponsEnabled ? "hud.bettercombat.mine_with_weapons_on" : "hud.bettercombat.mine_with_weapons_off"), (Object[])new Object[0]);
            this.textFade = 40;
        }
        if (this.textFade > 0) {
            --this.textFade;
        }
    }

    private void performAttack() {
        if (BetterCombatKeybindings.feintKeyBinding.method_1434()) {
            this.field_1724.method_7350();
            this.cancelWeaponSwing();
            return;
        }
        AttackHand hand = this.getCurrentHand();
        if (hand == null) {
            return;
        }
        WeaponAttributes.Attack attack = hand.attack();
        double upswingRate = hand.upswingRate();
        if ((double)this.field_1724.method_7261(0.0f) < 1.0 - upswingRate) {
            return;
        }
        class_1297 cursorTarget = this.getCursorTarget();
        List<class_1297> targets = TargetFinder.findAttackTargets((class_1657)this.field_1724, cursorTarget, attack, hand.attributes().attackRange());
        this.updateTargetsInReach(targets);
        if (targets.size() == 0) {
            PlatformClient.onEmptyLeftClick((class_1657)this.field_1724);
        }
        ClientPlayNetworking.send((class_2960)Packets.C2S_AttackRequest.ID, (class_2540)new Packets.C2S_AttackRequest(this.getComboCount(), this.field_1724.method_5715(), this.field_1724.method_31548().field_7545, targets).write());
        for (class_1297 target : targets) {
            this.field_1724.method_7324(target);
        }
        this.field_1724.method_7350();
        BetterCombatClientEvents.ATTACK_HIT.invoke(handler -> handler.onPlayerAttackStart(this.field_1724, hand, targets, cursorTarget));
        this.setComboCount(this.getComboCount() + 1);
        if (!hand.isOffHand()) {
            this.lastAttacedWithItemStack = hand.itemStack();
        }
    }

    private AttackHand getCurrentHand() {
        return PlayerAttackHelper.getCurrentAttack((class_1657)this.field_1724, this.getComboCount());
    }

    private void setComboCount(int comboCount) {
        ((PlayerAttackProperties)this.field_1724).setComboCount(comboCount);
    }

    private static boolean areItemStackEqual(class_1799 left, class_1799 right) {
        if (left == null && right == null) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        return class_1799.method_7973((class_1799)left, (class_1799)right);
    }

    private void setMiningCooldown(int ticks) {
        class_310 client = this.thisClient();
        ((MinecraftClientAccessor)client).setAttackCooldown(ticks);
    }

    private void cancelWeaponSwing() {
        int downWind = (int)Math.round((double)PlayerAttackHelper.getAttackCooldownTicksCapped((class_1657)this.field_1724) * (1.0 - 0.5 * (double)BetterCombat.config.upswing_multiplier));
        ((PlayerAttackAnimatable)this.field_1724).stopAttackAnimation(downWind);
        ClientPlayNetworking.send((class_2960)Packets.AttackAnimation.ID, (class_2540)Packets.AttackAnimation.stop(this.field_1724.method_5628(), downWind).write());
        this.upswingStack = null;
        this.field_1752 = 0;
        this.setMiningCooldown(0);
    }

    @Override
    public int getComboCount() {
        return ((PlayerAttackProperties)this.field_1724).getComboCount();
    }

    @Override
    public boolean hasTargetsInReach() {
        return this.targetsInReach != null && !this.targetsInReach.isEmpty();
    }

    @Override
    public float getSwingProgress() {
        if ((float)this.lastAttacked > this.lastSwingDuration || this.lastSwingDuration <= 0.0f) {
            return 1.0f;
        }
        return (float)this.lastAttacked / this.lastSwingDuration;
    }

    @Override
    public int getUpswingTicks() {
        return this.upswingTicks;
    }

    @Override
    public void cancelUpswing() {
        if (this.upswingTicks > 0) {
            this.cancelWeaponSwing();
        }
    }
}

