/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.bewitchment.common;

import eu.midnightdust.lib.config.MidnightConfig;
import moriyashiine.bewitchment.api.BewitchmentAPI;
import moriyashiine.bewitchment.api.component.BloodComponent;
import moriyashiine.bewitchment.api.component.ContractsComponent;
import moriyashiine.bewitchment.api.component.TransformationComponent;
import moriyashiine.bewitchment.api.event.BloodSuckEvents;
import moriyashiine.bewitchment.common.BWConfig;
import moriyashiine.bewitchment.common.block.CoffinBlock;
import moriyashiine.bewitchment.common.block.entity.BrazierBlockEntity;
import moriyashiine.bewitchment.common.block.entity.GlyphBlockEntity;
import moriyashiine.bewitchment.common.block.entity.SigilBlockEntity;
import moriyashiine.bewitchment.common.component.entity.AdditionalWerewolfDataComponent;
import moriyashiine.bewitchment.common.item.AthameItem;
import moriyashiine.bewitchment.common.misc.BWUtil;
import moriyashiine.bewitchment.common.packet.CauldronTeleportPacket;
import moriyashiine.bewitchment.common.packet.TogglePressingForwardPacket;
import moriyashiine.bewitchment.common.packet.TransformationAbilityPacket;
import moriyashiine.bewitchment.common.recipe.AthameDropRecipe;
import moriyashiine.bewitchment.common.recipe.IncenseRecipe;
import moriyashiine.bewitchment.common.registry.BWBlockEntityTypes;
import moriyashiine.bewitchment.common.registry.BWBoatTypes;
import moriyashiine.bewitchment.common.registry.BWCommands;
import moriyashiine.bewitchment.common.registry.BWComponents;
import moriyashiine.bewitchment.common.registry.BWContracts;
import moriyashiine.bewitchment.common.registry.BWCurses;
import moriyashiine.bewitchment.common.registry.BWDamageSources;
import moriyashiine.bewitchment.common.registry.BWEnchantments;
import moriyashiine.bewitchment.common.registry.BWEntityTypes;
import moriyashiine.bewitchment.common.registry.BWFortunes;
import moriyashiine.bewitchment.common.registry.BWObjects;
import moriyashiine.bewitchment.common.registry.BWParticleTypes;
import moriyashiine.bewitchment.common.registry.BWRecipeTypes;
import moriyashiine.bewitchment.common.registry.BWRitualFunctions;
import moriyashiine.bewitchment.common.registry.BWScaleTypes;
import moriyashiine.bewitchment.common.registry.BWScreenHandlerTypes;
import moriyashiine.bewitchment.common.registry.BWSigils;
import moriyashiine.bewitchment.common.registry.BWSoundEvents;
import moriyashiine.bewitchment.common.registry.BWStatusEffects;
import moriyashiine.bewitchment.common.registry.BWTags;
import moriyashiine.bewitchment.common.registry.BWTransformations;
import moriyashiine.bewitchment.common.registry.BWWorldGenerators;
import moriyashiine.bewitchment.common.world.BWWorldState;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.event.v1.EntitySleepEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerEntityCombatEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.player.UseEntityCallback;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.tag.convention.v1.ConventionalBiomeTags;
import net.minecraft.class_1264;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1428;
import net.minecraft.class_1429;
import net.minecraft.class_1493;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3730;
import net.minecraft.class_5425;
import net.minecraft.class_6880;

public class Bewitchment
implements ModInitializer {
    public static final String MOD_ID = "bewitchment";

    public void onInitialize() {
        MidnightConfig.init((String)MOD_ID, BWConfig.class);
        ServerPlayNetworking.registerGlobalReceiver((class_2960)CauldronTeleportPacket.ID, (ServerPlayNetworking.PlayChannelHandler)new CauldronTeleportPacket.Receiver());
        ServerPlayNetworking.registerGlobalReceiver((class_2960)TransformationAbilityPacket.ID, (ServerPlayNetworking.PlayChannelHandler)new TransformationAbilityPacket.Receiver());
        ServerPlayNetworking.registerGlobalReceiver((class_2960)TogglePressingForwardPacket.ID, (ServerPlayNetworking.PlayChannelHandler)new TogglePressingForwardPacket.Receiver());
        CommandRegistrationCallback.EVENT.register(BWCommands::init);
        ServerLifecycleEvents.SERVER_STOPPED.register(server -> {
            BewitchmentAPI.fakePlayer = null;
        });
        ServerPlayerEvents.AFTER_RESPAWN.register((oldPlayer, newPlayer, alive) -> {
            ((TransformationComponent)BWComponents.TRANSFORMATION_COMPONENT.get((Object)newPlayer)).setAlternateForm(false);
            ((AdditionalWerewolfDataComponent)BWComponents.ADDITIONAL_WEREWOLF_DATA_COMPONENT.get((Object)newPlayer)).setForcedTransformation(false);
        });
        ServerPlayerEvents.COPY_FROM.register((oldPlayer, newPlayer, alive) -> {
            if (alive && ((TransformationComponent)BWComponents.TRANSFORMATION_COMPONENT.get((Object)oldPlayer)).isAlternateForm()) {
                TransformationAbilityPacket.useAbility((class_1657)newPlayer, true);
            }
        });
        ServerEntityCombatEvents.AFTER_KILLED_OTHER_ENTITY.register((world, entity, killedEntity) -> {
            if (entity instanceof class_1309) {
                class_1657 player;
                class_1309 livingEntity = (class_1309)entity;
                if (livingEntity instanceof class_1657) {
                    player = (class_1657)livingEntity;
                    if (killedEntity.method_6046() == class_1310.field_6293 && BewitchmentAPI.getFamiliar(player) == BWEntityTypes.TOAD) {
                        livingEntity.method_6025(livingEntity.method_6063() * 1.0f / 4.0f);
                    }
                }
                if (livingEntity instanceof class_1657 && ((ContractsComponent)BWComponents.CONTRACTS_COMPONENT.get((Object)(player = (class_1657)livingEntity))).hasContract(BWContracts.DEATH)) {
                    livingEntity.method_6025(livingEntity.method_6063() / 4.0f);
                }
                if (livingEntity.method_6047().method_7909() instanceof AthameItem) {
                    class_2338 glyphPos = BWUtil.getClosestBlockPos(killedEntity.method_24515(), 6, currentPos -> world.method_8321(currentPos) instanceof GlyphBlockEntity);
                    if (glyphPos != null) {
                        ((GlyphBlockEntity)world.method_8321(glyphPos)).onUse((class_1937)world, glyphPos, livingEntity, class_1268.field_5808, killedEntity);
                    }
                    if (world.method_23886()) {
                        boolean chicken = killedEntity instanceof class_1428;
                        boolean wolf = killedEntity instanceof class_1493;
                        if (chicken || wolf) {
                            class_2338 brazierPos;
                            class_6880 biome = world.method_23753(killedEntity.method_24515());
                            class_1308 boss = null;
                            if (chicken && (biome.method_40220(ConventionalBiomeTags.EXTREME_HILLS) || biome.method_40220(ConventionalBiomeTags.ICY) || biome.method_40220(ConventionalBiomeTags.MOUNTAIN))) {
                                boss = (class_1308)BWEntityTypes.LILITH.method_5883((class_1937)world);
                            }
                            if (wolf && (biome.method_40220(ConventionalBiomeTags.TAIGA) || biome.method_40220(ConventionalBiomeTags.FOREST))) {
                                boss = (class_1308)BWEntityTypes.HERNE.method_5883((class_1937)world);
                            }
                            if (boss != null && (brazierPos = BWUtil.getClosestBlockPos(killedEntity.method_24515(), 8, currentPos -> {
                                class_2586 patt0$temp = world.method_8321(currentPos);
                                if (!(patt0$temp instanceof BrazierBlockEntity)) return false;
                                BrazierBlockEntity brazier = (BrazierBlockEntity)patt0$temp;
                                if (brazier.incenseRecipe.effect != BWStatusEffects.MORTAL_COIL) return false;
                                return true;
                            })) != null) {
                                world.method_22352(brazierPos, false);
                                world.method_8437(null, (double)brazierPos.method_10263() + 0.5, (double)brazierPos.method_10264() + 0.5, (double)brazierPos.method_10260() + 0.5, 3.0f, class_1937.class_7867.field_40891);
                                boss.method_5943((class_5425)world, world.method_8404(brazierPos), class_3730.field_16467, null, null);
                                boss.method_5641((double)brazierPos.method_10263() + 0.5, (double)brazierPos.method_10264(), (double)brazierPos.method_10260() + 0.5, world.field_9229.method_43057() * 360.0f, 0.0f);
                                world.method_8649((class_1297)boss);
                            }
                        }
                    }
                    for (AthameDropRecipe recipe : world.method_8433().method_30027(BWRecipeTypes.ATHAME_DROP_RECIPE_TYPE)) {
                        if (!recipe.entity_type.equals((Object)killedEntity.method_5864()) || !(world.field_9229.method_43057() < recipe.chance * (float)(class_1890.method_8226((class_1309)livingEntity) + 1))) continue;
                        class_1799 drop = recipe.method_8110(entity.method_37908().method_30349()).method_7972();
                        if (recipe.entity_type == class_1299.field_6097) {
                            drop.method_7948().method_10582("SkullOwner", killedEntity.method_5477().getString());
                        }
                        class_1264.method_5449((class_1937)world, (double)(killedEntity.method_23317() + 0.5), (double)(killedEntity.method_23318() + 0.5), (double)(killedEntity.method_23321() + 0.5), (class_1799)drop);
                    }
                    if (livingEntity instanceof class_1657) {
                        class_1657 player2 = (class_1657)livingEntity;
                        if (livingEntity.method_6079().method_7909() == class_1802.field_8469 && ((BloodComponent)BWComponents.BLOOD_COMPONENT.get((Object)killedEntity)).getBlood() > 20 && killedEntity.method_5864().method_20210(BWTags.HAS_BLOOD)) {
                            world.method_8396(null, livingEntity.method_24515(), class_3417.field_14779, class_3419.field_15248, 1.0f, 0.5f);
                            BWUtil.addItemToInventoryAndConsume(player2, class_1268.field_5810, new class_1799((class_1935)BWObjects.BOTTLE_OF_BLOOD));
                        }
                    }
                }
            }
        });
        UseEntityCallback.EVENT.register((player, world, hand, entity, hitResult) -> {
            if (entity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                if (hand == class_1268.field_5808 && player.method_5715() && entity.method_5805() && BewitchmentAPI.isVampire((class_1297)player, true) && player.method_5998(hand).method_7960()) {
                    int toGive = entity.method_5864().method_20210(BWTags.HAS_BLOOD) ? 5 : (entity instanceof class_1429 ? 1 : 0);
                    toGive = ((BloodSuckEvents.SetBloodAmount)BloodSuckEvents.BLOOD_AMOUNT.invoker()).onBloodSuck(player, livingEntity, toGive);
                    if (toGive > 0) {
                        BloodComponent playerBloodComponent = (BloodComponent)BWComponents.BLOOD_COMPONENT.get((Object)player);
                        BloodComponent entityBloodComponent = (BloodComponent)BWComponents.BLOOD_COMPONENT.get((Object)livingEntity);
                        if (playerBloodComponent.fillBlood(toGive, true) && entityBloodComponent.drainBlood(10, true)) {
                            if (!world.field_9236 && livingEntity.field_6235 == 0) {
                                ((BloodSuckEvents.OnBloodSuck)BloodSuckEvents.ON_BLOOD_SUCK.invoker()).onBloodSuck(player, livingEntity, toGive);
                                world.method_8396(null, player.method_24515(), class_3417.field_20615, player.method_5634(), 1.0f, 0.5f);
                                if (!livingEntity.method_6113() || entityBloodComponent.getBlood() < 50) {
                                    entity.method_5643(BWDamageSources.create(entity.method_37908(), BWDamageSources.VAMPIRE), 2.0f);
                                }
                                playerBloodComponent.fillBlood(toGive, false);
                                entityBloodComponent.drainBlood(10, false);
                            }
                            return class_1269.method_29236((boolean)world.field_9236);
                        }
                    }
                }
            }
            return class_1269.field_5811;
        });
        EntitySleepEvents.ALLOW_SLEEP_TIME.register((player, sleepingPos, vanillaResult) -> player.method_37908().method_8320(sleepingPos).method_26204() instanceof CoffinBlock && player.method_37908().method_8530() ? class_1269.method_29236((boolean)player.method_37908().field_9236) : class_1269.field_5811);
        EntitySleepEvents.ALLOW_SLEEPING.register((player, sleepingPos) -> {
            if (((TransformationComponent)BWComponents.TRANSFORMATION_COMPONENT.get((Object)player)).isAlternateForm()) {
                player.method_7353((class_2561)class_2561.method_43471((String)"block.minecraft.bed.transformation"), true);
                return class_1657.class_1658.field_7531;
            }
            if (player.method_37908().method_8320(sleepingPos).method_26204() instanceof CoffinBlock) {
                if (player.method_37908().method_23886()) {
                    player.method_7353((class_2561)class_2561.method_43471((String)"block.minecraft.bed.coffin"), true);
                    return class_1657.class_1658.field_7531;
                }
                return null;
            }
            return null;
        });
        EntitySleepEvents.STOP_SLEEPING.register((entity, sleepingPos) -> {
            if (!entity.method_37908().field_9236) {
                BWWorldState worldState = BWWorldState.get(entity.method_37908());
                for (class_2338 foundPos : BWUtil.getBlockPoses(entity.method_24515(), 12)) {
                    class_2586 patt0$temp;
                    if (!entity.method_37908().method_8621().method_11952(foundPos) || !((patt0$temp = entity.method_37908().method_8321(foundPos)) instanceof BrazierBlockEntity)) continue;
                    BrazierBlockEntity brazier = (BrazierBlockEntity)patt0$temp;
                    if (brazier.incenseRecipe == null) continue;
                    IncenseRecipe recipe = brazier.incenseRecipe;
                    int durationMultiplier = 1;
                    for (class_2338 sigilPos : BWUtil.getBlockPoses(foundPos, 16)) {
                        SigilBlockEntity sigil;
                        class_2586 patt1$temp;
                        if (!entity.method_37908().method_8621().method_11952(foundPos) || !worldState.potentialSigils.contains(sigilPos.method_10063()) || !((patt1$temp = entity.method_37908().method_8321(sigilPos)) instanceof SigilBlockEntity) || (sigil = (SigilBlockEntity)patt1$temp).getSigil() != BWSigils.EXTENDING || !sigil.test((class_1297)entity)) continue;
                        sigil.setUses(sigil.getUses() - 1);
                        sigil.method_5431();
                        durationMultiplier = 2;
                        break;
                    }
                    entity.method_6092(new class_1293(recipe.effect, 24000 * durationMultiplier, recipe.amplifier, true, false));
                }
            }
        });
        BWScaleTypes.init();
        BWObjects.init();
        BWBoatTypes.init();
        BWBlockEntityTypes.init();
        BWEntityTypes.init();
        BWStatusEffects.init();
        BWEnchantments.init();
        BWRitualFunctions.init();
        BWFortunes.init();
        BWSigils.init();
        BWTransformations.init();
        BWContracts.init();
        BWCurses.init();
        BWSoundEvents.init();
        BWParticleTypes.init();
        BWRecipeTypes.init();
        BWWorldGenerators.init();
        BWScreenHandlerTypes.init();
        BewitchmentAPI.registerAltarMapEntries(new class_2248[][]{BWObjects.STONE_WITCH_ALTAR});
        BewitchmentAPI.registerAltarMapEntries(new class_2248[][]{BWObjects.MOSSY_COBBLESTONE_WITCH_ALTAR});
        BewitchmentAPI.registerAltarMapEntries(new class_2248[][]{BWObjects.PRISMARINE_WITCH_ALTAR});
        BewitchmentAPI.registerAltarMapEntries(new class_2248[][]{BWObjects.NETHER_BRICK_WITCH_ALTAR});
        BewitchmentAPI.registerAltarMapEntries(new class_2248[][]{BWObjects.BLACKSTONE_WITCH_ALTAR});
        BewitchmentAPI.registerAltarMapEntries(new class_2248[][]{BWObjects.GOLDEN_WITCH_ALTAR});
        BewitchmentAPI.registerAltarMapEntries(new class_2248[][]{BWObjects.END_STONE_WITCH_ALTAR});
        BewitchmentAPI.registerAltarMapEntries(new class_2248[][]{BWObjects.OBSIDIAN_WITCH_ALTAR});
        BewitchmentAPI.registerAltarMapEntries(new class_2248[][]{BWObjects.PURPUR_WITCH_ALTAR});
    }

    public static class_2960 id(String value) {
        return new class_2960(MOD_ID, value);
    }
}

