/*
 * Decompiled with CFR 0.152.
 */
package wehavecookies56.bonfires;

import com.mojang.brigadier.CommandDispatcher;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.item.v1.ModifyItemAttributeModifiersCallback;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1304;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_179;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3446;
import net.minecraft.class_3468;
import net.minecraft.class_5134;
import net.minecraft.class_7923;
import net.minecraft.class_8111;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import wehavecookies56.bonfires.BonfiresCommand;
import wehavecookies56.bonfires.BonfiresMainConfig;
import wehavecookies56.bonfires.TravelCommand;
import wehavecookies56.bonfires.advancements.BonfireLitTrigger;
import wehavecookies56.bonfires.bonfire.Bonfire;
import wehavecookies56.bonfires.bonfire.BonfireRegistry;
import wehavecookies56.bonfires.data.BonfireHandler;
import wehavecookies56.bonfires.data.DiscoveryHandler;
import wehavecookies56.bonfires.data.ReinforceHandler;
import wehavecookies56.bonfires.packets.PacketHandler;
import wehavecookies56.bonfires.setup.BlockSetup;
import wehavecookies56.bonfires.setup.CreativeTabSetup;
import wehavecookies56.bonfires.setup.EntitySetup;
import wehavecookies56.bonfires.setup.ItemSetup;

public class Bonfires
implements ModInitializer {
    public static final String modid = "bonfires";
    public static Logger LOGGER = LoggerFactory.getLogger((String)"bonfires");
    public static final class_2960 BONFIRES_LIT = new class_2960("bonfires", "bonfires_lit");
    public static final class_2960 TIMES_TRAVELLED = new class_2960("bonfires", "times_travelled");
    public static final UUID reinforceDamageModifier = UUID.fromString("117e876c-c9bd-4898-985a-2ecb24198350");
    public static final BonfiresMainConfig CONFIG = BonfiresMainConfig.createAndLoad();

    public void onInitialize() {
        BlockSetup.init();
        ItemSetup.init();
        EntitySetup.init();
        CreativeTabSetup.init();
        class_2378.method_10226((class_2378)class_7923.field_41183, (String)BONFIRES_LIT.method_12832(), (Object)BONFIRES_LIT);
        class_2378.method_10226((class_2378)class_7923.field_41183, (String)TIMES_TRAVELLED.method_12832(), (Object)TIMES_TRAVELLED);
        class_3468.field_15419.method_14955((Object)BONFIRES_LIT, class_3446.field_16975);
        class_3468.field_15419.method_14955((Object)TIMES_TRAVELLED, class_3446.field_16975);
        BonfireLitTrigger.INSTANCE = (BonfireLitTrigger)class_174.method_767((class_179)new BonfireLitTrigger());
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            BonfiresCommand.register((CommandDispatcher<class_2168>)dispatcher);
            TravelCommand.register((CommandDispatcher<class_2168>)dispatcher);
        });
        ServerLifecycleEvents.SERVER_STARTED.register(server -> BonfireHandler.getServerHandler(server).loadOldBonfireData(server));
        ServerLivingEntityEvents.AFTER_DEATH.register((entity, damageSource) -> {
            Random r;
            double percent;
            if (!Bonfires.CONFIG.common.disableAshDrops() && (damageSource.method_49708(class_8111.field_42335) || entity.method_5809() || damageSource.method_5526() instanceof class_1657 && ((class_1657)damageSource.method_5526()).method_6047().method_7909() == ItemSetup.coiled_sword) && (percent = (r = new Random()).nextDouble() * 100.0) > 65.0) {
                entity.method_5775(new class_1799((class_1935)ItemSetup.ash_pile));
            }
        });
        ModifyItemAttributeModifiersCallback.EVENT.register((stack, slot, attributeModifiers) -> {
            ReinforceHandler.ReinforceLevel rlevel;
            if (slot == class_1304.field_6173 && stack.method_7909() != ItemSetup.estus_flask && ReinforceHandler.canReinforce(stack) && (rlevel = ReinforceHandler.getReinforceLevel(stack)) != null && rlevel.level() != 0) {
                attributeModifiers.put((Object)class_5134.field_23721, (Object)new class_1322(reinforceDamageModifier, "reinforce_damagebonus", Bonfires.CONFIG.common.reinforceDamagePerLevel() * (double)rlevel.level(), class_1322.class_1323.field_6328));
            }
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            if (DiscoveryHandler.getHandler((class_1657)handler.field_14140).getDiscovered().isEmpty()) {
                BonfireRegistry registry = BonfireHandler.getServerHandler(server).getRegistry();
                DiscoveryHandler.IDiscoveryHandler discoveryHandler = DiscoveryHandler.getHandler((class_1657)handler.field_14140);
                List<Bonfire> bonfires = registry.getBonfiresByOwner(handler.field_14140.method_5667());
                bonfires.forEach(bonfire -> discoveryHandler.setDiscovered(bonfire.getId(), bonfire.getTimeCreated()));
            }
        });
        ServerPlayerEvents.AFTER_RESPAWN.register((oldPlayer, newPlayer, alive) -> {
            if (!alive) {
                newPlayer.method_31548().field_7547.forEach(stack -> {
                    if (stack.method_31574(ItemSetup.estus_flask) && stack.method_7969() != null) {
                        stack.method_7969().method_10569("estus", stack.method_7969().method_10550("uses"));
                    }
                });
            }
        });
        PacketHandler.init();
    }
}

