/*
 * Decompiled with CFR 0.152.
 */
package wehavecookies56.bonfires;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import wehavecookies56.bonfires.bonfire.Bonfire;
import wehavecookies56.bonfires.data.BonfireHandler;

public class BonfiresCommand {
    public static SuggestionProvider<class_2168> SUGGEST_DIMENSIONS = (context, builder) -> {
        List<String> list = ((class_2168)context.getSource()).method_9211().method_29435().stream().map(rk -> rk.method_29177().toString()).toList();
        list.stream().map(StringArgumentType::escapeIfRequired).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    };
    public static SuggestionProvider<class_2168> SUGGEST_USERNAMES = (context, builder) -> {
        Collection list = ((class_2168)context.getSource()).method_9262();
        list.stream().map(StringArgumentType::escapeIfRequired).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    };

    public static void register(CommandDispatcher<class_2168> dispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)class_2170.method_9247((String)"bonfires").requires(commandSource -> commandSource.method_9259(2));
        builder.then(class_2170.method_9247((String)"all").executes(context -> BonfiresCommand.executeCommand((CommandContext<class_2168>)context, "all")));
        builder.then(class_2170.method_9247((String)"dim").then(class_2170.method_9244((String)"dimension", (ArgumentType)StringArgumentType.string()).suggests(SUGGEST_DIMENSIONS).executes(context -> BonfiresCommand.executeCommand((CommandContext<class_2168>)context, "dim"))));
        builder.then(class_2170.method_9247((String)"name").then(class_2170.method_9244((String)"bonfirename", (ArgumentType)StringArgumentType.string()).executes(context -> BonfiresCommand.executeCommand((CommandContext<class_2168>)context, "name"))));
        builder.then(class_2170.method_9247((String)"owner").then(class_2170.method_9244((String)"ownername", (ArgumentType)StringArgumentType.string()).suggests(SUGGEST_USERNAMES).executes(context -> BonfiresCommand.executeCommand((CommandContext<class_2168>)context, "owner"))));
        builder.then(class_2170.method_9247((String)"radius").then(class_2170.method_9244((String)"searchradius", (ArgumentType)IntegerArgumentType.integer()).executes(context -> BonfiresCommand.executeCommand((CommandContext<class_2168>)context, "radius"))));
        builder.then(class_2170.method_9247((String)"filters").executes(context -> BonfiresCommand.executeCommand((CommandContext<class_2168>)context, "filters")));
        dispatcher.register(builder);
    }

    private static int executeCommand(CommandContext<class_2168> context, String filter) throws CommandSyntaxException {
        MinecraftServer server = ((class_2168)context.getSource()).method_9211();
        switch (filter) {
            case "all": {
                ArrayList<Bonfire> query = new ArrayList<Bonfire>(BonfireHandler.getServerHandler(server).getRegistry().getBonfires().values());
                if (query.isEmpty()) {
                    ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.bonfires.nomatch", (Object[])new Object[]{"all"}), false);
                    break;
                }
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.bonfires.match", (Object[])new Object[]{query.size(), "all"}), false);
                BonfiresCommand.listQueriedBonfires(query, (class_2168)context.getSource());
                break;
            }
            case "dim": {
                String input = StringArgumentType.getString(context, (String)"dimension");
                if (input.contains(":")) {
                    class_5321 dimensionKey = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960(input));
                    if (server.method_29435().contains(dimensionKey)) {
                        List<Bonfire> query = BonfireHandler.getServerHandler(server).getRegistry().getBonfiresByDimension(dimensionKey.method_29177());
                        if (query.isEmpty()) {
                            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.bonfires.dim.nomatch", (Object[])new Object[]{input}), false);
                            break;
                        }
                        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.bonfires.dim.match", (Object[])new Object[]{query.size(), input}), false);
                        BonfiresCommand.listQueriedBonfires(query, (class_2168)context.getSource());
                        break;
                    }
                    ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43469((String)"command.bonfires.dim.nodim", (Object[])new Object[]{input}));
                    break;
                }
                ((class_2168)context.getSource()).method_9213((class_2561)class_2561.method_43469((String)"command.bonfires.dim.invalid", (Object[])new Object[]{input}));
                break;
            }
            case "name": {
                String input = StringArgumentType.getString(context, (String)"bonfirename");
                List<Bonfire> query = BonfireHandler.getServerHandler(server).getRegistry().getBonfiresByName(input);
                if (query.isEmpty()) {
                    ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.bonfires.nomatch", (Object[])new Object[]{input}), false);
                    break;
                }
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.bonfires.match", (Object[])new Object[]{query.size(), input}), false);
                BonfiresCommand.listQueriedBonfires(query, (class_2168)context.getSource());
                break;
            }
            case "owner": {
                String input = StringArgumentType.getString(context, (String)"ownername");
                GameProfile ownerProfile = server.method_3793().method_14515(input).orElse(null);
                if (ownerProfile == null) break;
                UUID ownerID = ownerProfile.getId();
                if (ownerID != null) {
                    List<Bonfire> query = BonfireHandler.getServerHandler(server).getRegistry().getBonfiresByOwner(ownerID);
                    if (query.isEmpty()) {
                        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.bonfires.nomatch", (Object[])new Object[]{input}), false);
                        break;
                    }
                    ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.bonfires.match", (Object[])new Object[]{query.size(), input}), false);
                    BonfiresCommand.listQueriedBonfires(query, (class_2168)context.getSource());
                    break;
                }
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.bonfires.nouser", (Object[])new Object[]{input}), false);
                break;
            }
            case "radius": {
                int radius = IntegerArgumentType.getInteger(context, (String)"searchradius");
                List<Bonfire> query = BonfireHandler.getServerHandler(server).getRegistry().getBonfiresInRadius(new class_2338((int)((class_2168)context.getSource()).method_9222().field_1352, (int)((class_2168)context.getSource()).method_9222().field_1351, (int)((class_2168)context.getSource()).method_9222().field_1350), radius, ((class_2168)context.getSource()).method_9225().method_27983().method_29177());
                if (query.isEmpty()) {
                    ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.bonfires.radius.nomatch", (Object[])new Object[]{radius}), false);
                    break;
                }
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.bonfires.radius.match", (Object[])new Object[]{query.size(), radius}), false);
                BonfiresCommand.listQueriedBonfires(query, (class_2168)context.getSource());
                break;
            }
            case "filters": {
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.bonfires.all.desc", (Object[])new Object[]{"all"}), false);
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.bonfires.dim.desc", (Object[])new Object[]{"dim"}), false);
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.bonfires.name.desc", (Object[])new Object[]{"name"}), false);
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.bonfires.owner.desc", (Object[])new Object[]{"owner"}), false);
                ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.bonfires.radius.desc", (Object[])new Object[]{"radius"}), false);
                break;
            }
            default: {
                return 0;
            }
        }
        return 1;
    }

    private static void listQueriedBonfires(List<Bonfire> query, class_2168 sender) {
        query.forEach(bonfires -> {
            GameProfile owner = sender.method_9211().method_3793().method_14512(bonfires.getOwner()).orElse(null);
            String name = class_2561.method_43471((String)"command.bonfires.na").getString();
            if (owner != null) {
                name = owner.getName();
            }
            class_5250 messageName = class_2561.method_43469((String)"command.bonfires.name", (Object[])new Object[]{bonfires.getName()}).method_10862(class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11750, "/travel " + bonfires.getId().toString() + " " + sender.method_44023().method_5477().getString())).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43469((String)"command.bonfires.click.travel", (Object[])new Object[]{bonfires.getName()}))));
            class_5250 messageID = class_2561.method_43469((String)"command.bonfires.id", (Object[])new Object[]{bonfires.getId()}).method_10862(class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_21462, bonfires.getId().toString())).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43471((String)"chat.copy.click"))));
            String finalName = name;
            class_5250 messageOwner = class_2561.method_43469((String)"command.bonfires.owner", (Object[])new Object[]{name}).method_10862(class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_21462, finalName)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43471((String)"chat.copy.click"))));
            class_5250 messagePos = class_2561.method_43469((String)"command.bonfires.pos", (Object[])new Object[]{bonfires.getPos().method_10263(), bonfires.getPos().method_10264(), bonfires.getPos().method_10260()}).method_10862(class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_21462, bonfires.getPos().method_10263() + " " + bonfires.getPos().method_10264() + " " + bonfires.getPos().method_10260())).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43471((String)"chat.copy.click"))));
            class_5250 space = class_2561.method_43470((String)" ");
            sender.method_9226(() -> BonfiresCommand.lambda$listQueriedBonfires$26(messageName, (class_2561)space, messageID, messageOwner, messagePos), false);
        });
    }

    private static /* synthetic */ class_2561 lambda$listQueriedBonfires$26(class_5250 messageName, class_2561 space, class_5250 messageID, class_5250 messageOwner, class_5250 messagePos) {
        return messageName.method_10852(space).method_10852((class_2561)messageID).method_10852(space).method_10852((class_2561)messageOwner).method_10852(space).method_10852((class_2561)messagePos);
    }
}

