/*
 * Decompiled with CFR 0.152.
 */
package wehavecookies56.bonfires;

import io.wispforest.owo.config.Option;
import io.wispforest.owo.config.annotation.Config;
import io.wispforest.owo.config.annotation.Modmenu;
import io.wispforest.owo.config.annotation.Nest;
import io.wispforest.owo.config.annotation.PredicateConstraint;
import io.wispforest.owo.config.annotation.SectionHeader;
import io.wispforest.owo.config.annotation.Sync;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_3417;

@Modmenu(modId="bonfires")
@Config(name="bonfires-config", wrapperName="BonfiresMainConfig")
public class BonfiresConfig {
    @SectionHeader(value="Client")
    @Nest
    public Client client = new Client();
    @Sync(value=Option.SyncMode.OVERRIDE_CLIENT)
    @SectionHeader(value="Common")
    @Nest
    public Common common = new Common();

    public static class Client {
        public boolean renderTextAboveBonfire = true;
        @PredicateConstraint(value="validateIcons")
        public List<String> tabIcons = Arrays.asList("minecraft:overworld=minecraft:grass_block", "minecraft:the_nether=minecraft:netherrack", "minecraft:the_end=minecraft:end_stone", "kingdomkeys:dive_to_the_heart=kingdomkeys:mosaic_stained_glass");
        public boolean renderScreenshotsInGui = true;
        public boolean enableAutomaticScreenshotOnCreation = true;
        public boolean deleteScreenshotsOnDestroyed = true;
        @PredicateConstraint(value="validateRegistryKey")
        public List<String> hiddenDimensions = new ArrayList<String>();
        public boolean disableBonfireParticles = false;
        public String bonfireAmbientSound = class_3417.field_17483.method_14833().toString();

        public static boolean validateRegistryKey(List<String> input) {
            for (String entry : input) {
                if (entry.contains(":") || !entry.contains(" ")) continue;
                return false;
            }
            return true;
        }

        public static boolean validateIcons(List<String> input) {
            for (String entry : input) {
                if (entry.contains("=")) {
                    String[] split = entry.split("=");
                    if (split.length == 2) {
                        if (split[0].contains(":") || !split[1].contains(":")) continue;
                        return false;
                    }
                    return false;
                }
                return false;
            }
            return true;
        }
    }

    public static class Common {
        public boolean enableUBSBonfire = true;
        public boolean enableReinforcing = true;
        @PredicateConstraint(value="validateRegistryKey")
        public List<String> reinforceBlacklist = new ArrayList<String>();
        public double bonfireMonsterCheckRadius = 8.0;
        public boolean repairEquipment = false;
        public double estusFlaskBaseHeal = 6.0;
        public double estusFlaskHealPerLevel = 1.0;
        public double reinforceDamagePerLevel = 0.5;
        public boolean bonfireDiscoveryMode = true;
        public boolean disableAshDrops = false;
        public boolean disableBonfireRespawn = false;

        public static boolean validateRegistryKey(List<String> input) {
            for (String entry : input) {
                if (entry.contains(":") || !entry.contains(" ")) continue;
                return false;
            }
            return true;
        }
    }
}

