/*
 * Decompiled with CFR 0.152.
 */
package wehavecookies56.bonfires.blocks;

import java.util.List;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_247;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2753;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5250;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import wehavecookies56.bonfires.Bonfires;
import wehavecookies56.bonfires.bonfire.Bonfire;
import wehavecookies56.bonfires.bonfire.BonfireRegistry;
import wehavecookies56.bonfires.data.BonfireHandler;
import wehavecookies56.bonfires.data.DiscoveryHandler;
import wehavecookies56.bonfires.data.EstusHandler;
import wehavecookies56.bonfires.packets.PacketHandler;
import wehavecookies56.bonfires.packets.client.DeleteScreenshot;
import wehavecookies56.bonfires.packets.client.OpenBonfireGUI;
import wehavecookies56.bonfires.packets.client.OpenCreateScreen;
import wehavecookies56.bonfires.packets.client.SendBonfiresToClient;
import wehavecookies56.bonfires.packets.server.LightBonfire;
import wehavecookies56.bonfires.setup.BlockSetup;
import wehavecookies56.bonfires.setup.ItemSetup;
import wehavecookies56.bonfires.tiles.BonfireTileEntity;
import wehavecookies56.bonfires.world.BonfireTeleporter;

public class AshBonePileBlock
extends class_2248
implements class_2343 {
    public static final class_2753 FACING = class_2741.field_12481;
    public static final class_2746 LIT = class_2746.method_11825((String)"lit");
    public static final class_2746 EXPLODED = class_2746.method_11825((String)"exploded");

    public AshBonePileBlock() {
        super(class_4970.class_2251.method_9637().method_9626(class_2498.field_11526).method_22488().method_9632(0.8f).method_9631(AshBonePileBlock::getLightValue));
        this.method_9590((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)class_2350.field_11043)).method_11657((class_2769)LIT, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)EXPLODED, (Comparable)Boolean.valueOf(false)));
    }

    public float method_9575(class_2680 state, class_1922 world, class_2338 pos) {
        return 1.0f;
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        return (class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)FACING, (Comparable)ctx.method_8042().method_10153())).method_11657((class_2769)LIT, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)EXPLODED, (Comparable)Boolean.valueOf(false));
    }

    public Optional<class_243> getRespawnPosition(class_2338 pos, class_1937 world) {
        return Optional.of(BonfireTeleporter.attemptToPlaceNextToBonfire(pos, world));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{FACING, LIT, EXPLODED});
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    private void repair(class_1799 stack) {
        if (stack.method_7969() != null && stack.method_7969().method_10545("Damage")) {
            stack.method_7969().method_10569("Damage", 0);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_2586 class_25862 = world.method_8321(pos);
        if (!(class_25862 instanceof BonfireTileEntity)) return super.method_9534(state, world, pos, player, hand, hit);
        BonfireTileEntity te = (BonfireTileEntity)class_25862;
        if (te.isBonfire()) {
            if (!te.isLit()) {
                if (!world.field_9236) {
                    if (BonfireHandler.getServerHandler(world.method_8503()).getRegistry().getBonfire(te.getID()) != null) return super.method_9534(state, world, pos, player, hand, hit);
                    if (te.hasUnlitName()) return class_1269.field_5812;
                    PacketHandler.sendTo(new OpenCreateScreen(te), (class_3222)player);
                    world.method_8413(pos, state, state, 2);
                    return class_1269.field_5812;
                }
                if (!te.hasUnlitName()) return class_1269.field_5812;
                PacketHandler.sendToServer(new LightBonfire(te.getUnlitName(), te, !te.isUnlitPrivate(), Bonfires.CONFIG.client.enableAutomaticScreenshotOnCreation()));
                return class_1269.field_5812;
            }
            if (world.field_9236) return class_1269.field_5812;
            if (te.hasUnlitName()) {
                te.setUnlitName("");
                return class_1269.field_5812;
            }
            if (Bonfires.CONFIG.common.bonfireMonsterCheckRadius() > 0.0) {
                class_243 vec3 = class_243.method_24955((class_2382)new class_2382(pos.method_10263(), pos.method_10264(), pos.method_10260()));
                double r = Bonfires.CONFIG.common.bonfireMonsterCheckRadius();
                List list = world.method_8390(class_1588.class, new class_238(vec3.field_1352 - r, vec3.field_1351 - r, vec3.field_1350 - r, vec3.field_1352 + r, vec3.field_1351 + r, vec3.field_1350 + r), p_9062_ -> p_9062_.method_7076(player));
                if (!list.isEmpty()) {
                    player.method_43496((class_2561)class_2561.method_43471((String)"text.bonfires.enemy_nearby"));
                    return class_1269.field_5812;
                }
            }
            if (Bonfires.CONFIG.common.repairEquipment()) {
                player.method_31548().field_7547.forEach(this::repair);
                player.method_31548().field_7548.forEach(this::repair);
                player.method_31548().field_7544.forEach(this::repair);
            }
            DiscoveryHandler.IDiscoveryHandler discoveryHandler = DiscoveryHandler.getHandler(player);
            BonfireRegistry registry = BonfireHandler.getServerHandler(world.method_8503()).getRegistry();
            if (registry.getBonfire(te.getID()).isPublic() || registry.getBonfire(te.getID()).getOwner().equals(player.method_5667())) {
                discoveryHandler.discover(te.getID());
            }
            if (Bonfires.CONFIG.common.bonfireDiscoveryMode()) {
                registry = registry.getFilteredRegistry(discoveryHandler.getDiscovered().keySet().stream().toList());
            }
            if (registry.getBonfire(te.getID()) != null) {
                for (int i = 0; i < player.method_31548().field_7547.size(); ++i) {
                    if (class_1799.method_7984((class_1799)player.method_31548().method_5438(i), (class_1799)class_1799.field_8037) || player.method_31548().method_5438(i).method_7909() != ItemSetup.estus_flask || !player.method_31548().method_5438(i).method_7985()) continue;
                    player.method_31548().method_5438(i).method_7969().method_10569("estus", player.method_31548().method_5438(i).method_7969().method_10550("uses"));
                }
                PacketHandler.sendTo(new OpenBonfireGUI(te, BonfireRegistry.getOwnerNames(world.method_8503()), registry, Bonfires.CONFIG.common.enableReinforcing(), world.method_8503()), (class_3222)player);
                player.method_6025(player.method_6063());
                if (!Bonfires.CONFIG.common.disableBonfireRespawn()) {
                    ((class_3222)player).method_26284(te.method_10997().method_27983(), te.method_11016(), player.method_36454(), false, true);
                }
                EstusHandler.getHandler(player).setLastRested(te.getID());
            } else {
                te.setLit(false);
            }
            world.method_8413(pos, state, state, 2);
            return class_1269.field_5812;
        }
        if (player.method_5998(hand) == class_1799.field_8037) return super.method_9534(state, world, pos, player, hand, hit);
        if (player.method_5998(hand).method_7909() == ItemSetup.coiled_sword) {
            this.placeItem(world, te, pos, player, hand, BonfireTileEntity.BonfireType.BONFIRE);
        }
        world.method_8413(pos, state, state, 2);
        return class_1269.field_5811;
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        class_2487 compoundtag = itemStack.method_7969();
        if (compoundtag != null && compoundtag.method_10545("bonfire_private")) {
            world.method_8652(pos, state, 2);
            BonfireTileEntity te = new BonfireTileEntity(pos, state);
            te.setBonfire(true);
            te.setLit(false);
            te.setBonfireType(BonfireTileEntity.BonfireType.BONFIRE);
            if (compoundtag.method_10545("bonfire_name")) {
                te.setUnlitName(compoundtag.method_10558("bonfire_name"));
                te.setUnlitPrivate(compoundtag.method_10577("bonfire_private"));
            }
            world.method_8438((class_2586)te);
        }
        super.method_9567(world, pos, state, placer, itemStack);
    }

    public void placeItem(class_1937 world, BonfireTileEntity te, class_2338 pos, class_1657 player, class_1268 hand, BonfireTileEntity.BonfireType type) {
        if (!world.field_9236) {
            if (!player.method_7337()) {
                player.method_6122(hand, class_1799.field_8037);
            }
            world.method_8396(null, pos, class_3417.field_14785, class_3419.field_15245, 1.0f, 1.0f);
            te.setBonfire(true);
            te.setLit(false);
            te.setBonfireType(type);
        } else {
            world.method_8396(player, pos, class_3417.field_14785, class_3419.field_15245, 1.0f, 1.0f);
        }
    }

    public static int getLightValue(class_2680 state) {
        if (((Boolean)state.method_11654((class_2769)LIT)).booleanValue()) {
            return 8;
        }
        return 0;
    }

    public boolean method_9538(class_2680 state) {
        return true;
    }

    public void method_9536(class_2680 state, class_1937 world, class_2338 pos, class_2680 newState, boolean moved) {
        BonfireTileEntity te;
        if (newState.method_26204() != this && !world.method_8608() && (te = (BonfireTileEntity)world.method_8321(pos)) != null) {
            if (te.isBonfire() && !((Boolean)state.method_11654((class_2769)EXPLODED)).booleanValue()) {
                class_1542 fragment = new class_1542(world, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), new class_1799((class_1935)ItemSetup.coiled_sword_fragment));
                world.method_8649((class_1297)fragment);
            }
            if (te.isLit()) {
                MinecraftServer server = world.method_8503();
                Bonfire destroyed = BonfireHandler.getServerHandler(server).getRegistry().getBonfire(te.getID());
                te.destroyBonfire(te.getID());
                BonfireHandler.getServerHandler(server).removeBonfire(te.getID());
                if (Bonfires.CONFIG.common.bonfireDiscoveryMode()) {
                    server.method_3760().method_14571().forEach(serverPlayer -> PacketHandler.sendTo(new SendBonfiresToClient((class_3222)serverPlayer), serverPlayer));
                } else {
                    PacketHandler.sendToAll(new SendBonfiresToClient(server), server);
                }
                PacketHandler.sendToAll(new DeleteScreenshot(te.getID(), destroyed.getName()), server);
            }
        }
        super.method_9536(state, world, pos, newState, moved);
    }

    public void wasDestroyedByExplosion(class_1937 world, class_2338 pos) {
        if (Bonfires.CONFIG.common.enableUBSBonfire() && !world.field_9236) {
            class_1542 shard = new class_1542(world, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), new class_1799((class_1935)ItemSetup.undead_bone_shard));
            world.method_8649((class_1297)shard);
            class_2680 state = (class_2680)world.method_8320(pos).method_11657((class_2769)EXPLODED, (Comparable)Boolean.valueOf(true));
            world.method_8652(pos, state, 3);
        }
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_265 base = class_259.method_1082((class_265)class_2248.method_9541((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0), (class_265)class_2248.method_9541((double)4.0, (double)1.0, (double)4.0, (double)12.0, (double)2.0, (double)12.0), (class_247)class_247.field_1366);
        class_265 sword = class_2248.method_9541((double)5.0, (double)2.0, (double)5.0, (double)11.0, (double)20.0, (double)11.0);
        class_265 combined = class_259.method_1082((class_265)base, (class_265)sword, (class_247)class_247.field_1366);
        if (world.method_8321(pos) != null && world.method_8321(pos) instanceof BonfireTileEntity && ((BonfireTileEntity)world.method_8321(pos)).isBonfire()) {
            return combined;
        }
        return base;
    }

    public class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return this.method_9530(state, world, pos, context);
    }

    public boolean method_9543() {
        return true;
    }

    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        BonfireTileEntity bonfire;
        if (world.method_8321(pos) != null && (bonfire = (BonfireTileEntity)world.method_8321(pos)).isLit()) {
            double d0 = (double)pos.method_10263() + 0.5 + random.method_43058() * 3.0 / 16.0;
            double d1 = (double)pos.method_10264() + 0.2;
            double d2 = (double)pos.method_10260() + 0.5 + random.method_43058() * 1.0 / 16.0;
            double d3 = 0.52;
            double d4 = random.method_43058() * 0.6 - 0.3;
            double d5 = random.method_43058() * 0.6 - 0.3;
            class_2960 sound = null;
            if (!Bonfires.CONFIG.client.bonfireAmbientSound().isEmpty()) {
                sound = class_2960.method_12829((String)Bonfires.CONFIG.client.bonfireAmbientSound());
            }
            if (sound != null && random.method_43058() < 0.1) {
                world.method_8486((double)pos.method_10263() + 0.5, (double)pos.method_10264(), (double)pos.method_10260() + 0.5, class_3414.method_47908((class_2960)sound), class_3419.field_15245, 0.5f, 1.0f, false);
            }
            if (!Bonfires.CONFIG.client.disableBonfireParticles()) {
                world.method_8406((class_2394)class_2398.field_11240, d0 + d5, d1, d2 + d4, 0.0, 0.05, 0.0);
                world.method_8406((class_2394)class_2398.field_11240, d0 + d5, d1, d2 + d4, 0.0, 0.0, 0.0);
            }
        }
        super.method_9496(state, world, pos, random);
    }

    public void method_9568(class_1799 stack, @Nullable class_1922 world, List<class_2561> tooltip, class_1836 options) {
        class_2487 tag;
        super.method_9568(stack, world, tooltip, options);
        if (stack.method_7969() != null && (tag = stack.method_7969()).method_10545("bonfire_private")) {
            class_5250 text = class_2561.method_43471((String)"tooltip.bonfires.unlit");
            if (tag.method_10545("bonfire_name")) {
                text.method_27693(" ");
                text.method_10852((class_2561)class_2561.method_43471((String)tag.method_10558("bonfire_name")));
            }
            if (tag.method_10577("bonfire_private")) {
                text.method_27693(" ");
                text.method_10852((class_2561)class_2561.method_43471((String)"text.bonfires.private"));
            }
            tooltip.add((class_2561)text);
        }
    }

    public class_1799 method_9574(class_1922 world, class_2338 pos, class_2680 state) {
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof BonfireTileEntity) {
            BonfireTileEntity te = (BonfireTileEntity)class_25862;
            class_1799 stack = new class_1799((class_1935)BlockSetup.ash_bone_pile);
            if (te.isBonfire()) {
                stack.method_7980(new class_2487());
                stack.method_7969().method_10556("bonfire_private", false);
                if (te.hasUnlitName()) {
                    stack.method_7969().method_10582("bonfire_name", te.getUnlitName());
                }
            }
            return stack;
        }
        return super.method_9574(world, pos, state);
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new BonfireTileEntity(pos, state);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return (world1, pos, state1, blockEntity) -> BonfireTileEntity.tick(world1, pos, state1, (BonfireTileEntity)blockEntity);
    }
}

