/*
 * Decompiled with CFR 0.152.
 */
package wehavecookies56.bonfires.bonfire;

import com.mojang.authlib.GameProfile;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3312;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import wehavecookies56.bonfires.bonfire.Bonfire;

public class BonfireRegistry {
    private Map<UUID, Bonfire> bonfires = new HashMap<UUID, Bonfire>();

    public static Map<UUID, String> getOwnerNames(MinecraftServer server) {
        HashMap<UUID, String> ownerNames = new HashMap<UUID, String>();
        server.method_3760().method_14571().forEach(serverPlayer -> {
            class_3312 gameProfileCache = server.method_3793();
            if (gameProfileCache.method_14512(serverPlayer.method_5667()).isPresent()) {
                ownerNames.put(serverPlayer.method_5667(), ((GameProfile)gameProfileCache.method_14512(serverPlayer.method_5667()).get()).getName());
            } else {
                ownerNames.put(serverPlayer.method_5667(), "Unknown");
            }
        });
        return ownerNames;
    }

    public BonfireRegistry getFilteredRegistry(List<UUID> filter) {
        BonfireRegistry registry = new BonfireRegistry();
        Map<UUID, Bonfire> bonfires = this.getBonfires();
        HashMap<UUID, Bonfire> filtered = new HashMap<UUID, Bonfire>();
        bonfires.forEach((uuid, bonfire) -> {
            if (filter.contains(uuid)) {
                filtered.put((UUID)uuid, (Bonfire)bonfire);
            }
        });
        registry.setBonfires(filtered);
        return registry;
    }

    public Map<UUID, Bonfire> getBonfires() {
        return this.bonfires;
    }

    public void setBonfires(Map<UUID, Bonfire> bonfires) {
        this.bonfires = bonfires;
    }

    public boolean removeBonfire(UUID id) {
        if (this.bonfires.containsKey(id)) {
            this.bonfires.remove(id);
            return true;
        }
        return false;
    }

    public List<Bonfire> getBonfiresByOwner(UUID owner) {
        return this.getBonfires().values().stream().filter(bonfire -> bonfire.getOwner().compareTo(owner) == 0).toList();
    }

    public List<Bonfire> getBonfiresByName(String name) {
        return this.getBonfires().values().stream().filter(bonfire -> bonfire.getName().toLowerCase().contains(name.toLowerCase())).toList();
    }

    public List<Bonfire> getBonfiresInRadius(class_2338 pos, int radius, class_2960 dimension) {
        return this.getBonfiresByDimension(dimension).stream().filter(bonfire -> {
            int cx = pos.method_10263();
            int cz = pos.method_10260();
            int cy = pos.method_10264();
            int fx = bonfire.getPos().method_10263();
            int fz = bonfire.getPos().method_10260();
            int fy = bonfire.getPos().method_10264();
            int tx = cx + radius;
            int bx = cx - radius;
            int tz = cz + radius;
            int bz = cz - radius;
            int ty = cy + radius;
            int by = cy - radius;
            return fx <= tx && fx >= bx && fz <= tz && fz >= bz && fy <= ty && fy >= by;
        }).collect(Collectors.toList());
    }

    public Bonfire getBonfireAtPos(class_2338 pos, class_5321<class_1937> dim) {
        List<Bonfire> result = this.getBonfiresByDimension(dim.method_29177()).stream().filter(bonfire -> pos.equals((Object)bonfire.getPos())).toList();
        if (result.size() > 0) {
            return result.get(0);
        }
        return null;
    }

    private List<Bonfire> getBonfiresByPublic(boolean isPublic) {
        return this.getBonfires().values().stream().filter(bonfire -> bonfire.isPublic == isPublic).collect(Collectors.toList());
    }

    private List<Bonfire> getPrivateBonfiresByOwner(UUID owner) {
        return this.getBonfires().values().stream().filter(bonfire -> bonfire.getOwner().compareTo(owner) == 0 && !bonfire.isPublic).collect(Collectors.toList());
    }

    private List<Bonfire> getBonfiresByPublicPerDimension(boolean isPublic, class_2960 dim) {
        return this.getBonfires().values().stream().filter(bonfire -> bonfire.getDimension().method_29177().equals((Object)dim) && bonfire.isPublic).collect(Collectors.toList());
    }

    private List<Bonfire> getPrivateBonfiresByOwnerPerDimension(UUID owner, class_2960 dim) {
        return this.getBonfires().values().stream().filter(bonfire -> bonfire.getOwner().compareTo(owner) == 0 && !bonfire.isPublic && bonfire.getDimension().method_29177().equals((Object)dim)).collect(Collectors.toList());
    }

    public List<Bonfire> getPrivateBonfiresByOwnerAndPublicPerDimension(UUID owner, class_2960 dim) {
        ArrayList<Bonfire> list = new ArrayList<Bonfire>();
        list.addAll(this.getBonfiresByPublicPerDimension(true, dim));
        list.addAll(this.getPrivateBonfiresByOwnerPerDimension(owner, dim));
        return list;
    }

    public static List<Bonfire> sortBonfiresByTime(List<Bonfire> bonfiresToSort) {
        ArrayList<Bonfire> sortedList = new ArrayList<Bonfire>(bonfiresToSort);
        sortedList.sort(Comparator.comparing(Bonfire::getTimeCreated).reversed());
        return sortedList;
    }

    public List<Bonfire> getPrivateBonfiresByOwnerAndPublic(UUID owner) {
        ArrayList<Bonfire> list = new ArrayList<Bonfire>();
        list.addAll(this.getBonfiresByPublic(true));
        list.addAll(this.getPrivateBonfiresByOwner(owner));
        return list;
    }

    public List<Bonfire> getBonfiresByDimension(class_2960 dimension) {
        return this.getBonfires().values().stream().filter(bonfire -> bonfire.getDimension().method_29177().equals((Object)dimension)).collect(Collectors.toList());
    }

    public boolean addBonfire(Bonfire bonfire) {
        if (this.bonfires.containsKey(bonfire.getId()) || this.getBonfireAtPos(bonfire.getPos(), bonfire.getDimension()) != null) {
            return false;
        }
        this.bonfires.put(bonfire.getId(), bonfire);
        return true;
    }

    public Bonfire getBonfire(UUID id) {
        return this.bonfires.getOrDefault(id, null);
    }

    public class_2487 writeToNBT(class_2487 tagCompound, Map<UUID, Bonfire> bonfires) {
        for (Map.Entry<UUID, Bonfire> pair : bonfires.entrySet()) {
            class_2487 bonfireCompound = new class_2487();
            bonfireCompound.method_25927("ID", pair.getValue().getId());
            bonfireCompound.method_10582("NAME", pair.getValue().getName());
            bonfireCompound.method_25927("OWNER", pair.getValue().getOwner());
            bonfireCompound.method_10556("PUBLIC", pair.getValue().isPublic());
            bonfireCompound.method_10582("DIM", pair.getValue().getDimension().method_29177().toString());
            bonfireCompound.method_10549("POSX", (double)pair.getValue().getPos().method_10263());
            bonfireCompound.method_10549("POSY", (double)pair.getValue().getPos().method_10264());
            bonfireCompound.method_10549("POSZ", (double)pair.getValue().getPos().method_10260());
            class_2487 timeCompound = new class_2487();
            timeCompound.method_10544("SECOND", pair.getValue().getTimeCreated().getEpochSecond());
            timeCompound.method_10569("NANO", pair.getValue().getTimeCreated().getNano());
            bonfireCompound.method_10566("TIME", (class_2520)timeCompound);
            tagCompound.method_10566(pair.getKey().toString(), (class_2520)bonfireCompound);
        }
        return tagCompound;
    }

    public void readFromNBT(class_2487 tagCompound, Map<UUID, Bonfire> bonfires) {
        for (String key : tagCompound.method_10541()) {
            Instant time;
            if (key.equals("loaded_old_data")) continue;
            class_2487 compound = tagCompound.method_10562(key);
            String name = compound.method_10558("NAME");
            UUID id = compound.method_25926("ID");
            UUID owner = compound.method_25926("OWNER");
            class_2338 pos = new class_2338((int)compound.method_10574("POSX"), (int)compound.method_10574("POSY"), (int)compound.method_10574("POSZ"));
            class_5321 dimension = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)new class_2960(compound.method_10558("DIM")));
            boolean isPublic = compound.method_10577("PUBLIC");
            if (compound.method_10573("TIME", 10)) {
                class_2487 timeCompound = compound.method_10562("TIME");
                time = Instant.ofEpochSecond(timeCompound.method_10537("SECOND"), timeCompound.method_10550("NANO"));
            } else {
                time = Instant.now();
            }
            Bonfire bonfire = new Bonfire(name, id, owner, pos, (class_5321<class_1937>)dimension, isPublic, time);
            if (this.getBonfireAtPos(pos, (class_5321<class_1937>)dimension) != null) continue;
            bonfires.put(id, bonfire);
        }
    }
}

