/*
 * Decompiled with CFR 0.152.
 */
package wehavecookies56.bonfires.client;

import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1074;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_437;
import org.apache.commons.lang3.text.WordUtils;
import wehavecookies56.bonfires.Bonfires;
import wehavecookies56.bonfires.LocalStrings;
import wehavecookies56.bonfires.bonfire.Bonfire;
import wehavecookies56.bonfires.client.ScreenshotUtils;
import wehavecookies56.bonfires.client.gui.BonfireScreen;
import wehavecookies56.bonfires.client.gui.CreateBonfireScreen;
import wehavecookies56.bonfires.data.EstusHandler;
import wehavecookies56.bonfires.packets.client.DeleteScreenshot;
import wehavecookies56.bonfires.packets.client.DisplayBonfireTitle;
import wehavecookies56.bonfires.packets.client.DisplayTitle;
import wehavecookies56.bonfires.packets.client.OpenBonfireGUI;
import wehavecookies56.bonfires.packets.client.OpenCreateScreen;
import wehavecookies56.bonfires.packets.client.QueueBonfireScreenshot;
import wehavecookies56.bonfires.packets.client.SendBonfiresToClient;
import wehavecookies56.bonfires.tiles.BonfireTileEntity;

public class ClientPacketHandler {
    public static void openBonfire(OpenBonfireGUI packet) {
        class_310.method_1551().method_1507((class_437)new BonfireScreen((BonfireTileEntity)class_310.method_1551().field_1687.method_8321(packet.tileEntity), packet.ownerNames, packet.dimensions.stream().filter(dim -> !Bonfires.CONFIG.client.hiddenDimensions().contains(dim.method_29177().toString())).toList(), packet.registry, packet.canReinforce));
    }

    public static void setBonfiresFromServer(SendBonfiresToClient packet) {
        class_437 class_4372;
        if (class_310.method_1551().field_1755 != null && (class_4372 = class_310.method_1551().field_1755) instanceof BonfireScreen) {
            BonfireScreen gui = (BonfireScreen)class_4372;
            gui.updateDimensionsFromServer(packet.registry, packet.dimensions.stream().filter(dim -> !Bonfires.CONFIG.client.hiddenDimensions().contains(dim.method_29177().toString())).toList(), packet.ownerNames);
        }
    }

    public static void init() {
        ClientPlayNetworking.registerGlobalReceiver(DeleteScreenshot.TYPE, (packet, player, responseSender) -> packet.handle());
        ClientPlayNetworking.registerGlobalReceiver(DisplayBonfireTitle.TYPE, (packet, player, responseSender) -> packet.handle());
        ClientPlayNetworking.registerGlobalReceiver(DisplayTitle.TYPE, (packet, player, responseSender) -> packet.handle());
        ClientPlayNetworking.registerGlobalReceiver(OpenCreateScreen.TYPE, (packet, player, responseSender) -> packet.handle());
        ClientPlayNetworking.registerGlobalReceiver(OpenBonfireGUI.TYPE, (packet, player, responseSender) -> packet.handle());
        ClientPlayNetworking.registerGlobalReceiver(QueueBonfireScreenshot.TYPE, (packet, player, responseSender) -> packet.handle());
        ClientPlayNetworking.registerGlobalReceiver(SendBonfiresToClient.TYPE, (packet, player, responseSender) -> packet.handle());
    }

    public static void openCreateScreen(BonfireTileEntity te) {
        class_310.method_1551().method_1507((class_437)new CreateBonfireScreen(te));
    }

    public static void displayTitle(DisplayTitle packet) {
        class_329 gui = class_310.method_1551().field_1705;
        gui.method_34004((class_2561)class_2561.method_43471((String)packet.title));
        gui.method_34002((class_2561)class_2561.method_43471((String)packet.subtitle));
        gui.method_34001(packet.fadein, packet.stay, packet.fadeout);
    }

    public static void syncSaveData(Map<UUID, Bonfire> bonfires) {
    }

    public static void syncEstusData(UUID lastRested) {
        EstusHandler.IEstusHandler handler = EstusHandler.getHandler((class_1657)class_310.method_1551().field_1724);
        handler.setLastRested(lastRested);
    }

    public static void displayBonfireTravelled(Bonfire bonfire) {
        String formattedDimName;
        if (class_1074.method_4663((String)LocalStrings.getDimensionKey(bonfire.getDimension()))) {
            String dimName = bonfire.getDimension().method_29177().method_12832().replaceAll("_", " ");
            formattedDimName = WordUtils.capitalizeFully((String)dimName);
        } else {
            formattedDimName = class_1074.method_4662((String)LocalStrings.getDimensionKey(bonfire.getDimension()), (Object[])new Object[0]);
        }
        class_329 gui = class_310.method_1551().field_1705;
        gui.method_34004((class_2561)class_2561.method_43471((String)bonfire.getName()));
        gui.method_34002((class_2561)class_2561.method_43471((String)formattedDimName));
        gui.method_34001(10, 20, 10);
    }

    public static void queueBonfireScreenshot(String name, UUID uuid) {
        ScreenshotUtils.startScreenshotTimer(name, uuid);
    }

    public static void deleteScreenshot(UUID uuid, String name) {
        if (Bonfires.CONFIG.client.deleteScreenshotsOnDestroyed()) {
            Path screenshotsDir = Paths.get(class_310.method_1551().field_1697.getPath(), "bonfires/");
            String fileName = ScreenshotUtils.getFileNameString(name, uuid);
            File screenshotFile = new File(screenshotsDir.toFile(), fileName);
            if (screenshotFile.exists() && screenshotFile.isFile()) {
                String path = screenshotFile.getPath();
                if (!screenshotFile.delete()) {
                    Bonfires.LOGGER.warn("Failed to delete screenshot file " + path);
                } else {
                    Bonfires.LOGGER.info("Deleted screenshot for destroyed bonfire " + fileName);
                }
            }
        }
    }
}

