/*
 * Decompiled with CFR 0.152.
 */
package wehavecookies56.bonfires.data;

import dev.onyxstudios.cca.api.v3.component.ComponentKey;
import dev.onyxstudios.cca.api.v3.component.ComponentRegistry;
import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent;
import dev.onyxstudios.cca.api.v3.world.WorldComponentFactoryRegistry;
import dev.onyxstudios.cca.api.v3.world.WorldComponentInitializer;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.UUID;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.server.MinecraftServer;
import wehavecookies56.bonfires.Bonfires;
import wehavecookies56.bonfires.bonfire.Bonfire;
import wehavecookies56.bonfires.bonfire.BonfireRegistry;
import wehavecookies56.bonfires.mixins.WorldSavePathMixin;

public class BonfireHandler
implements WorldComponentInitializer {
    public static final ComponentKey<IBonfireHandler> BONFIRES = ComponentRegistry.getOrCreate((class_2960)new class_2960("bonfires", "bonfires"), IBonfireHandler.class);

    public static IBonfireHandler getServerHandler(MinecraftServer server) {
        return (IBonfireHandler)BONFIRES.get((Object)server.method_30002());
    }

    public void registerWorldComponentFactories(WorldComponentFactoryRegistry registry) {
        registry.register(BONFIRES, Default::new);
    }

    public static interface IBonfireHandler
    extends AutoSyncedComponent {
        public BonfireRegistry getRegistry();

        public boolean addBonfire(Bonfire var1);

        public boolean removeBonfire(UUID var1);

        public boolean loadedOldData();

        public void loadOldBonfireData(MinecraftServer var1);
    }

    public static class Default
    implements IBonfireHandler {
        class_1937 provider;
        boolean loadedOldData = false;
        BonfireRegistry registry = new BonfireRegistry();

        public Default(class_1937 provider) {
            this.provider = provider;
        }

        @Override
        public BonfireRegistry getRegistry() {
            return this.registry;
        }

        @Override
        public boolean addBonfire(Bonfire bonfire) {
            boolean result = this.registry.addBonfire(bonfire);
            BONFIRES.sync((Object)this.provider);
            return result;
        }

        @Override
        public boolean removeBonfire(UUID id) {
            boolean result = this.registry.removeBonfire(id);
            BONFIRES.sync((Object)this.provider);
            return result;
        }

        @Override
        public void loadOldBonfireData(MinecraftServer server) {
            if (!this.loadedOldData) {
                File bonfireDataDat;
                BonfireRegistry reg;
                File worldDataFolder = server.method_27050(WorldSavePathMixin.create("data")).toFile();
                File capabilitiesDat = new File(worldDataFolder, "capabilities.dat");
                if (capabilitiesDat.exists()) {
                    try {
                        Bonfires.LOGGER.info("Attempting to convert existing Bonfire data from capabilities.dat");
                        FileInputStream fileinputstream = new FileInputStream(capabilitiesDat);
                        PushbackInputStream pushbackinputstream = new PushbackInputStream(fileinputstream, 2);
                        DataInputStream inputStream = new DataInputStream(pushbackinputstream);
                        class_2487 main = class_2507.method_10629((InputStream)inputStream);
                        class_2487 data = main.method_10562("data");
                        if (data.method_10545("bonfires:bonfire")) {
                            class_2487 bonfires = data.method_10562("bonfires:bonfire");
                            reg = new BonfireRegistry();
                            reg.readFromNBT(bonfires, reg.getBonfires());
                            reg.getBonfires().entrySet().forEach(entry -> this.addBonfire((Bonfire)entry.getValue()));
                            this.loadedOldData = true;
                            main.method_10562("data").method_10551("bonfires:bonfire");
                            class_2507.method_30614((class_2487)main, (File)capabilitiesDat);
                            BONFIRES.sync((Object)this.provider);
                            Bonfires.LOGGER.info("Existing old data successfully loaded");
                        }
                    }
                    catch (IOException e) {
                        Bonfires.LOGGER.info("Existing data either doesn't exist or failed to load, ignoring.");
                        this.loadedOldData = true;
                        BONFIRES.sync((Object)this.provider);
                    }
                }
                if (!this.loadedOldData && (bonfireDataDat = new File(worldDataFolder, "bonfires_data.dat")).exists()) {
                    try {
                        Bonfires.LOGGER.info("Attempting to convert existing Bonfire data from bonfires_data.dat");
                        FileInputStream fileinputstream = new FileInputStream(bonfireDataDat);
                        PushbackInputStream pushbackinputstream = new PushbackInputStream(fileinputstream, 2);
                        DataInputStream inputStream = new DataInputStream(pushbackinputstream);
                        class_2487 main = class_2507.method_10629((InputStream)inputStream);
                        class_2487 data = main.method_10562("data");
                        if (!data.method_33133()) {
                            reg = new BonfireRegistry();
                            reg.readFromNBT(data, reg.getBonfires());
                            reg.getBonfires().entrySet().forEach(entry -> this.addBonfire((Bonfire)entry.getValue()));
                            this.loadedOldData = true;
                            main.method_10551("data");
                            main.method_10566("data", (class_2520)new class_2487());
                            class_2507.method_30614((class_2487)main, (File)bonfireDataDat);
                            BONFIRES.sync((Object)this.provider);
                            Bonfires.LOGGER.info("Existing old data successfully loaded");
                        }
                    }
                    catch (IOException e) {
                        Bonfires.LOGGER.info("Existing data either doesn't exist or failed to load, ignoring.");
                        this.loadedOldData = true;
                        BONFIRES.sync((Object)this.provider);
                    }
                }
            }
        }

        @Override
        public boolean loadedOldData() {
            return this.loadedOldData;
        }

        public void readFromNbt(class_2487 tag) {
            this.getRegistry().readFromNBT(tag, this.getRegistry().getBonfires());
            this.loadedOldData = tag.method_10577("loaded_old_data");
        }

        public void writeToNbt(class_2487 tag) {
            this.getRegistry().writeToNBT(tag, this.getRegistry().getBonfires());
            tag.method_10556("loaded_old_data", this.loadedOldData());
        }
    }
}

