/*
 * Decompiled with CFR 0.152.
 */
package wehavecookies56.bonfires.data;

import dev.onyxstudios.cca.api.v3.component.ComponentKey;
import dev.onyxstudios.cca.api.v3.component.ComponentRegistry;
import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent;
import dev.onyxstudios.cca.api.v3.entity.EntityComponentFactoryRegistry;
import dev.onyxstudios.cca.api.v3.entity.EntityComponentInitializer;
import dev.onyxstudios.cca.api.v3.entity.RespawnCopyStrategy;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;

public class DiscoveryHandler
implements EntityComponentInitializer {
    public static final ComponentKey<IDiscoveryHandler> DISCOVERY = ComponentRegistry.getOrCreate((class_2960)new class_2960("bonfires", "discovery"), IDiscoveryHandler.class);

    public void registerEntityComponentFactories(EntityComponentFactoryRegistry registry) {
        registry.registerForPlayers(DISCOVERY, player -> new Default(), RespawnCopyStrategy.ALWAYS_COPY);
    }

    public static IDiscoveryHandler getHandler(class_1657 player) {
        return (IDiscoveryHandler)DISCOVERY.get((Object)player);
    }

    public static interface IDiscoveryHandler
    extends AutoSyncedComponent {
        public void setDiscovered(UUID var1, Instant var2);

        public void discover(UUID var1);

        public Map<UUID, Instant> getDiscovered();
    }

    public class Default
    implements IDiscoveryHandler {
        private Map<UUID, Instant> discovered = new HashMap<UUID, Instant>();

        @Override
        public void setDiscovered(UUID bonfire, Instant time) {
            this.discovered.put(bonfire, time);
        }

        @Override
        public void discover(UUID bonfire) {
            if (!this.discovered.containsKey(bonfire)) {
                this.discovered.put(bonfire, Instant.now());
            }
        }

        @Override
        public Map<UUID, Instant> getDiscovered() {
            return this.discovered;
        }

        public void readFromNbt(class_2487 tag) {
            tag.method_10541().forEach(uuidString -> {
                class_2487 timeTag = tag.method_10562(uuidString);
                Instant time = Instant.ofEpochSecond(timeTag.method_10537("epoch"), timeTag.method_10550("nano"));
                this.discovered.put(UUID.fromString(uuidString), time);
            });
        }

        public void writeToNbt(class_2487 tag) {
            this.discovered.forEach((uuid, instant) -> {
                class_2487 time = new class_2487();
                time.method_10544("epoch", instant.getEpochSecond());
                time.method_10569("nano", instant.getNano());
                tag.method_10566(uuid.toString(), (class_2520)time);
            });
        }
    }
}

