/*
 * Decompiled with CFR 0.152.
 */
package wehavecookies56.bonfires.data;

import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1829;
import net.minecraft.class_1831;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import wehavecookies56.bonfires.Bonfires;
import wehavecookies56.bonfires.items.EstusFlaskItem;
import wehavecookies56.bonfires.setup.ItemSetup;

public class ReinforceHandler {
    public static boolean canReinforce(class_1799 stack) {
        class_1792 i = stack.method_7909();
        for (String s : Bonfires.CONFIG.common.reinforceBlacklist()) {
            if (class_7923.field_41178.method_10250(new class_2960(s))) {
                class_1792 blacklistedItem = (class_1792)class_7923.field_41178.method_10223(new class_2960(s));
                if (i != blacklistedItem) continue;
                return false;
            }
            Bonfires.LOGGER.info("Unable to find blacklisted item '" + s + "' in the registry");
        }
        return i instanceof class_1831 || i instanceof class_1829 || i instanceof EstusFlaskItem;
    }

    public static ReinforceLevel getReinforceLevel(class_1799 stack) {
        int levelFromCap = 0;
        int maxLevelFromCap = 10;
        if (ReinforceHandler.canReinforce(stack)) {
            if (stack.method_7985()) {
                if (stack.method_7969().method_10545("reinforce_level")) {
                    return new ReinforceLevel(stack.method_7969().method_10550("reinforce_level"), stack.method_7969().method_10550("reinforce_max"));
                }
                stack.method_7969().method_10569("reinforce_level", levelFromCap);
                stack.method_7969().method_10569("reinforce_max", maxLevelFromCap);
                return new ReinforceLevel(levelFromCap, maxLevelFromCap);
            }
            class_2487 tag = new class_2487();
            tag.method_10569("reinforce_level", levelFromCap);
            tag.method_10569("reinforce_max", maxLevelFromCap);
            stack.method_7980(tag);
            return new ReinforceLevel(levelFromCap, maxLevelFromCap);
        }
        return null;
    }

    public static void levelUp(class_1799 stack) {
        ReinforceLevel current = ReinforceHandler.getReinforceLevel(stack);
        if (current != null && current.level() < stack.method_7969().method_10550("reinforce_max")) {
            stack.method_7969().method_10569("reinforce_level", current.level() + 1);
        }
    }

    public static class_1799 getRequiredResources(class_1799 toReinforce) {
        if (ReinforceHandler.getReinforceLevel(toReinforce) != null) {
            ReinforceLevel rlevel = ReinforceHandler.getReinforceLevel(toReinforce);
            if (toReinforce.method_7909() == ItemSetup.estus_flask) {
                if (rlevel.level() < rlevel.maxLevel()) {
                    return new class_1799((class_1935)ItemSetup.undead_bone_shard);
                }
                return class_1799.field_8037;
            }
            if (rlevel.level() < rlevel.maxLevel()) {
                int cost = 1;
                class_1792 material = class_1799.field_8037.method_7909();
                if (rlevel.level() >= 0 && rlevel.level() <= 2) {
                    cost = 2 * (rlevel.level() + 1);
                    material = ItemSetup.titanite_shard;
                }
                if (rlevel.level() >= 3 && rlevel.level() <= 5) {
                    cost = 2 * (rlevel.level() + 1 - 3);
                    material = ItemSetup.large_titanite_shard;
                }
                if (rlevel.level() >= 6 && rlevel.level() <= 8) {
                    cost = 2 * (rlevel.level() + 1 - 6);
                    material = ItemSetup.titanite_chunk;
                }
                if (rlevel.level() >= 9 && rlevel.level() < 10) {
                    cost = 1;
                    material = ItemSetup.titanite_slab;
                }
                return new class_1799((class_1935)material, cost);
            }
        }
        return class_1799.field_8037;
    }

    public static boolean hasRequiredItems(class_1657 player, class_1799 required) {
        int hasCount = 0;
        int countRequired = required.method_7947();
        for (int i = 0; i < player.method_31548().field_7547.size(); ++i) {
            if (class_1799.method_7973((class_1799)required, (class_1799)player.method_31548().method_5438(i))) {
                return true;
            }
            if (!class_1799.method_7984((class_1799)player.method_31548().method_5438(i), (class_1799)required)) continue;
            hasCount += player.method_31548().method_5438(i).method_7947();
        }
        return hasCount >= countRequired;
    }

    public static void removeRequiredItems(class_1657 player, class_1799 required) {
        if (ReinforceHandler.hasRequiredItems(player, required)) {
            int remaining = required.method_7947();
            for (int i = 0; i < player.method_31548().field_7547.size(); ++i) {
                class_1799 item = player.method_31548().method_5438(i);
                if (class_1799.method_7984((class_1799)required, (class_1799)item)) {
                    if (item.method_7947() >= remaining) {
                        item.method_7934(remaining);
                        return;
                    }
                    remaining -= item.method_7947();
                    player.method_31548().method_5447(i, class_1799.field_8037);
                }
                if (remaining != 0) continue;
                return;
            }
        }
    }

    public static final class ReinforceLevel {
        private int level;
        private int maxLevel;

        private ReinforceLevel(int level, int maxLevel) {
            this.level = level;
            this.maxLevel = maxLevel;
        }

        public int level() {
            return this.level;
        }

        public int maxLevel() {
            return this.maxLevel;
        }
    }
}

