/*
 * Decompiled with CFR 0.152.
 */
package wehavecookies56.bonfires.packets.server;

import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PacketType;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import wehavecookies56.bonfires.Bonfires;
import wehavecookies56.bonfires.advancements.BonfireLitTrigger;
import wehavecookies56.bonfires.blocks.AshBonePileBlock;
import wehavecookies56.bonfires.data.DiscoveryHandler;
import wehavecookies56.bonfires.data.EstusHandler;
import wehavecookies56.bonfires.packets.PacketHandler;
import wehavecookies56.bonfires.packets.client.DisplayTitle;
import wehavecookies56.bonfires.packets.client.QueueBonfireScreenshot;
import wehavecookies56.bonfires.packets.client.SendBonfiresToClient;
import wehavecookies56.bonfires.tiles.BonfireTileEntity;

public class LightBonfire
implements FabricPacket {
    public static final PacketType<LightBonfire> TYPE = PacketType.create((class_2960)new class_2960("bonfires", "light_bonfire"), LightBonfire::new);
    private String name;
    private int x;
    private int y;
    private int z;
    private boolean isPublic;
    private boolean createScreenshot;

    public LightBonfire(class_2540 buffer) {
        this.decode(buffer);
    }

    public LightBonfire(String name, BonfireTileEntity bonfire, boolean isPublic, boolean createScreenshot) {
        this.name = name;
        this.x = bonfire.method_11016().method_10263();
        this.y = bonfire.method_11016().method_10264();
        this.z = bonfire.method_11016().method_10260();
        this.isPublic = isPublic;
        this.createScreenshot = createScreenshot;
    }

    public void decode(class_2540 buffer) {
        this.name = buffer.method_19772();
        this.x = buffer.readInt();
        this.y = buffer.readInt();
        this.z = buffer.readInt();
        this.isPublic = buffer.readBoolean();
        this.createScreenshot = buffer.readBoolean();
    }

    public void handle(class_3222 player) {
        BonfireTileEntity te;
        class_2338 pos = new class_2338(this.x, this.y, this.z);
        if (player != null && (te = (BonfireTileEntity)player.method_37908().method_8321(pos)) != null && !te.isLit()) {
            te.setLit(true);
            UUID id = UUID.randomUUID();
            te.createBonfire(this.name, id, player.method_5667(), this.isPublic);
            te.setID(id);
            player.method_37908().method_8652(pos, (class_2680)player.method_37908().method_8320(pos).method_11657((class_2769)AshBonePileBlock.LIT, (Comparable)Boolean.valueOf(true)), 2);
            if (!Bonfires.CONFIG.common.disableBonfireRespawn()) {
                player.method_26284(te.method_10997().method_27983(), te.method_11016(), player.method_36454(), false, true);
            }
            EstusHandler.getHandler((class_1657)player).setLastRested(te.getID());
            DiscoveryHandler.getHandler((class_1657)player).discover(id);
            BonfireLitTrigger.INSTANCE.trigger(player);
            player.method_7281(Bonfires.BONFIRES_LIT);
            if (!Bonfires.CONFIG.common.bonfireDiscoveryMode()) {
                PacketHandler.sendToAll(new SendBonfiresToClient(player.field_13995), player.field_13995);
            }
            if (this.createScreenshot) {
                PacketHandler.sendTo(new QueueBonfireScreenshot(this.name, id), player);
            }
            PacketHandler.sendTo(new DisplayTitle("bonfire.lit", this.name, 15, 20, 15), player);
            Bonfires.LOGGER.info("Bonfire'" + this.name + "' lit at: X" + this.x + " Y" + this.y + " Z" + this.z + " by " + player.method_5476().getString());
        }
    }

    public void write(class_2540 buffer) {
        buffer.method_10814(this.name);
        buffer.writeInt(this.x);
        buffer.writeInt(this.y);
        buffer.writeInt(this.z);
        buffer.writeBoolean(this.isPublic);
        buffer.writeBoolean(this.createScreenshot);
    }

    public PacketType<?> getType() {
        return TYPE;
    }
}

