/*
 * Decompiled with CFR 0.152.
 */
package wehavecookies56.bonfires.tiles;

import java.time.Instant;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;
import wehavecookies56.bonfires.Bonfires;
import wehavecookies56.bonfires.bonfire.Bonfire;
import wehavecookies56.bonfires.data.BonfireHandler;
import wehavecookies56.bonfires.setup.EntitySetup;

public class BonfireTileEntity
extends class_2586 {
    private boolean bonfire = false;
    private boolean lit = false;
    private UUID id = UUID.randomUUID();
    private Bonfire bonfireInstance;
    private boolean unlitPrivate = false;
    private String unlitName;
    private BonfireType type = BonfireType.NONE;

    public BonfireTileEntity(class_2338 pos, class_2680 state) {
        super(EntitySetup.BONFIRE, pos, state);
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, BonfireTileEntity be) {
        if (be.bonfireInstance == null && world != null && !world.field_9236) {
            be.bonfireInstance = BonfireHandler.getServerHandler(world.method_8503()).getRegistry().getBonfire(be.id);
        }
    }

    public void method_11014(class_2487 compound) {
        super.method_11014(compound);
        this.bonfire = compound.method_10577("bonfire");
        this.type = BonfireType.values()[compound.method_10550("type")];
        this.lit = compound.method_10577("lit");
        this.id = compound.method_25926("bonfire_id");
        if (compound.method_10545("unlit")) {
            class_2487 unlit = compound.method_10562("unlit");
            this.setNameInternal(unlit.method_10558("name"));
            this.unlitPrivate = unlit.method_10577("private");
        }
        if (this.lit && compound.method_10545("instance")) {
            this.bonfireInstance = new Bonfire(compound.method_10562("instance"));
        }
    }

    protected void method_11007(class_2487 compound) {
        compound.method_10556("bonfire", this.bonfire);
        compound.method_10569("type", this.type.ordinal());
        compound.method_10556("lit", this.lit);
        compound.method_25927("bonfire_id", this.id);
        if (this.unlitName != null && !this.unlitName.isEmpty()) {
            class_2487 unlit = new class_2487();
            unlit.method_10582("name", this.unlitName);
            unlit.method_10556("private", this.unlitPrivate);
            compound.method_10566("unlit", (class_2520)unlit);
        }
        if (this.lit && this.bonfireInstance != null) {
            compound.method_10566("instance", (class_2520)this.bonfireInstance.serializeNBT());
        }
        super.method_11007(compound);
    }

    public Bonfire createBonfire(String name, UUID id, UUID owner, boolean isPublic) {
        Bonfire bonfire = new Bonfire(name, id, owner, this.field_11867, (class_5321<class_1937>)this.field_11863.method_27983(), isPublic, Instant.now());
        BonfireHandler.getServerHandler(this.field_11863.method_8503()).addBonfire(bonfire);
        this.bonfireInstance = bonfire;
        return bonfire;
    }

    public void destroyBonfire(UUID id) {
        BonfireHandler.getServerHandler(this.field_11863.method_8503()).removeBonfire(id);
        this.bonfireInstance = null;
    }

    public boolean isBonfire() {
        return this.bonfire;
    }

    public BonfireType getBonfireType() {
        return this.type;
    }

    public void setBonfireType(BonfireType type) {
        this.type = type;
        this.method_5431();
    }

    public void setBonfire(boolean bonfire) {
        this.bonfire = bonfire;
        this.method_5431();
    }

    public boolean isLit() {
        return this.lit;
    }

    public void setLit(boolean lit) {
        this.lit = lit;
        this.method_5431();
    }

    public UUID getID() {
        return this.id;
    }

    public void setID(UUID id) {
        this.id = id;
        this.method_5431();
    }

    private void setNameInternal(String name) {
        this.unlitName = name.substring(0, Math.min(name.length(), 14));
    }

    public void setUnlitName(String name) {
        this.setNameInternal(name);
        this.method_5431();
    }

    public String getUnlitName() {
        return this.unlitName;
    }

    public void setUnlitPrivate(boolean unlitPrivate) {
        this.unlitPrivate = unlitPrivate;
        this.method_5431();
    }

    public boolean isUnlitPrivate() {
        return this.unlitPrivate;
    }

    public boolean hasUnlitName() {
        return this.unlitName != null && !this.unlitName.isEmpty();
    }

    @Nullable
    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.method_38244();
    }

    @Environment(value=EnvType.CLIENT)
    public class_2561 getDisplayName() {
        Bonfire bonfire;
        if (!class_310.method_1551().field_1724.method_5715() && this.getID() != null && Bonfires.CONFIG.client.renderTextAboveBonfire() && (bonfire = this.bonfireInstance) != null) {
            if (bonfire.isPublic()) {
                return class_2561.method_43471((String)bonfire.getName());
            }
            return class_2561.method_43469((String)"tileentity.bonfires.bonfire.label", (Object[])new Object[]{bonfire.getName()});
        }
        return class_2561.method_43473();
    }

    public static enum BonfireType {
        BONFIRE,
        PRIMAL,
        NONE;

    }
}

