/*
 * Decompiled with CFR 0.152.
 */
package com.yori3o.boss_checklist.client.data;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import com.yori3o.boss_checklist.BossChecklistClient;
import com.yori3o.boss_checklist.client.data.BossData;
import com.yori3o.boss_checklist.client.data.ClientBossStorage;
import com.yori3o.boss_checklist.client.data.ClientDataSaver;
import com.yori3o.boss_checklist.utils.LoggerUtil;
import com.yori3o.boss_checklist.utils.TextUtil;
import dev.architectury.platform.Platform;
import java.io.BufferedReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;

public class BossRegistry {
    private static final Gson GSON = new Gson();
    private static List<BossData> bossDataList;
    private static final Map<String, BossData> BOSSES;
    public static List<class_2561> bossNames;
    public static boolean bossNamesListLoaded;

    public static void load() {
        bossNamesListLoaded = false;
        class_310 mc = class_310.method_1551();
        if (mc == null || mc.method_1478() == null) {
            LoggerUtil.LOGGER.warn("ResourceManager not ready yet!");
            return;
        }
        BOSSES.clear();
        try {
            class_3300 resourceManager = mc.method_1478();
            class_2960 loc = new class_2960("boss_checklist", "bosses.json");
            ArrayList allBosses = new ArrayList();
            for (class_3298 res : resourceManager.method_14489(loc)) {
                try {
                    BufferedReader reader = res.method_43039();
                    try {
                        Type listType = new TypeToken<List<BossData>>(){}.getType();
                        List partial = (List)GSON.fromJson((Reader)reader, listType);
                        if (partial != null) {
                            allBosses.addAll(partial);
                        }
                        LoggerUtil.LOGGER.info("Loading bosses.json from " + res.method_14480());
                    }
                    finally {
                        if (reader == null) continue;
                        ((Reader)reader).close();
                    }
                }
                catch (Exception e) {
                    LoggerUtil.LOGGER.warn("Failed to read bosses.json from " + res.method_14480(), (Throwable)e);
                }
            }
            LinkedHashMap<String, BossData> merged = new LinkedHashMap<String, BossData>();
            for (BossData data : allBosses) {
                if (data.getId() == null) {
                    LoggerUtil.LOGGER.error("Boss ID is missing!");
                    continue;
                }
                Boolean replace = Boolean.TRUE.equals(data.replace);
                BossData existing = (BossData)merged.get(data.getId());
                if (existing == null || replace.booleanValue()) {
                    merged.put(data.getId(), data);
                    continue;
                }
                if (existing.replace.booleanValue()) continue;
                BossRegistry.mergeFields(existing, data);
            }
            bossDataList = new ArrayList(merged.values());
            bossDataList.forEach(BossData::applyDefaults);
            bossDataList.sort(Comparator.comparingDouble(BossData::getPosition));
            for (BossData data : bossDataList) {
                if (!Platform.isModLoaded((String)data.getModId())) continue;
                String bossId = data.getId();
                if (ClientBossStorage.attempts.containsKey(bossId)) {
                    data.SetAttempt(ClientBossStorage.attempts.get(bossId));
                }
                if (ClientBossStorage.killers.containsKey(bossId)) {
                    data.killerName = ClientBossStorage.killers.get(bossId);
                }
                BOSSES.put(bossId, data);
            }
            LoggerUtil.LOGGER.info("Loaded bosses: " + String.valueOf(BOSSES.keySet()));
        }
        catch (Exception e) {
            LoggerUtil.LOGGER.error("An unexpected error occurred while loading bosses!", (Throwable)e);
        }
    }

    public static BossData get(String id) {
        return BOSSES.get(id);
    }

    public static Collection<BossData> all() {
        return BOSSES.values();
    }

    public static Set<String> allIds() {
        return BOSSES.keySet();
    }

    public static void DeleteAttemptsData() {
        BOSSES.forEach(BossData::DeleteAttempt);
    }

    private static void mergeFields(BossData base, BossData addition) {
        if (base == null || addition == null) {
            return;
        }
        try {
            for (Field field : BossData.class.getDeclaredFields()) {
                field.setAccessible(true);
                if (field.getName().equals("replace")) continue;
                Object addValue = field.get(addition);
                Object baseValue = field.get(base);
                if (addValue == null) continue;
                if (List.class.isAssignableFrom(field.getType())) {
                    List addList = (List)addValue;
                    if (addList.isEmpty()) continue;
                    if (baseValue == null) {
                        field.set(base, new ArrayList(addList));
                        continue;
                    }
                    ((List)baseValue).addAll(addList);
                    continue;
                }
                field.set(base, addValue);
            }
        }
        catch (Exception e) {
            LoggerUtil.LOGGER.error("Error when merging BossData fields", (Throwable)e);
        }
    }

    public static void updateBossNamesList() {
        bossNamesListLoaded = true;
        bossNames.clear();
        for (BossData b : BOSSES.values().stream().toList()) {
            if (BossChecklistClient.isProgressionMode_dynamic && !ClientDataSaver.defeatedBossesIds_InWorld.contains(b.getId())) {
                bossNames.add((class_2561)class_2561.method_43470((String)"???"));
                continue;
            }
            String translated = class_2561.method_43471((String)("boss_checklist.boss." + b.getId().replace(":", "_"))).getString();
            String truncated = TextUtil.truncateText(translated, 95).getString();
            bossNames.add((class_2561)class_2561.method_43470((String)truncated));
        }
    }

    static {
        BOSSES = new LinkedHashMap<String, BossData>();
        bossNames = new ArrayList<class_2561>();
        bossNamesListLoaded = false;
    }
}

