/*
 * Decompiled with CFR 0.152.
 */
package com.yori3o.boss_checklist.client.data;

import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;

public class ClientBossAttempt {
    public final String id;
    public final String startTime;
    public final String endTime;
    public LinkedHashMap<String, String> damageMap_top3 = new LinkedHashMap();
    public final String duration;
    public final String date;
    public final String time;

    public ClientBossAttempt(String id, String startTime, String endTime) {
        this.id = id;
        this.startTime = startTime;
        this.endTime = endTime;
        this.duration = this.getDuration();
        this.date = this.getDate();
        this.time = this.getTime();
    }

    public void addPlayerDamage(String playerName, String damage) {
        this.damageMap_top3.put(playerName, damage);
    }

    public String getDate() {
        DateTimeFormatter inputFormatter = DateTimeFormatter.ofPattern("dd.MM.yyyy-HH.mm.ss");
        LocalDateTime localDateTime = LocalDateTime.parse(this.startTime, inputFormatter);
        ZoneId fromZone = ZoneId.of("UTC");
        ZonedDateTime zonedDateTimeUTC = localDateTime.atZone(fromZone);
        ZoneId toZone = ZoneId.systemDefault();
        ZonedDateTime zonedDateTimeSystem = zonedDateTimeUTC.withZoneSameInstant(toZone);
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("dd.MM.yyyy");
        String adjustedDate = zonedDateTimeSystem.format(dateFormatter);
        return adjustedDate;
    }

    public String getTime() {
        DateTimeFormatter inputFormatter = DateTimeFormatter.ofPattern("dd.MM.yyyy-HH.mm.ss");
        LocalDateTime localDateTime = LocalDateTime.parse(this.startTime, inputFormatter);
        ZoneId fromZone = ZoneId.of("UTC");
        ZonedDateTime zonedDateTimeUTC = localDateTime.atZone(fromZone);
        ZoneId toZone = ZoneId.systemDefault();
        ZonedDateTime zonedDateTimeSystem = zonedDateTimeUTC.withZoneSameInstant(toZone);
        DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern("HH:mm:ss");
        String adjustedTime = zonedDateTimeSystem.format(timeFormatter);
        return adjustedTime;
    }

    public String getDuration() {
        LocalDateTime end;
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd.MM.yyyy-HH.mm.ss");
        LocalDateTime start = LocalDateTime.parse(this.startTime, formatter);
        Duration duration = Duration.between(start, end = LocalDateTime.parse(this.endTime, formatter));
        int totalSeconds = (int)Math.abs(duration.toSeconds());
        if (totalSeconds < 1) {
            return "<1s";
        }
        if (totalSeconds > 86399) {
            return ">1 day";
        }
        int hours = totalSeconds / 3600;
        int minutes = totalSeconds % 3600 / 60;
        int seconds = totalSeconds % 60;
        if (hours > 0) {
            return String.format("%d:%02d:%02d", hours, minutes, seconds);
        }
        if (minutes > 0) {
            return String.format("%d:%02d", minutes, seconds);
        }
        return seconds + "s";
    }
}

