/*
 * Decompiled with CFR 0.152.
 */
package com.yori3o.boss_checklist.client.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.yori3o.boss_checklist.BossChecklistClient;
import com.yori3o.boss_checklist.client.ClientStatistics;
import com.yori3o.boss_checklist.client.data.BossData;
import com.yori3o.boss_checklist.client.data.BossRegistry;
import com.yori3o.boss_checklist.utils.LoggerUtil;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_310;
import net.minecraft.class_5218;
import net.minecraft.class_634;
import net.minecraft.class_642;

public class ClientDataSaver {
    private static final Object FILE_IO_LOCK = new Object();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final String DATA_FOLDER_NAME = "boss\u0421hecklist_data";
    public static final String JSON_FILE_NAME = "defeated_bosses.json";
    public static List<String> defeatedBossesIds_client = new ArrayList<String>();
    public static List<String> defeatedBosses_InWorld = new ArrayList<String>();
    public static List<String> defeatedBossesIds_InWorld = new ArrayList<String>();
    public static List<String> alreadyAnimated = new ArrayList<String>();
    private static String worldKey;

    public static void WriteToClientData(String bossId, Boolean bool) {
        File dataFolder;
        if (worldKey == null) {
            ClientDataSaver.UpdateCurrentWorldKey();
        }
        if (!(dataFolder = new File(class_310.method_1551().field_1697, DATA_FOLDER_NAME + File.separator + worldKey)).exists() && !dataFolder.mkdirs()) {
            LoggerUtil.LOGGER.error("Failed to create data folder for world key: " + worldKey);
            return;
        }
        File jsonFile = new File(dataFolder, JSON_FILE_NAME);
        List<String> defeatedBosses = new ArrayList<String>();
        if (jsonFile.exists()) {
            try (FileReader reader = new FileReader(jsonFile);){
                Type listType = new TypeToken<List<String>>(){}.getType();
                defeatedBosses = (List)GSON.fromJson((Reader)reader, listType);
                if (defeatedBosses == null) {
                    defeatedBosses = new ArrayList();
                }
            }
            catch (IOException e) {
                LoggerUtil.LOGGER.error("Failed to read JSON file from " + jsonFile.getAbsolutePath(), (Throwable)e);
            }
        }
        if (bool.booleanValue()) {
            if (!defeatedBosses.contains(bossId)) {
                defeatedBosses.add(bossId);
                try {
                    writer = new FileWriter(jsonFile);
                    try {
                        defeatedBossesIds_client.add(bossId);
                        GSON.toJson(defeatedBosses, (Appendable)writer);
                    }
                    finally {
                        writer.close();
                    }
                }
                catch (IOException e) {
                    LoggerUtil.LOGGER.error("Failed to write to JSON file " + jsonFile.getAbsolutePath(), (Throwable)e);
                }
            }
        } else if (defeatedBosses.contains(bossId)) {
            defeatedBosses.remove(bossId);
            try {
                writer = new FileWriter(jsonFile);
                try {
                    GSON.toJson(defeatedBosses, (Appendable)writer);
                    defeatedBossesIds_client.remove(bossId);
                }
                finally {
                    writer.close();
                }
            }
            catch (IOException e) {
                LoggerUtil.LOGGER.error("Failed to write to JSON file " + jsonFile.getAbsolutePath(), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void BossDefeatedInWorld(String lineOfInformation) {
        Object object = FILE_IO_LOCK;
        synchronized (object) {
            String[] line1 = lineOfInformation.split("%")[0].split("#", -1);
            String[] line2 = lineOfInformation.split("%")[1].split("#", -1);
            String[] line3 = lineOfInformation.split("%")[2].split("#", -1);
            String bossId = line1[0];
            Boolean yes = line1[2].equals("true");
            Boolean fresh = line1[3].equals("true");
            BossData boss = BossRegistry.get(bossId);
            if (line3[0].equals("")) {
                ClientStatistics.DeleteStatsData();
            } else {
                ClientStatistics.SetTop3(line3);
            }
            if (boss != null) {
                ClientDataSaver.WriteToClientData(bossId, yes);
                boss.SetFresh(fresh);
                if (!line1[1].equals("")) {
                    boss.SetKillerName(line1[1]);
                } else {
                    boss.SetKillerName("");
                }
                if (!line2[0].equals("")) {
                    boss.SetNewAttempt(line2[0], line2[1], line2[2], line2[3], line2[4], line2[5], line2[6], line2[7]);
                }
                if (!defeatedBossesIds_InWorld.contains(bossId) && yes.booleanValue()) {
                    defeatedBosses_InWorld.add(lineOfInformation);
                    defeatedBossesIds_InWorld.add(bossId);
                    if (BossChecklistClient.isProgressionMode_dynamic) {
                        BossRegistry.bossNamesListLoaded = false;
                    }
                } else if (!yes.booleanValue()) {
                    defeatedBosses_InWorld.remove(lineOfInformation);
                    defeatedBossesIds_InWorld.remove(bossId);
                    boss.DeleteAttempt();
                    if (BossChecklistClient.isProgressionMode_dynamic) {
                        BossRegistry.bossNamesListLoaded = false;
                    }
                }
            } else {
                LoggerUtil.LOGGER.info("The boss's ID sent from the server is not registered on the client: " + bossId);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Boolean isBossDefeated(String bossId) {
        File jsonFile = new File(class_310.method_1551().field_1697, DATA_FOLDER_NAME + File.separator + worldKey + File.separator + JSON_FILE_NAME);
        if (!jsonFile.exists()) {
            return false;
        }
        try (FileReader reader = new FileReader(jsonFile);){
            Type listType = new TypeToken<List<String>>(){}.getType();
            List defeatedBosses = (List)GSON.fromJson((Reader)reader, listType);
            if (defeatedBosses == null) return false;
            Boolean bl = defeatedBosses.contains(bossId);
            return bl;
        }
        catch (IOException e) {
            LoggerUtil.LOGGER.error("Failed to read JSON file from " + jsonFile.getAbsolutePath(), (Throwable)e);
        }
        return false;
    }

    public static Boolean isBossDefeatedCache(String bossId) {
        return defeatedBossesIds_client.contains(bossId);
    }

    public static void UpdateCurrentWorldKey() {
        class_642 serverData;
        class_310 minecraft = class_310.method_1551();
        if (minecraft.method_1542()) {
            worldKey = "singleplayer_" + minecraft.method_1576().method_27050(class_5218.field_24188).normalize().getFileName().toString();
            return;
        }
        class_634 clientPacketListener = minecraft.method_1562();
        if (clientPacketListener != null && (serverData = clientPacketListener.method_45734()) != null) {
            worldKey = "multiplayer_" + serverData.field_3761.replace(":", "_");
            return;
        }
        worldKey = "INVALID_WORLD_KEY";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void UpdateCurrentDefeatedBosses() {
        Object object = FILE_IO_LOCK;
        synchronized (object) {
            for (BossData data : BossRegistry.all()) {
                String bossId = data.getId();
                if (defeatedBossesIds_client.contains(bossId)) continue;
                if (ClientDataSaver.isBossDefeated(bossId).booleanValue()) {
                    data.SetDefeated(true);
                    alreadyAnimated.add(bossId);
                    defeatedBossesIds_client.add(bossId);
                    continue;
                }
                data.SetDefeated(false);
            }
        }
    }

    public static int defeatedBossesCount() {
        return defeatedBossesIds_client.size();
    }
}

