/*
 * Decompiled with CFR 0.152.
 */
package com.yori3o.boss_checklist.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.yori3o.boss_checklist.BossChecklistClient;
import com.yori3o.boss_checklist.client.ClientStatistics;
import com.yori3o.boss_checklist.client.data.BossData;
import com.yori3o.boss_checklist.client.data.BossRegistry;
import com.yori3o.boss_checklist.client.data.ClientDataSaver;
import com.yori3o.boss_checklist.client.gui.BossInfoScreen;
import com.yori3o.boss_checklist.client.gui.ConfigScreen;
import com.yori3o.boss_checklist.client.gui.CustomButton;
import com.yori3o.boss_checklist.client.gui.CustomCheckbox;
import com.yori3o.boss_checklist.client.gui.CustomPageButton;
import com.yori3o.boss_checklist.utils.LoggerUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_364;
import net.minecraft.class_433;
import net.minecraft.class_437;
import net.minecraft.class_6880;

public class BossChecklistScreen
extends class_437 {
    private static final class_2960 bar_background = new class_2960("boss_checklist", "textures/gui/white_background.png");
    private static final class_2960 bar_progress = new class_2960("boss_checklist", "textures/gui/white_progress.png");
    private static final class_2960 BOOKMARK_SETTINGS = new class_2960("boss_checklist", "textures/gui/bookmarks/bookmark_settings.png");
    private final int BOOKMARK_SETTINGS_x = 387;
    private final int BOOKMARK_SETTINGS_y = 65;
    private static final class_2960 background_texture = new class_2960("boss_checklist", "textures/gui/boss_book.png");
    private static final int ELEMENTS_PER_PAGE = 7;
    private int currentSpread = 0;
    private int totalSpreads;
    public static final int maxTextWidth = 95;
    public static final int maxLabelWidth = 100;
    private static final class_2960 STATS_INFO_BACK = new class_2960("boss_checklist", "textures/gui/stats_info_back.png");
    private static final class_2960 SMALL_BUTTON_TEXTURE_hovered = new class_2960("boss_checklist", "textures/gui/buttons/small_button_hovered.png");
    private static final class_2960 SMALL_BUTTON_TEXTURE_pressed = new class_2960("boss_checklist", "textures/gui/buttons/small_button_pressed.png");
    private static final class_2960 SMALL_BUTTON_TEXTURE = new class_2960("boss_checklist", "textures/gui/buttons/small_button.png");
    private static final class_2960 ARROW_UP = new class_2960("boss_checklist", "textures/gui/icons/arrow_up.png");
    private static final class_2960 ARROW_DOWN = new class_2960("boss_checklist", "textures/gui/icons/arrow_down.png");
    private static final class_2960 TOP_1 = new class_2960("boss_checklist", "textures/gui/icons/top1_icon.png");
    private static final class_2960 TOP_2 = new class_2960("boss_checklist", "textures/gui/icons/top2_icon.png");
    private static final class_2960 TOP_3 = new class_2960("boss_checklist", "textures/gui/icons/top3_icon.png");
    private static final int StatsInfoX = 86;
    private static final int StatsInfoY = 51;
    private static final int StatsInfoWidth = 17;
    private static final int StatsInfoHeight = 68;
    private static final int IconsSize = 10;
    private boolean showStats = false;
    private boolean showStatsInfo = false;
    private boolean showTop2 = false;
    private boolean showTop3 = false;
    private List<CustomCheckbox> currentCheckboxes = new ArrayList<CustomCheckbox>();
    private CustomPageButton nextButton;
    private CustomPageButton prevButton;
    private int leftPage;
    private int rightPage;
    private boolean noBossesLoaded = false;
    private boolean ChecklistAreLoaded = false;
    private final boolean exitFromSettings;
    private final boolean fromPauseMenu;
    private List<class_2561> bossNames = new ArrayList<class_2561>();
    private List<String> bossIds = new ArrayList<String>();
    private int defeatedCount;
    private int totalCount;
    private float percent;

    public BossChecklistScreen(Boolean exitFromSettings, Boolean fromPauseMenu) {
        super((class_2561)class_2561.method_43470((String)"Checklist"));
        this.exitFromSettings = exitFromSettings;
        this.fromPauseMenu = fromPauseMenu;
    }

    public void method_25426() {
        super.method_25426();
        if (this.exitFromSettings) {
            BossRegistry.updateBossNamesList();
            this.bossNames = BossRegistry.bossNames;
        }
        if (!BossRegistry.bossNamesListLoaded) {
            BossRegistry.updateBossNamesList();
        }
        if (!this.ChecklistAreLoaded) {
            this.bossIds.addAll(BossRegistry.all().stream().map(BossData::getId).toList());
            this.bossNames = BossRegistry.bossNames;
            this.ChecklistAreLoaded = true;
        }
        if (ClientStatistics.top1 != null) {
            this.showStats = true;
            if (!ClientStatistics.top2.equals("")) {
                this.showTop2 = true;
            }
            if (!ClientStatistics.top3.equals("")) {
                this.showTop3 = true;
            }
        }
        this.updateCounts();
        this.createPageButtons();
        this.updatePage();
    }

    private void updateCounts() {
        this.defeatedCount = ClientDataSaver.defeatedBossesCount();
        this.totalCount = this.bossIds.size();
        this.percent = this.totalCount > 0 ? (float)this.defeatedCount / (float)this.totalCount : 0.0f;
    }

    private void createPageButtons() {
        int bookX = (this.field_22789 - 512) / 2;
        int bookY = (this.field_22790 - 256) / 2;
        double totalPages = Math.ceil((double)this.bossNames.size() / 7.0);
        this.totalSpreads = (int)Math.ceil(totalPages / 2.0);
        this.prevButton = new CustomPageButton(bookX + 138, bookY + 190, true, () -> {
            if (this.currentSpread > 0) {
                --this.currentSpread;
                this.updatePage();
            }
        });
        this.nextButton = new CustomPageButton(bookX + 350, bookY + 190, false, () -> {
            if (this.currentSpread < this.totalSpreads - 1) {
                ++this.currentSpread;
                this.updatePage();
            }
        });
        if (this.showStats) {
            CustomButton openStatsButton = new CustomButton(bookX + 86, bookY + 51, 17, 17, 0, 0, (class_2561)class_2561.method_43470((String)""), SMALL_BUTTON_TEXTURE, SMALL_BUTTON_TEXTURE_hovered, SMALL_BUTTON_TEXTURE_pressed, null, () -> {
                this.showStatsInfo = !this.showStatsInfo;
            });
            this.method_37063((class_364)openStatsButton);
        }
        this.method_37063((class_364)this.prevButton);
        this.method_37063((class_364)this.nextButton);
    }

    private void updatePage() {
        if (this.bossNames.isEmpty()) {
            LoggerUtil.LOGGER.warn("No bosses loaded at checklist! - Resources are empty or invalid.");
            this.prevButton.field_22764 = false;
            this.nextButton.field_22764 = false;
            this.noBossesLoaded = true;
            return;
        }
        for (CustomCheckbox cb : this.currentCheckboxes) {
            this.method_37066((class_364)cb);
        }
        this.currentCheckboxes.clear();
        double totalPages = Math.ceil((double)this.bossNames.size() / 7.0);
        int totalSpreads = (int)Math.ceil(totalPages / 2.0);
        int fromIndex = this.currentSpread * 14;
        int toIndex = Math.min(fromIndex + 14, this.bossNames.size());
        int bookX = (this.field_22789 - 512) / 2;
        int bookY = (this.field_22790 - 256) / 2;
        int leftX = bookX + 134;
        int rightX = bookX + 266;
        int startY = bookY + 56;
        for (int i = fromIndex; i < toIndex; ++i) {
            String boss = this.bossNames.get(i).getString();
            String bossId = this.bossIds.get(i);
            int localIndex = i - fromIndex;
            int x = localIndex < 7 ? leftX : rightX;
            int y = startY + localIndex % 7 * 18;
            BossData data = BossRegistry.get(bossId);
            boolean isThisBossDefeated = ClientDataSaver.isBossDefeatedCache(bossId);
            boolean isFresh = false;
            if (isThisBossDefeated && data.isFresh().booleanValue()) {
                isFresh = true;
            }
            CustomCheckbox cb = new CustomCheckbox(x, y, 100, (class_2561)class_2561.method_43470((String)boss), isThisBossDefeated, true, isFresh, checked -> CompletableFuture.runAsync(() -> {
                data.SetDefeated(true);
                data.SetFresh(false);
                ClientDataSaver.WriteToClientData(bossId, checked);
                this.updateCounts();
                if (BossChecklistClient.isAnimationEnabled_dynamic) {
                    if (checked.booleanValue()) {
                        ClientDataSaver.alreadyAnimated.add(bossId);
                    } else {
                        ClientDataSaver.alreadyAnimated.remove(bossId);
                    }
                }
            }), () -> {
                class_310.method_1551().method_1507((class_437)new BossInfoScreen(new BossChecklistScreen(false, false), bossId));
                data.SetFresh(false);
            });
            if (BossChecklistClient.isAnimationEnabled_dynamic && isThisBossDefeated && !ClientDataSaver.alreadyAnimated.contains(bossId)) {
                ClientDataSaver.alreadyAnimated.add(bossId);
                cb.isAnimating = true;
                cb.animationPlayed = false;
                cb.animationStartTime = System.currentTimeMillis();
            }
            this.method_37063((class_364)cb);
            this.currentCheckboxes.add(cb);
        }
        this.prevButton.field_22764 = this.currentSpread > 0;
        this.nextButton.field_22764 = this.currentSpread < totalSpreads - 1;
        this.leftPage = this.currentSpread * 2 + 1;
        this.rightPage = this.currentSpread * 2 + 2;
    }

    public void method_25394(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.method_25420(guiGraphics);
        int bookX = (this.field_22789 - 512) / 2;
        int bookY = (this.field_22790 - 256) / 2;
        guiGraphics.method_25290(background_texture, bookX, bookY, 0.0f, 0.0f, 512, 256, 512, 256);
        guiGraphics.method_25290(bar_background, bookX + 165, bookY + 29, 0.0f, 0.0f, 182, 5, 182, 5);
        guiGraphics.method_25290(bar_progress, bookX + 165, bookY + 29, 0.0f, 0.0f, (int)(this.percent * 182.0f), 5, 182, 5);
        if (BossChecklistClient.ShowConfigScreen) {
            guiGraphics.method_25290(BOOKMARK_SETTINGS, bookX + 387, bookY + 65, 0.0f, 0.0f, 12, 22, 12, 22);
        }
        if (this.showStats) {
            RenderSystem.enableBlend();
            if (this.showStatsInfo) {
                guiGraphics.method_25290(STATS_INFO_BACK, bookX + 86, bookY + 51, 0.0f, 0.0f, 17, 68, 17, 68);
                guiGraphics.method_25290(TOP_1, bookX + 86 + 4, bookY + 51 + 24, 0.0f, 0.0f, 10, 10, 10, 10);
                if (this.showTop2) {
                    guiGraphics.method_25290(TOP_2, bookX + 86 + 4, bookY + 51 + 38, 0.0f, 0.0f, 10, 10, 10, 10);
                }
                if (this.showTop3) {
                    guiGraphics.method_25290(TOP_3, bookX + 86 + 4, bookY + 51 + 52, 0.0f, 0.0f, 10, 10, 10, 10);
                }
            }
        }
        guiGraphics.method_51433(this.field_22793, this.defeatedCount + " / " + this.totalCount, (this.field_22789 - class_310.method_1551().field_1772.method_1727(this.defeatedCount + " / " + this.totalCount)) / 2, bookY + 20, 0xFFFFFF, true);
        if (this.noBossesLoaded) {
            guiGraphics.method_51433(this.field_22793, "No bosses loaded!", bookX + 140, bookY + 53, 0, false);
        } else {
            guiGraphics.method_51433(this.field_22793, String.valueOf(this.leftPage), bookX + 187, bookY + 195, 4539455, false);
            guiGraphics.method_51433(this.field_22793, String.valueOf(this.rightPage), bookX + 320, bookY + 195, 4539455, false);
        }
        if (BossChecklistClient.ShowConfigScreen && mouseX >= bookX + 387 && mouseX < bookX + 387 + 12 && mouseY >= bookY + 65 && mouseY < bookY + 65 + 22) {
            guiGraphics.method_51438(class_310.method_1551().field_1772, (class_2561)class_2561.method_43470((String)class_2561.method_43471((String)"gui.boss_checklist.settings").getString()), mouseX, mouseY);
        }
        if (this.showStats && this.showStatsInfo) {
            if (mouseX >= bookX + 86 + 3 && mouseX < bookX + 86 + 17 - 3 && mouseY >= bookY + 51 + 23 && mouseY < bookY + 51 + 34) {
                guiGraphics.method_51438(class_310.method_1551().field_1772, (class_2561)class_2561.method_43470((String)("1. " + ClientStatistics.top1 + " - \u00a7c" + ClientStatistics.damage1)), mouseX, mouseY);
            } else if (this.showTop2) {
                if (mouseX >= bookX + 86 + 3 && mouseX < bookX + 86 + 17 - 3 && mouseY >= bookY + 51 + 37 && mouseY < bookY + 51 + 48) {
                    guiGraphics.method_51438(class_310.method_1551().field_1772, (class_2561)class_2561.method_43470((String)("2. " + ClientStatistics.top2 + " - \u00a7c" + ClientStatistics.damage2)), mouseX, mouseY);
                } else if (this.showTop3 && mouseX >= bookX + 86 + 3 && mouseX < bookX + 86 + 17 - 3 && mouseY >= bookY + 51 + 53 && mouseY < bookY + 51 + 64) {
                    guiGraphics.method_51438(class_310.method_1551().field_1772, (class_2561)class_2561.method_43470((String)("3. " + ClientStatistics.top3 + " - \u00a7c" + ClientStatistics.damage3)), mouseX, mouseY);
                }
            }
        }
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        if (this.showStats) {
            RenderSystem.enableBlend();
            if (this.showStatsInfo) {
                guiGraphics.method_25290(ARROW_UP, bookX + 86, bookY + 51, 0.0f, 0.0f, 17, 17, 17, 17);
            } else {
                guiGraphics.method_25290(ARROW_DOWN, bookX + 86, bookY + 51, 0.0f, 0.0f, 17, 17, 17, 17);
            }
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        int bookX = (this.field_22789 - 512) / 2;
        int bookY = (this.field_22790 - 256) / 2;
        if (BossChecklistClient.ShowConfigScreen && mouseX >= (double)(bookX + 387) && mouseX <= (double)(bookX + 387 + 11) && mouseY >= (double)(bookY + 65) && mouseY <= (double)(bookY + 65 + 22)) {
            this.field_22787.method_1507((class_437)new ConfigScreen(new BossChecklistScreen(true, false)));
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (BossChecklistClient.OPEN_CHECKLIST.method_1417(keyCode, scanCode)) {
            this.field_22787.method_1507(null);
            return true;
        }
        if (keyCode == 263) {
            if (this.currentSpread > 0) {
                --this.currentSpread;
                this.updatePage();
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_17481, (float)1.0f));
            }
            return true;
        }
        if (keyCode == 262) {
            if (this.currentSpread < this.totalSpreads - 1) {
                ++this.currentSpread;
                this.updatePage();
                class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_17481, (float)1.0f));
            }
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public void method_25419() {
        if (this.fromPauseMenu) {
            this.field_22787.method_1507((class_437)new class_433(true));
        } else {
            this.field_22787.method_1507(null);
        }
    }
}

