/*
 * Decompiled with CFR 0.152.
 */
package com.yori3o.boss_checklist.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.yori3o.boss_checklist.BossChecklist;
import com.yori3o.boss_checklist.client.data.BossRegistry;
import com.yori3o.boss_checklist.network.BossDefeatServerSend;
import com.yori3o.boss_checklist.server.BossDefeatedDataSaver;
import com.yori3o.boss_checklist.server.ServerBossIdsLoader;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2232;
import net.minecraft.class_2561;

public class SetDefeated {
    public static void register() {
        CommandRegistrationEvent.EVENT.register((dispatcher, registryAccess, environment) -> SetDefeated.registerCommands((CommandDispatcher<class_2168>)dispatcher));
    }

    private static void registerCommands(CommandDispatcher<class_2168> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"boss_checklist").requires(src -> src.method_9259(2))).then(class_2170.method_9247((String)"set_defeated").then(class_2170.method_9244((String)"boss_id", (ArgumentType)class_2232.method_9441()).suggests(SetDefeated::suggestBossIds).then(class_2170.method_9244((String)"defeated", (ArgumentType)BoolArgumentType.bool()).executes(SetDefeated::executeSetDefeated)))));
    }

    private static CompletableFuture<Suggestions> suggestBossIds(CommandContext<class_2168> ctx, SuggestionsBuilder builder) {
        for (String id : BossRegistry.allIds()) {
            builder.suggest(id);
        }
        return builder.buildFuture();
    }

    private static int executeSetDefeated(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        String bossId = class_2232.method_9443(ctx, (String)"boss_id").toString();
        boolean defeated = BoolArgumentType.getBool(ctx, (String)"defeated");
        class_2168 source = (class_2168)ctx.getSource();
        if (!ServerBossIdsLoader.server_bosses_ids_list_only_loaded_mods.contains(bossId)) {
            throw new SimpleCommandExceptionType((Message)class_2561.method_43470((String)(class_2561.method_43471((String)"command.boss_checklist.invalid_boss_id").getString() + bossId))).create();
        }
        BossDefeatServerSend.onBossKilled(source.method_9225(), bossId, "", defeated, "", "", "#####", "#####");
        String value = bossId + "##" + (defeated ? "true" : "false");
        BossDefeatedDataSaver data = BossDefeatedDataSaver.get(source.method_9225().method_8503().method_30002());
        if (defeated) {
            data.addBoss(value);
            BossChecklist.defeated_bosses_on_server.add(value);
        } else {
            data.removeBoss(value);
            BossChecklist.removeBossFromDefeated_bosses_on_server(value);
        }
        source.method_9226(() -> class_2561.method_43470((String)class_2561.method_43469((String)"command.boss_checklist.boss_marked_successfully", (Object[])new Object[]{bossId, defeated ? "defeated" : "not defeated"}).getString()), true);
        return 1;
    }
}

