/*
 * Decompiled with CFR 0.152.
 */
package com.yori3o.boss_checklist.server;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ServerBossAttempt {
    public final String id;
    public final String uuid;
    public String startTime = "";
    public String endTime = "";
    public Map<String, Float> damageMap = new HashMap<String, Float>();

    public ServerBossAttempt(String id, String uuid) {
        this.id = id;
        this.uuid = uuid;
    }

    public void saveFormattedTime(Instant time, boolean isStart) {
        ZonedDateTime utc = time.atZone(ZoneOffset.UTC);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd.MM.yyyy-HH.mm.ss");
        String formatted = utc.format(formatter);
        if (isStart) {
            this.startTime = formatted;
        } else {
            this.endTime = formatted;
        }
    }

    public void addPlayerDamage(String playerName, float damage) {
        this.damageMap.merge(playerName, Float.valueOf(damage), Float::sum);
    }

    public String getTop3PlayersNamesAndDamages_SplittedByHashtag() {
        Object result;
        ArrayList<Map.Entry<String, Float>> entryList = new ArrayList<Map.Entry<String, Float>>(this.damageMap.entrySet());
        entryList.sort(Map.Entry.comparingByValue().reversed());
        if (entryList.size() > 0) {
            result = (String)((Map.Entry)entryList.get(0)).getKey() + "#" + (float)Math.round(((Float)((Map.Entry)entryList.get(0)).getValue()).floatValue() * 10.0f) / 10.0f;
            if (entryList.size() > 1) {
                result = (String)result + "#" + (String)((Map.Entry)entryList.get(1)).getKey() + "#" + (float)Math.round(((Float)((Map.Entry)entryList.get(1)).getValue()).floatValue() * 10.0f) / 10.0f;
                result = entryList.size() > 2 ? (String)result + "#" + (String)((Map.Entry)entryList.get(2)).getKey() + "#" + (float)Math.round(((Float)((Map.Entry)entryList.get(2)).getValue()).floatValue() * 10.0f) / 10.0f : (String)result + "##";
            } else {
                result = (String)result + "####";
            }
        } else {
            result = "#####";
        }
        return result;
    }
}

