/*
 * Decompiled with CFR 0.152.
 */
package com.yori3o.boss_checklist.server;

import com.yori3o.boss_checklist.server.ServerBossAttempt;
import com.yori3o.boss_checklist.server.Statistics;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_26;
import net.minecraft.class_3218;
import net.minecraft.class_7225;

public class StatisticsDataSaver
extends class_18 {
    private static final String DATA_NAME = "boss_checklist_statistics";
    private final Map<String, Float> playerDamages = new HashMap<String, Float>();
    private final Map<String, ServerBossAttempt> attempts = new HashMap<String, ServerBossAttempt>();

    public Map<String, Float> getPlayerDamages() {
        return this.playerDamages;
    }

    public Map<String, ServerBossAttempt> getAttempts() {
        return this.attempts;
    }

    public void addPlayerDamage(String a, Float b) {
        this.method_80();
    }

    public void addAttempt(String a, ServerBossAttempt b) {
        this.attempts.put(a, b);
        this.method_80();
    }

    public void deleteAttempt(String a) {
        this.attempts.remove(a);
        this.method_80();
    }

    public StatisticsDataSaver() {
    }

    public StatisticsDataSaver(class_7225.class_7874 provider) {
    }

    public class_2487 method_75(class_2487 tag) {
        class_2499 playerList = new class_2499();
        for (Map.Entry<String, Float> entry : Statistics.playerDamages.entrySet()) {
            class_2487 playerTag = new class_2487();
            playerTag.method_10582("Name", entry.getKey());
            playerTag.method_10548("Damage", entry.getValue().floatValue());
            playerList.add((Object)playerTag);
        }
        tag.method_10566("PlayerDamages", (class_2520)playerList);
        class_2499 attemptsList = new class_2499();
        for (ServerBossAttempt attempt : Statistics.serverBossAttemptsList.values()) {
            class_2487 aTag = new class_2487();
            aTag.method_10582("Id", attempt.id);
            aTag.method_10582("UUID", attempt.uuid);
            aTag.method_10582("StartTime", attempt.startTime);
            aTag.method_10582("EndTime", attempt.endTime);
            class_2499 dmgList = new class_2499();
            for (Map.Entry<String, Float> e : attempt.damageMap.entrySet()) {
                class_2487 dmgTag = new class_2487();
                dmgTag.method_10582("Name", e.getKey());
                dmgTag.method_10548("Damage", e.getValue().floatValue());
                dmgList.add((Object)dmgTag);
            }
            aTag.method_10566("DamageMap", (class_2520)dmgList);
            attemptsList.add((Object)aTag);
        }
        tag.method_10566("BossAttempts", (class_2520)attemptsList);
        return tag;
    }

    public static StatisticsDataSaver load(class_2487 tag) {
        StatisticsDataSaver data = new StatisticsDataSaver();
        class_2499 pList = tag.method_10554("PlayerDamages", 10);
        for (int i = 0; i < pList.size(); ++i) {
            class_2487 pTag = pList.method_10602(i);
            String name = pTag.method_10558("Name");
            float dmg = pTag.method_10583("Damage");
            data.playerDamages.put(name, Float.valueOf(dmg));
        }
        class_2499 attemptsList = tag.method_10554("BossAttempts", 10);
        for (int i = 0; i < attemptsList.size(); ++i) {
            class_2487 aTag = attemptsList.method_10602(i);
            ServerBossAttempt attempt = new ServerBossAttempt(aTag.method_10558("Id"), aTag.method_10558("UUID"));
            attempt.startTime = aTag.method_10558("StartTime");
            attempt.endTime = aTag.method_10558("EndTime");
            class_2499 dmgList = aTag.method_10554("DamageMap", 10);
            for (int j = 0; j < dmgList.size(); ++j) {
                class_2487 dTag = dmgList.method_10602(j);
                attempt.damageMap.put(dTag.method_10558("Name"), Float.valueOf(dTag.method_10583("Damage")));
            }
            data.attempts.put(attempt.id, attempt);
        }
        return data;
    }

    public static StatisticsDataSaver get(class_3218 level) {
        class_26 storage = level.method_8503().method_30002().method_17983();
        return (StatisticsDataSaver)storage.method_17924(StatisticsDataSaver::load, StatisticsDataSaver::new, DATA_NAME);
    }
}

