/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.chesttracker.impl.compat.mods.searchables;

import com.blamejared.searchables.api.SearchableComponent;
import com.blamejared.searchables.api.SearchableType;
import com.blamejared.searchables.api.autcomplete.AutoComplete;
import com.blamejared.searchables.api.autcomplete.AutoCompletingEditBox;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_7923;
import red.jackf.chesttracker.impl.compat.mods.searchables.CustomSearchablesFormatter;
import red.jackf.chesttracker.impl.config.ChestTrackerConfig;
import red.jackf.chesttracker.impl.gui.widget.CustomEditBox;
import red.jackf.chesttracker.impl.gui.widget.WidgetZOffsetWrapper;
import red.jackf.chesttracker.impl.util.ItemStacks;

@Environment(value=EnvType.CLIENT)
public class SearchablesUtil {
    public static final SearchableType<class_1799> ITEM_STACK = SearchablesUtil.buildType();

    private static SearchableType<class_1799> buildType() {
        return new SearchableType.Builder().defaultComponent(SearchableComponent.create((String)"text", ItemStacks::defaultPredicate)).component(SearchableComponent.create((String)"name", SearchablesUtil::stackNameSuggestions, ItemStacks::namePredicate)).component(SearchableComponent.create((String)"tooltip", ItemStacks::tooltipPredicate)).component(SearchableComponent.create((String)"id", stack -> Optional.of(class_7923.field_41178.method_10221((Object)stack.method_7909()).method_12832()))).component(SearchableComponent.create((String)"tag", ItemStacks::tagPredicate)).component(SearchableComponent.create((String)"mod", stack -> Optional.of(class_7923.field_41178.method_10221((Object)stack.method_7909())).map(class_2960::method_12836))).component(SearchableComponent.create((String)"enchantment", ItemStacks::enchantmentPredicate)).component(SearchableComponent.create((String)"potion", ItemStacks::potionOrEffectPredicate)).build();
    }

    private static Optional<String> stackNameSuggestions(class_1799 stack) {
        if (stack.method_7938() || ((ChestTrackerConfig)ChestTrackerConfig.INSTANCE.instance()).gui.autocompleteShowsRegularNames) {
            return Optional.of(stack.method_7964().getString());
        }
        return Optional.empty();
    }

    public static class_342 getEditBox(class_327 font, int x, int y, int width, int height, class_342 previous, Supplier<List<class_1799>> itemSupplier, Consumer<String> callback) {
        AutoCompletingEditBox box = new AutoCompletingEditBox(font, x, y, width, height, previous, CustomEditBox.SEARCH_MESSAGE, ITEM_STACK, itemSupplier);
        CustomSearchablesFormatter formatter = SearchablesUtil.getFormatter();
        box.method_1854((BiFunction)formatter);
        box.addResponder((Consumer)formatter);
        box.addResponder(callback);
        return box;
    }

    public static CustomSearchablesFormatter getFormatter() {
        return new CustomSearchablesFormatter(ITEM_STACK);
    }

    public static boolean ifSearchables(class_342 box, Predicate<class_339> ifSearchablesBox) {
        if (box instanceof AutoCompletingEditBox) {
            AutoCompletingEditBox autoCompletingEditBox = (AutoCompletingEditBox)box;
            return ifSearchablesBox.test((class_339)autoCompletingEditBox.autoComplete());
        }
        return false;
    }

    public static class_339 getWrappedAutocomplete(class_342 search) {
        return new WidgetZOffsetWrapper<AutoComplete>(((AutoCompletingEditBox)search).autoComplete(), 250);
    }
}

