/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.chesttracker.impl.compat.servers.hypixel;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import red.jackf.chesttracker.api.providers.context.ScreenCloseContext;
import red.jackf.chesttracker.impl.util.ItemStacks;
import red.jackf.jackfredlib.client.api.gps.PlayerListSnapshot;
import red.jackf.jackfredlib.client.api.gps.ScoreboardSnapshot;

@Environment(value=EnvType.CLIENT)
interface Skyblock {
    public static boolean isPlayerOn() {
        return ScoreboardSnapshot.take().map(snapshot -> snapshot.title().getString().startsWith("SKYBLOCK")).orElse(false);
    }

    public static boolean isOnPrivateIsland() {
        Optional<String> area = Skyblock.getArea();
        return area.isPresent() && area.get().equals("Private Island");
    }

    public static Optional<String> getArea() {
        return PlayerListSnapshot.take().nameWithPrefixStripped("Area: ");
    }

    public static Optional<Integer> getEnderChestPage(class_2561 title) {
        Matcher match = Pattern.compile("Ender Chest \\((?<current>\\d+)/\\d+\\)").matcher(title.getString());
        if (!match.find()) {
            return Optional.empty();
        }
        return Optional.of(Integer.parseInt(match.group("current")));
    }

    public static Optional<Integer> getBackPackSlot(class_2561 title) {
        Matcher match = Pattern.compile("Backpack\u00a7r \\(Slot #(?<current>\\d+)\\)").matcher(title.getString());
        if (!match.find()) {
            return Optional.empty();
        }
        return Optional.of(Integer.parseInt(match.group("current")));
    }

    public static class_2338 getFakePosForSackType(class_2561 title) {
        return class_2338.method_10092((long)title.getString().hashCode());
    }

    public static Optional<Integer> getPersonalVault(class_2561 title) {
        if (!title.getString().equals("Personal Vault")) {
            return Optional.empty();
        }
        return Optional.of(0);
    }

    public static List<class_1799> getEnderChestItems(ScreenCloseContext context) {
        return context.getItemsMatching(stack -> !Skyblock.isMenuButton(stack));
    }

    public static List<class_1799> getBackPackItems(ScreenCloseContext context) {
        return context.getItemsMatching(stack -> !Skyblock.isMenuButton(stack));
    }

    public static List<class_1799> getSackItems(ScreenCloseContext context) {
        return context.getItemsMatching(stack -> !Skyblock.isMenuButton(stack)).stream().map(sack -> {
            Optional<Integer> count = Skyblock.getSizeOfSack(sack);
            return count.map(arg_0 -> ((class_1799)sack).method_46651(arg_0)).orElse(null);
        }).filter(Objects::nonNull).toList();
    }

    private static Optional<Integer> getSizeOfSack(class_1799 sack) {
        Pattern pattern = Pattern.compile("Stored: (?<amount>\\d+)/.+");
        for (class_2561 line : ItemStacks.getLore(sack)) {
            Matcher match = pattern.matcher(line.getString().replace(",", ""));
            if (!match.find()) continue;
            int amount = Integer.parseInt(match.group("amount"));
            if (amount > 0) {
                return Optional.of(amount);
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    public static List<class_1799> getPersonalVaultItems(ScreenCloseContext context) {
        return context.getItemsMatching(stack -> !Skyblock.isMenuButton(stack));
    }

    private static boolean isMenuButton(class_1799 stack) {
        String name = stack.method_7964().getString();
        return stack.method_31574(class_1802.field_8157) && name.isBlank() || stack.method_31574(class_1802.field_8575) && name.contains("Page") || stack.method_31574(class_1802.field_8107) && name.contains("Back") || stack.method_31574(class_1802.field_8638) && name.contains("Pickup") || stack.method_31574(class_1802.field_8106) && name.contains("Insert") || stack.method_31574(class_1802.field_8298) || stack.method_31574(class_1802.field_8449) && name.contains("Filter") || stack.method_31574(class_1802.field_8077) && name.contains("Close");
    }
}

