/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.chesttracker.impl.gui.invbutton.ui;

import java.util.Optional;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_7919;
import red.jackf.chesttracker.api.providers.MemoryLocation;
import red.jackf.chesttracker.impl.gui.invbutton.ui.SecondaryButton;
import red.jackf.chesttracker.impl.gui.util.SpriteSet;
import red.jackf.chesttracker.impl.memory.MemoryBankImpl;
import red.jackf.chesttracker.impl.memory.MemoryKeyImpl;
import red.jackf.chesttracker.impl.memory.key.ManualMode;
import red.jackf.chesttracker.impl.memory.key.OverrideInfo;
import red.jackf.chesttracker.impl.util.GuiUtil;
import red.jackf.chesttracker.impl.util.Misc;

@Environment(value=EnvType.CLIENT)
public class RememberContainerButton
extends SecondaryButton {
    private final MemoryBankImpl bank;
    private final MemoryLocation memoryLocation;
    private State state = State.REMEMBER;

    public RememberContainerButton(MemoryBankImpl bank, MemoryLocation memoryLocation) {
        super(State.REMEMBER.sprites, State.REMEMBER.tooltip.get(), () -> {});
        this.bank = bank;
        this.memoryLocation = memoryLocation;
        this.onClick = this::cycleState;
        State initial = bank.getMetadata().getFilteringSettings().manualMode ? State.BLOCK : State.REMEMBER;
        Optional<MemoryKeyImpl> key = bank.getKeyInternal(this.memoryLocation.memoryKey());
        if (key.isPresent()) {
            OverrideInfo info = key.get().overrides().get(this.memoryLocation.position());
            if (info != null && info.getManualMode() != ManualMode.DEFAULT) {
                initial = info.getManualMode() == ManualMode.REMEMBER ? State.REMEMBER : State.BLOCK;
            } else if (key.get().get(memoryLocation.position()).isPresent()) {
                initial = State.REMEMBER;
            }
        }
        this.setState(initial);
    }

    @Override
    protected SpriteSet getSprites() {
        return this.state.sprites;
    }

    private void cycleState() {
        this.setState(Misc.next(this.state));
        if (this.state == State.BLOCK) {
            this.bank.removeMemory(this.memoryLocation.memoryKey(), this.memoryLocation.position());
        }
        boolean isManualMode = this.bank.getMetadata().getFilteringSettings().manualMode;
        ManualMode mode = ManualMode.DEFAULT;
        if (this.state == State.REMEMBER && isManualMode) {
            mode = ManualMode.REMEMBER;
        } else if (this.state == State.BLOCK && !isManualMode) {
            mode = ManualMode.BLOCK;
        }
        this.bank.setManualModeOverride(this.memoryLocation.memoryKey(), this.memoryLocation.position(), mode);
    }

    private void setState(State state) {
        this.state = state;
        class_2561 message = state.tooltip.get();
        this.method_25355(message);
        this.method_47400(class_7919.method_47407((class_2561)message));
    }

    @Environment(value=EnvType.CLIENT)
    public static enum State {
        REMEMBER(GuiUtil.twoSprite("inventory_button/remember_container/always"), () -> class_2561.method_43471((String)"chesttracker.inventoryButton.rememberContainer.remember").method_27692(class_124.field_1060)),
        BLOCK(GuiUtil.twoSprite("inventory_button/remember_container/never"), () -> class_2561.method_43471((String)"chesttracker.inventoryButton.rememberContainer.block").method_27692(class_124.field_1061));

        private final SpriteSet sprites;
        private final Supplier<class_2561> tooltip;

        private State(SpriteSet sprites, Supplier<class_2561> tooltip) {
            this.sprites = sprites;
            this.tooltip = tooltip;
        }
    }
}

