/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.chesttracker.impl.gui.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleResourceReloadListener;
import net.minecraft.class_1011;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_5253;
import red.jackf.chesttracker.impl.ChestTracker;
import red.jackf.chesttracker.impl.gui.util.TextColours;

@Environment(value=EnvType.CLIENT)
public class ImagePixelReader {
    private static final class_2960 TEXTURE = ChestTracker.id("textures/gui/text_colours.png");
    private static final List<Consumer<Integer>> results = new ArrayList<Consumer<Integer>>();
    private static final List<Function<class_1011, Integer>> hooks = new ArrayList<Function<class_1011, Integer>>();

    private ImagePixelReader() {
    }

    private static void addPixelColourListener(int x, int y, int defaultColour, Consumer<Integer> result) {
        hooks.add(image -> {
            if (image.method_4307() > x && image.method_4323() > y) {
                return ImagePixelReader.abgrToArgb(image.method_4315(x, y));
            }
            return defaultColour;
        });
        results.add(result);
    }

    private static int abgrToArgb(int abgr) {
        int r = class_5253.class_8045.method_48345((int)abgr);
        int g = class_5253.class_8045.method_48346((int)abgr);
        int b = class_5253.class_8045.method_48347((int)abgr);
        int a = class_5253.class_8045.method_48342((int)abgr);
        return class_5253.class_5254.method_27764((int)a, (int)r, (int)g, (int)b);
    }

    public static void setup() {
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)new TitleListener());
        ImagePixelReader.addPixelColourListener(2, 5, 0x404040, TextColours::setLabelColour);
        ImagePixelReader.addPixelColourListener(2, 14, 0xFFFFFF, TextColours::setTextColour);
        ImagePixelReader.addPixelColourListener(2, 23, 0x808080, TextColours::setHintColour);
        ImagePixelReader.addPixelColourListener(2, 31, 6724540, TextColours::setSearchKeyColour);
        ImagePixelReader.addPixelColourListener(2, 41, 0xEECC77, TextColours::setSearchTermColour);
        ImagePixelReader.addPixelColourListener(2, 49, 0xFF0000, TextColours::setErrorColour);
    }

    @Environment(value=EnvType.CLIENT)
    public static class TitleListener
    implements SimpleResourceReloadListener<List<Integer>> {
        public class_2960 getFabricId() {
            return ChestTracker.id("pixel_colour_listener");
        }

        public CompletableFuture<List<Integer>> load(class_3300 manager, class_3695 profiler, Executor executor) {
            Optional resource = manager.method_14486(TEXTURE);
            ArrayList<Integer> list = new ArrayList<Integer>();
            if (resource.isEmpty()) {
                ChestTracker.LOGGER.warn("Texture {} not found", (Object)TEXTURE);
            } else {
                try (class_1011 image = class_1011.method_4309((InputStream)((class_3298)resource.get()).method_14482());){
                    for (Function<class_1011, Integer> hook : hooks) {
                        list.add(hook.apply(image));
                    }
                }
                catch (IOException e) {
                    ChestTracker.LOGGER.warn("Error loading %s: ".formatted(TEXTURE), (Throwable)e);
                }
            }
            return CompletableFuture.completedFuture(list);
        }

        public CompletableFuture<Void> apply(List<Integer> data, class_3300 manager, class_3695 profiler, Executor executor) {
            for (int i = 0; i < data.size(); ++i) {
                results.get(i).accept(data.get(i));
            }
            return CompletableFuture.completedFuture(null);
        }
    }
}

