/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.chesttracker.impl.gui.widget;

import com.mojang.datafixers.util.Pair;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_6382;
import org.jetbrains.annotations.NotNull;
import red.jackf.chesttracker.impl.config.ChestTrackerConfig;
import red.jackf.chesttracker.impl.util.GuiUtil;
import red.jackf.chesttracker.impl.util.Strings;
import red.jackf.whereisit.api.SearchRequest;
import red.jackf.whereisit.client.api.events.SearchInvoker;
import red.jackf.whereisit.client.api.events.SearchRequestPopulator;

@Environment(value=EnvType.CLIENT)
public class ItemListWidget
extends class_339 {
    private static final class_2960 BACKGROUND_SPRITE = GuiUtil.png("widgets/slot_background");
    private static final class_1799 DUMMY_ITEM_FOR_COUNT = new class_1799((class_1935)class_1802.field_8687);
    private final int gridWidth;
    private final int gridHeight;
    private List<class_1799> items = Collections.emptyList();
    private int offset = 0;
    private boolean hideTooltip;

    public ItemListWidget(int x, int y, int gridWidth, int gridHeight) {
        super(x, y, gridWidth * 18, gridHeight * 18, (class_2561)class_2561.method_43473());
        this.gridWidth = gridWidth;
        this.gridHeight = gridHeight;
    }

    public void setItems(List<class_1799> items) {
        this.items = items;
        int rows = this.getRows();
        this.offset = class_3532.method_15340((int)this.offset, (int)0, (int)Math.max((rows - this.gridHeight) * this.gridWidth, 0));
    }

    private List<class_1799> getOffsetItems() {
        if (this.items.isEmpty()) {
            return Collections.emptyList();
        }
        int min = class_3532.method_15340((int)this.offset, (int)0, (int)(this.items.size() - 1));
        int max = class_3532.method_15340((int)(this.offset + this.gridWidth * this.gridHeight), (int)0, (int)this.items.size());
        return this.items.subList(min, max);
    }

    public int getRows() {
        return class_3532.method_38788((int)this.items.size(), (int)this.gridWidth);
    }

    public void onScroll(float progress) {
        int rows = this.getRows();
        if (rows <= this.gridHeight) {
            return;
        }
        int range = rows - this.gridHeight;
        int rowOffset = (int)(progress * ((float)range + 0.5f));
        this.offset = rowOffset * this.gridWidth;
    }

    public void method_25348(double mouseX, double mouseY) {
        List<class_1799> items = this.getOffsetItems();
        int x = (int)((mouseX - (double)this.method_46426()) / 18.0);
        int y = (int)((mouseY - (double)this.method_46427()) / 18.0);
        int index = y * this.gridWidth + x;
        if (index >= items.size()) {
            return;
        }
        SearchRequest request = new SearchRequest();
        SearchRequestPopulator.addItemStack((Consumer)request, (class_1799)items.get(index), (SearchRequestPopulator.Context)(class_437.method_25442() ? SearchRequestPopulator.Context.FAVOURITE : SearchRequestPopulator.Context.INVENTORY_PRECISE));
        SearchInvoker.doSearch((SearchRequest)request);
    }

    protected void method_48579(@NotNull class_332 graphics, int mouseX, int mouseY, float partialTick) {
        GuiUtil.blitRepeating(graphics, BACKGROUND_SPRITE, this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364(), 18, 18);
        this.renderItems(graphics);
        this.renderItemDecorations(graphics);
        this.renderAdditional(graphics, mouseX, mouseY);
    }

    private void renderItems(class_332 graphics) {
        List<class_1799> items = this.getOffsetItems();
        for (int i = 0; i < this.gridWidth * this.gridHeight; ++i) {
            int x = this.method_46426() + 18 * (i % this.gridWidth);
            int y = this.method_46427() + 18 * (i / this.gridWidth);
            if (i >= items.size()) continue;
            class_1799 item = items.get(i);
            graphics.method_51427(item, x + 1, y + 1);
        }
    }

    private static Pair<Integer, Integer> getScales() {
        int currentScale = class_310.method_1551().method_22683().method_4476(((Integer)class_310.method_1551().field_1690.method_42474().method_41753()).intValue(), class_310.method_1551().method_1573());
        int textScale = Math.max(1, currentScale + ((ChestTrackerConfig)ChestTrackerConfig.INSTANCE.instance()).gui.itemListTextScale);
        return Pair.of((Object)textScale, (Object)currentScale);
    }

    private void renderItemDecorations(class_332 graphics) {
        List<class_1799> items = this.getOffsetItems();
        for (int i = 0; i < items.size(); ++i) {
            class_1799 item = items.get(i);
            int offset = -16;
            graphics.method_51448().method_22903();
            int bottomRightX = this.method_46426() + 18 * (i % this.gridWidth + 1);
            int bottomRightY = this.method_46427() + 18 * (i / this.gridWidth + 1);
            graphics.method_51448().method_46416((float)(bottomRightX - 1), (float)(bottomRightY - 1), 0.0f);
            graphics.method_51432(class_310.method_1551().field_1772, item, offset, offset, "");
            Pair<Integer, Integer> scales = ItemListWidget.getScales();
            int textScale = (Integer)scales.getFirst();
            int guiScale = (Integer)scales.getSecond();
            float scaleFactor = (float)textScale / (float)guiScale;
            graphics.method_51448().method_22905(scaleFactor, scaleFactor, 1.0f);
            String text = Strings.magnitude(item.method_7947(), 0);
            graphics.method_51432(class_310.method_1551().field_1772, DUMMY_ITEM_FOR_COUNT, offset, offset, text);
            graphics.method_51448().method_22909();
        }
    }

    private void renderAdditional(class_332 graphics, int mouseX, int mouseY) {
        List<class_1799> items = this.getOffsetItems();
        if (!this.method_49606()) {
            return;
        }
        int x = (mouseX - this.method_46426()) / 18;
        int y = (mouseY - this.method_46427()) / 18;
        if (x < 0 || x > this.gridWidth || y < 0 || y > this.gridHeight) {
            return;
        }
        int index = y * this.gridWidth + x;
        if (index >= items.size()) {
            return;
        }
        int slotX = this.method_46426() + x * 18;
        int slotY = this.method_46427() + y * 18;
        graphics.method_25294(slotX + 1, slotY + 1, slotX + 18 - 1, slotY + 18 - 1, -2130706433);
        if (!this.hideTooltip) {
            class_1799 stack = items.get(index);
            List lines = class_437.method_25408((class_310)class_310.method_1551(), (class_1799)stack);
            if (stack.method_7947() > 999) {
                lines.add(class_2561.method_43470((String)Strings.commaSeparated(stack.method_7947())).method_27692(class_124.field_1060));
            }
            Optional image = stack.method_32347();
            graphics.method_51448().method_22903();
            graphics.method_51448().method_46416(0.0f, 0.0f, 150.0f);
            graphics.method_51437(class_310.method_1551().field_1772, lines, image, mouseX, mouseY);
            graphics.method_51448().method_22909();
        }
    }

    protected void method_47399(@NotNull class_6382 narrationElementOutput) {
    }

    public void setHideTooltip(boolean shouldHideTooltip) {
        this.hideTooltip = shouldHideTooltip;
    }
}

