/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.chesttracker.impl.memory;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_310;
import red.jackf.chesttracker.api.memory.Memory;
import red.jackf.chesttracker.api.memory.MemoryKey;
import red.jackf.chesttracker.api.memory.counting.CountingPredicate;
import red.jackf.chesttracker.api.memory.counting.StackMergeMode;
import red.jackf.chesttracker.impl.memory.MemoryBankImpl;
import red.jackf.chesttracker.impl.memory.key.ManualMode;
import red.jackf.chesttracker.impl.memory.key.OverrideInfo;
import red.jackf.chesttracker.impl.memory.key.SearchContext;
import red.jackf.chesttracker.impl.rendering.NameRenderMode;
import red.jackf.chesttracker.impl.util.ItemStacks;
import red.jackf.chesttracker.impl.util.Misc;
import red.jackf.chesttracker.impl.util.ModCodecs;
import red.jackf.jackfredlib.api.base.codecs.JFLCodecs;
import red.jackf.whereisit.api.SearchRequest;
import red.jackf.whereisit.api.SearchResult;
import red.jackf.whereisit.api.search.NestedItemsGrabber;

@Environment(value=EnvType.CLIENT)
public class MemoryKeyImpl
implements MemoryKey {
    private final Map<class_2338, Memory> memories = new HashMap<class_2338, Memory>();
    private final Map<class_2338, Memory> namedMemories = new HashMap<class_2338, Memory>();
    private final Map<class_2338, class_2338> connected = new HashMap<class_2338, class_2338>();
    private final Map<class_2338, OverrideInfo> overrides = new HashMap<class_2338, OverrideInfo>();
    private MemoryBankImpl memoryBank = null;

    public MemoryKeyImpl(Map<class_2338, Memory> memories, Map<class_2338, OverrideInfo> overrides) {
        this.memories.putAll(memories);
        this.overrides.putAll(overrides);
        for (Map.Entry<class_2338, Memory> entry : memories.entrySet()) {
            class_2338 pos = entry.getKey();
            Memory memory = entry.getValue();
            memory.populate(this, entry.getKey());
            if (memory.hasCustomName()) {
                this.namedMemories.put(entry.getKey(), memory);
            }
            for (class_2338 otherPosition : memory.otherPositions()) {
                this.connected.put(otherPosition, entry.getKey());
            }
        }
    }

    public MemoryKeyImpl() {
    }

    protected void setMemoryBank(MemoryBankImpl bank) {
        this.memoryBank = bank;
    }

    public MemoryBankImpl getMemoryBank() {
        return this.memoryBank;
    }

    @Override
    public boolean isEmpty() {
        return this.memories.isEmpty() && this.overrides.isEmpty();
    }

    @Override
    public Map<class_2338, Memory> getMemories() {
        return this.memories;
    }

    @Override
    public Map<class_2338, Memory> getNamedMemories() {
        return this.namedMemories;
    }

    public Map<class_2338, OverrideInfo> overrides() {
        return this.overrides;
    }

    public void add(class_2338 position, Memory memory) {
        boolean shouldAdd;
        OverrideInfo override = this.overrides.get(position);
        ManualMode manualMode = override != null ? override.getManualMode() : ManualMode.DEFAULT;
        boolean bl = shouldAdd = manualMode == ManualMode.REMEMBER || manualMode == ManualMode.DEFAULT && !this.memoryBank.getMetadata().getFilteringSettings().manualMode || this.memories.containsKey(position);
        if (!shouldAdd) {
            return;
        }
        memory.populate(this, position);
        if (this.memoryBank.getMetadata().getFilteringSettings().onlyRememberNamed && !memory.hasCustomName()) {
            this.remove(position);
            return;
        }
        if (!(!memory.isEmpty() || memory.hasCustomName() && this.memoryBank.getMetadata().getIntegritySettings().preserveNamed)) {
            this.remove(position);
            return;
        }
        memory.touch(this.memoryBank.getMetadata().getLoadedTime(), class_310.method_1551().field_1687.method_8510());
        OverrideInfo existingOverride = null;
        for (class_2338 blockPos : memory.otherPositions()) {
            if (this.overrides.containsKey(blockPos)) {
                existingOverride = this.overrides.get(blockPos);
            }
            this.remove(blockPos);
        }
        if (existingOverride != null) {
            this.overrides.put(position, existingOverride);
        }
        this.memories.put(position, memory);
        if (memory.hasCustomName()) {
            this.namedMemories.put(position, memory);
        }
        for (class_2338 otherPosition : memory.otherPositions()) {
            this.connected.put(otherPosition, position);
        }
    }

    public boolean remove(class_2338 position) {
        class_2338 rootPosition = this.connected.getOrDefault(position, position);
        boolean success = this.memories.remove(rootPosition) != null;
        this.namedMemories.remove(rootPosition);
        while (this.connected.values().remove(rootPosition)) {
        }
        this.overrides.remove(position);
        return success;
    }

    @Override
    public Optional<Memory> get(class_2338 pos) {
        return Optional.ofNullable(this.memories.get(this.connected.getOrDefault(pos, pos)));
    }

    @Override
    public List<class_1799> getCounts(CountingPredicate predicate, StackMergeMode stackMergeMode, boolean unpackNested) {
        List<List> items = this.memories.entrySet().stream().filter(predicate).map(entry -> {
            if (unpackNested) {
                return ((Memory)entry.getValue()).items().stream().flatMap(stack -> Stream.concat(Stream.of(stack), NestedItemsGrabber.get((class_1799)stack))).toList();
            }
            return ((Memory)entry.getValue()).items();
        }).toList();
        return switch (stackMergeMode) {
            default -> throw new IncompatibleClassChangeError();
            case StackMergeMode.ALL -> ItemStacks.flattenStacks(items.stream().flatMap(Collection::stream).toList(), false);
            case StackMergeMode.WITHIN_CONTAINERS -> items.stream().flatMap(list -> ItemStacks.flattenStacks(list, false).stream()).toList();
            case StackMergeMode.NEVER -> items.stream().flatMap(Collection::stream).toList();
        };
    }

    public List<SearchResult> doSearch(SearchContext context) {
        ArrayList<SearchResult> results = new ArrayList<SearchResult>();
        long rangeSquared = (long)context.metadata().getSearchSettings().searchRange * (long)context.metadata().getSearchSettings().searchRange;
        for (Map.Entry<class_2338, Memory> entry : this.memories.entrySet()) {
            Optional<class_1799> matchingItem;
            if (entry.getKey().method_19770((class_2374)context.rootPosition()) > (double)rangeSquared || (matchingItem = entry.getValue().items().stream().filter(stack -> SearchRequest.check((class_1799)stack, (SearchRequest)context.request())).findFirst()).isEmpty()) continue;
            SearchResult.Builder result = SearchResult.builder((class_2338)entry.getKey()).item(matchingItem.get()).otherPositions(entry.getValue().otherPositions());
            if (context.metadata().getCompatibilitySettings().nameRenderMode == NameRenderMode.FULL) {
                result.name(entry.getValue().renderName(), Misc.getAverageOffsetFrom(entry.getKey(), entry.getValue().otherPositions()).method_1031(0.0, 1.0, 0.0));
            }
            results.add(result.build());
        }
        return results;
    }

    @Environment(value=EnvType.CLIENT)
    public static class Codecs {
        private static final Codec<Map<class_2338, Memory>> MEMORY_MAP = Codec.unboundedMap(ModCodecs.BLOCK_POS_STRING, Memory.CODEC);
        private static final Codec<MemoryKeyImpl> V2_3_3 = MEMORY_MAP.xmap(map -> new MemoryKeyImpl((Map<class_2338, Memory>)map, Collections.emptyMap()), MemoryKeyImpl::getMemories);
        private static final Codec<MemoryKeyImpl> LATEST = RecordCodecBuilder.create(instance -> instance.group((App)MEMORY_MAP.fieldOf("memories").forGetter(MemoryKeyImpl::getMemories), (App)Codec.unboundedMap(ModCodecs.BLOCK_POS_STRING, OverrideInfo.CODEC).fieldOf("overrides").forGetter(MemoryKeyImpl::overrides)).apply((Applicative)instance, MemoryKeyImpl::new));
        public static final Codec<MemoryKeyImpl> MAIN = JFLCodecs.firstInList((Codec[])new Codec[]{LATEST, V2_3_3});
    }
}

