/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.chesttracker.impl.providers;

import com.google.common.collect.Sets;
import java.util.Comparator;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.message.v1.ClientReceiveMessageEvents;
import net.fabricmc.fabric.api.client.message.v1.ClientSendMessageEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.minecraft.class_1937;
import org.jetbrains.annotations.Nullable;
import red.jackf.chesttracker.api.providers.InteractionTracker;
import red.jackf.chesttracker.api.providers.ServerProvider;
import red.jackf.chesttracker.api.providers.context.BlockPlacedContext;
import red.jackf.chesttracker.impl.events.AfterPlayerPlaceBlock;
import red.jackf.chesttracker.impl.memory.MemoryBankAccessImpl;
import red.jackf.chesttracker.impl.util.CachedClientBlockSource;
import red.jackf.jackfredlib.client.api.gps.Coordinate;

@Environment(value=EnvType.CLIENT)
public class ProviderHandler {
    public static final ProviderHandler INSTANCE = new ProviderHandler();
    private final Set<ServerProvider> REGISTERED_PROVIDERS = Sets.newHashSet();
    private ServerProvider currentProvider = null;
    @Nullable
    private Coordinate lastCoordinate = null;

    private ProviderHandler() {
    }

    public <T extends ServerProvider> T register(T provider) {
        this.REGISTERED_PROVIDERS.add(provider);
        return provider;
    }

    private void load(Coordinate coordinate) {
        if (this.currentProvider != null) {
            this.unload();
        }
        this.REGISTERED_PROVIDERS.stream().sorted(Comparator.comparingInt(ServerProvider::getPriority).reversed()).filter(provider -> provider.appliesTo(coordinate)).findFirst().ifPresent(serverProvider -> {
            this.currentProvider = serverProvider;
            serverProvider.onConnect(coordinate);
        });
    }

    private void unload() {
        if (this.currentProvider == null) {
            return;
        }
        this.currentProvider.onDisconnect();
        MemoryBankAccessImpl.INSTANCE.unload();
    }

    public Optional<ServerProvider> getCurrentProvider() {
        return Optional.ofNullable(this.currentProvider);
    }

    public void setupEvents() {
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> client.execute(() -> {
            Optional coord = Coordinate.getCurrent();
            if (coord.isPresent()) {
                if (!((Coordinate)coord.get()).equals((Object)this.lastCoordinate)) {
                    this.lastCoordinate = (Coordinate)coord.get();
                    this.load((Coordinate)coord.get());
                }
            } else {
                this.unload();
            }
        }));
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            this.lastCoordinate = null;
            client.execute(this::unload);
        });
        AfterPlayerPlaceBlock.EVENT.register((clientLevel, pos, state, placementStack) -> this.getCurrentProvider().ifPresent(provider -> MemoryBankAccessImpl.INSTANCE.getLoadedInternal().ifPresent(bank -> {
            if (!bank.getMetadata().getFilteringSettings().autoAddPlacedBlocks.blockPredicate.test(state)) {
                return;
            }
            CachedClientBlockSource cbs = new CachedClientBlockSource((class_1937)clientLevel, pos, state);
            provider.onBlockPlaced(BlockPlacedContext.create(cbs, placementStack));
        })));
        ClientReceiveMessageEvents.GAME.register((message, overlay) -> this.getCurrentProvider().ifPresent(provider -> provider.onGameMessageReceived(message, overlay)));
        ClientSendMessageEvents.COMMAND.register(command -> {
            this.getCurrentProvider().ifPresent(provider -> provider.onCommandSent(command));
            InteractionTracker.INSTANCE.clear();
        });
    }
}

