/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.chesttracker.impl.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2509;
import org.apache.logging.log4j.Logger;
import red.jackf.chesttracker.impl.ChestTracker;
import red.jackf.chesttracker.impl.config.ChestTrackerConfig;

@Environment(value=EnvType.CLIENT)
public class FileUtil {
    public static final Logger LOGGER = ChestTracker.getLogger("FileUtil");
    private static final Gson GSON_COMPACT = new GsonBuilder().create();
    private static final Gson GSON = GSON_COMPACT.newBuilder().setPrettyPrinting().create();

    public static <T> boolean saveToNbt(T object, Codec<T> codec, Path path) {
        try {
            Object t;
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Either tag = codec.encodeStart((DynamicOps)class_2509.field_11560, object).get();
            Optional result = tag.left();
            Optional err = tag.right();
            if (err.isPresent()) {
                throw new IOException("Error encoding to NBT %s".formatted(err.get()));
            }
            if (result.isPresent() && (t = result.get()) instanceof class_2487) {
                class_2487 compound = (class_2487)t;
                class_2507.method_30614((class_2487)compound, (File)path.toFile());
                return true;
            }
            throw new IOException("Error encoding to NBT: not a compound tag: %s".formatted(result.get()));
        }
        catch (IOException ex) {
            LOGGER.error("Error saving object", (Throwable)ex);
            return false;
        }
    }

    public static <T> Optional<T> loadFromNbt(Codec<T> codec, Path path) {
        if (Files.isRegularFile(path, new LinkOption[0])) {
            try {
                class_2487 tag = class_2507.method_30613((File)path.toFile());
                Either loaded = codec.decode((DynamicOps)class_2509.field_11560, (Object)tag).get();
                if (loaded.right().isPresent()) {
                    throw new IOException("Invalid NBT: %s".formatted(loaded.right().get()));
                }
                return Optional.ofNullable(((Pair)loaded.left().get()).getFirst());
            }
            catch (IOException ex) {
                LOGGER.error("Error loading object at {}", (Object)path, (Object)ex);
                FileUtil.tryMove(path, path.resolveSibling(String.valueOf(path.getFileName()) + ".corrupt"), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        return Optional.empty();
    }

    public static void tryMove(Path from, Path to, CopyOption ... options) {
        try {
            Files.move(from, to, options);
        }
        catch (IOException e) {
            LOGGER.error("Error moving %s to %s".formatted(from, to), (Throwable)e);
        }
    }

    public static Gson gson() {
        return ((ChestTrackerConfig)ChestTrackerConfig.INSTANCE.instance()).storage.readableJsonMemories ? GSON : GSON_COMPACT;
    }
}

