/*
 * Decompiled with CFR 0.152.
 */
package red.jackf.chesttracker.impl.util;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1293;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_2477;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class ItemStacks {
    public static List<class_1799> flattenStacks(List<class_1799> in, boolean sortDescending) {
        HashMap<LightweightStack, Integer> counts = new HashMap<LightweightStack, Integer>();
        for (class_1799 itemStack : in) {
            counts.merge(new LightweightStack(itemStack), itemStack.method_7947(), Integer::sum);
        }
        Stream<class_1799> stream = counts.entrySet().stream().map(entry -> {
            class_1799 stack = ((LightweightStack)entry.getKey()).toStack();
            stack.method_7939(((Integer)entry.getValue()).intValue());
            return stack;
        });
        if (sortDescending) {
            stream = stream.sorted(Comparator.comparingInt(class_1799::method_7947).reversed());
        }
        return stream.toList();
    }

    private static boolean testLang(String key, String filter) {
        return class_2477.method_10517().method_4678(key) && class_2477.method_10517().method_48307(key).toLowerCase().contains(filter);
    }

    public static boolean defaultPredicate(class_1799 stack, String filter) {
        return ItemStacks.namePredicate(stack, filter) || ItemStacks.tagPredicate(stack, filter) || ItemStacks.lorePredicate(stack, filter) || ItemStacks.tooltipPredicate(stack, filter) || ItemStacks.enchantmentPredicate(stack, filter) || ItemStacks.potionOrEffectPredicate(stack, filter) || ItemStacks.countPredicate(stack, filter);
    }

    public static boolean namePredicate(class_1799 stack, String filter) {
        return StringUtils.containsIgnoreCase((CharSequence)stack.method_7964().getString(), (CharSequence)filter);
    }

    public static boolean tagPredicate(class_1799 stack, String filter) {
        return stack.method_41409().method_40228().anyMatch(tag -> tag.comp_327().method_12832().contains(filter));
    }

    private static boolean lorePredicate(class_1799 stack, String filter) {
        List<class_2561> lore = ItemStacks.getLore(stack);
        for (class_2561 line : lore) {
            if (!line.getString().toLowerCase().contains(filter)) continue;
            return true;
        }
        return false;
    }

    public static boolean tooltipPredicate(class_1799 stack, String filter) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return false;
        }
        class_1836.class_1837 advanced = class_310.method_1551().field_1690.field_1827 ? class_1836.class_1837.field_41071 : class_1836.class_1837.field_41070;
        for (class_2561 line : stack.method_7950((class_1657)player, (class_1836)advanced)) {
            if (!line.getString().toLowerCase().contains(filter)) continue;
            return true;
        }
        return false;
    }

    public static boolean enchantmentPredicate(class_1799 stack, String filter) {
        Map enchantments = class_1890.method_8222((class_1799)stack);
        if (enchantments.isEmpty()) {
            return false;
        }
        return enchantments.keySet().stream().anyMatch(ench -> {
            if (ItemStacks.testLang(ench.method_8184(), filter)) {
                return true;
            }
            class_2960 resloc = class_7923.field_41176.method_10221(ench);
            return resloc != null && resloc.toString().contains(filter);
        });
    }

    public static boolean potionOrEffectPredicate(class_1799 stack, String filter) {
        class_1842 potion = class_1844.method_8063((class_1799)stack);
        if (potion != class_1847.field_8984) {
            String langKey = potion.method_8051(stack.method_7922() + ".effect.");
            if (ItemStacks.testLang(langKey, filter)) {
                return true;
            }
            class_2960 resloc = class_7923.field_41179.method_10221((Object)potion);
            if (resloc != null && resloc.toString().contains(filter)) {
                return true;
            }
        }
        List effects = class_1844.method_8067((class_1799)stack);
        for (class_1293 effect : effects) {
            String langKey = effect.method_5586();
            if (ItemStacks.testLang(langKey, filter)) {
                return true;
            }
            class_2960 resloc = class_7923.field_41174.method_10221((Object)effect.method_5579());
            if (resloc == null || !resloc.toString().contains(filter)) continue;
            return true;
        }
        return false;
    }

    private static boolean countPredicate(class_1799 stack, String filter) {
        try {
            if (filter.startsWith(">=")) {
                return stack.method_7947() >= Integer.parseInt(filter.substring(2));
            }
            if (filter.startsWith(">")) {
                return stack.method_7947() > Integer.parseInt(filter.substring(1));
            }
            if (filter.startsWith("<=")) {
                return stack.method_7947() <= Integer.parseInt(filter.substring(2));
            }
            if (filter.startsWith("<")) {
                return stack.method_7947() < Integer.parseInt(filter.substring(1));
            }
            if (filter.startsWith("=")) {
                return stack.method_7947() == Integer.parseInt(filter.substring(1));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return false;
    }

    public static List<class_2561> getLore(class_1799 stack) {
        class_2487 displayTag;
        ArrayList<class_2561> lore = new ArrayList<class_2561>();
        class_2487 tag = stack.method_7969();
        if (tag != null && tag.method_10573("display", 10) && (displayTag = tag.method_10562("display")).method_10573("Lore", 9)) {
            class_2499 loreTag = displayTag.method_10554("Lore", 8);
            for (int i = 0; i < loreTag.size(); ++i) {
                String line = loreTag.method_10608(i);
                try {
                    class_5250 component = class_2561.class_2562.method_10877((String)line);
                    if (component == null) continue;
                    lore.add((class_2561)component);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return lore;
    }

    @Environment(value=EnvType.CLIENT)
    public record LightweightStack(class_1792 item, @Nullable class_2487 tag) {
        public static final Codec<LightweightStack> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_7923.field_41178.method_39673().fieldOf("id").forGetter(LightweightStack::item), (App)class_2487.field_25128.optionalFieldOf("tag").forGetter(stack -> Optional.ofNullable(stack.tag()))).apply((Applicative)instance, LightweightStack::new));

        public LightweightStack(class_1799 stack) {
            this(stack.method_7909(), stack.method_7969());
        }

        private LightweightStack(class_1792 item, Optional<class_2487> tag) {
            this(item, (class_2487)tag.orElse(null));
        }

        public class_1799 toStack() {
            class_1799 stack = new class_1799((class_1935)this.item);
            stack.method_7980(this.tag);
            return stack;
        }
    }
}

