/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutter.block.custom;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.function.ToIntFunction;
import net.emilsg.clutter.block.ModBlockEntities;
import net.emilsg.clutter.block.ModBlocks;
import net.emilsg.clutter.block.entity.BonfireBlockEntity;
import net.minecraft.class_10;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1821;
import net.minecraft.class_1836;
import net.minecraft.class_1890;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2464;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3542;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class BonfireBlock
extends class_2237 {
    public static final class_2754<BONFIRE_BLOCK_MODEL> BLOCK_SHAPE = class_2754.method_11850((String)"block_shape", BONFIRE_BLOCK_MODEL.class);
    private static final class_2746 LIT = class_2741.field_12548;
    private static final class_265 UP_NORTH_WEST_SHAPE = class_259.method_17786((class_265)class_2248.method_9541((double)5.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0, (double)16.0), (class_265[])new class_265[0]);
    private static final class_265 UP_WEST_SHAPE = class_259.method_17786((class_265)class_2248.method_9541((double)8.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), (class_265[])new class_265[0]);
    private static final class_265 UP_SOUTH_WEST_SHAPE = class_259.method_17786((class_265)class_2248.method_9541((double)5.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)8.0), (class_265[])new class_265[0]);
    private static final class_265 UP_NORTH_SHAPE = class_259.method_17786((class_265)class_2248.method_9541((double)0.0, (double)0.0, (double)8.0, (double)16.0, (double)8.0, (double)16.0), (class_265[])new class_265[0]);
    private static final class_265 UP_CENTER_SHAPE = class_259.method_17786((class_265)class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (class_265[])new class_265[0]);
    private static final class_265 UP_SOUTH_SHAPE = class_259.method_17786((class_265)class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)8.0), (class_265[])new class_265[0]);
    private static final class_265 UP_NORTH_EAST_SHAPE = class_259.method_17786((class_265)class_2248.method_9541((double)0.0, (double)0.0, (double)8.0, (double)11.0, (double)8.0, (double)16.0), (class_265[])new class_265[0]);
    private static final class_265 UP_EAST_SHAPE = class_259.method_17786((class_265)class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)8.0, (double)8.0, (double)16.0), (class_265[])new class_265[0]);
    private static final class_265 UP_SOUTH_EAST_SHAPE = class_259.method_17786((class_265)class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)11.0, (double)8.0, (double)8.0), (class_265[])new class_265[0]);
    private static final class_265 FULL_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final class_2350[] cardinalDirections = new class_2350[]{class_2350.field_11043, class_2350.field_11034, class_2350.field_11035, class_2350.field_11039};

    public BonfireBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)LIT, (Comparable)Boolean.valueOf(true)));
    }

    public static boolean checkAirAround(class_2338 pos, class_1937 world, boolean checkBonfireBlocks) {
        class_2338[] positionsToCheck;
        for (class_2338 basePos : positionsToCheck = new class_2338[]{pos, pos.method_10084()}) {
            class_2350[] class_2350Array = cardinalDirections;
            int n = class_2350Array.length;
            for (int i = 0; i < n; ++i) {
                class_2350 direction1 = class_2350Array[i];
                class_2338 neighborPos1 = basePos.method_10093(direction1);
                class_2680 neighborState1 = world.method_8320(neighborPos1);
                if (neighborState1.method_26204() != class_2246.field_10124 && !neighborState1.method_45474()) {
                    return false;
                }
                for (class_2350 direction2 : cardinalDirections) {
                    class_2338 diagonalPos;
                    class_2680 diagonalState;
                    if (direction2.method_10166() == direction1.method_10166() || (diagonalState = world.method_8320(diagonalPos = neighborPos1.method_10093(direction2))).method_26204() == class_2246.field_10124 || diagonalState.method_45474()) continue;
                    return false;
                }
            }
        }
        if (checkBonfireBlocks) {
            int[] xOffsetArray = new int[]{-2, -1, 0, 1, 2};
            int[] yOffsetArray = new int[]{-1, 0, 1, 2};
            int[] zOffsetArray = new int[]{-2, -1, 0, 1, 2};
            for (int yOffset : yOffsetArray) {
                class_2338 yOffsetPos = pos.method_10069(0, yOffset, 0);
                for (int xOffset : xOffsetArray) {
                    for (int zOffset : zOffsetArray) {
                        class_2338 targetPos = yOffsetPos.method_10069(xOffset, 0, zOffset);
                        class_2680 targetState = world.method_8320(targetPos);
                        if (!(targetState.method_26204() instanceof BonfireBlock)) continue;
                        return false;
                    }
                }
            }
        }
        return world.method_8320(pos.method_10084()).method_26204() == class_2246.field_10124;
    }

    public static ToIntFunction<class_2680> createLightLevelFromLitBlockState(int litLevel) {
        return state -> (Boolean)state.method_11654((class_2769)LIT) != false ? litLevel : 0;
    }

    public static void spawnThickSmokeParticles(class_1937 world, class_2338 pos, class_2680 state, double yOffset) {
        class_5819 random = world.method_8409();
        world.method_17452((class_2394)class_2398.field_17431, true, (double)pos.method_10263() + 0.5 + random.method_43058() / 3.0 * (double)(random.method_43056() ? 1 : -1), (double)pos.method_10264() + random.method_43058() + random.method_43058() + yOffset, (double)pos.method_10260() + 0.5 + random.method_43058() / 3.0 * (double)(random.method_43056() ? 1 : -1), random.method_43058() * 0.04 - 0.02, 0.07, random.method_43058() * 0.04 - 0.02);
    }

    public static void spawnSmokeParticles(class_1937 world, class_2338 pos, class_2680 state, double yOffset) {
        class_5819 random = world.method_8409();
        world.method_8406((class_2394)class_2398.field_11251, (double)pos.method_10263() + 0.5 + random.method_43058() / 2.0 * (double)(random.method_43056() ? 1 : -1), (double)pos.method_10264() + yOffset - 0.1, (double)pos.method_10260() + 0.5 + random.method_43058() / 2.0 * (double)(random.method_43056() ? 1 : -1), 0.0, 0.005, 0.0);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{BLOCK_SHAPE, LIT});
    }

    public void placeBonfireBlocks(class_2338 pos, class_1937 world) {
        int index = 0;
        int[] offsets = new int[]{-1, 0, 1};
        for (int yOffset = 0; yOffset < 2; ++yOffset) {
            class_2338 yOffsetPos = pos.method_10086(yOffset);
            for (int xOffset : offsets) {
                for (int zOffset : offsets) {
                    class_2338 targetPos = yOffsetPos.method_10069(xOffset, 0, zOffset);
                    world.method_8501(targetPos, (class_2680)this.method_9564().method_11657(BLOCK_SHAPE, (Comparable)((Object)BONFIRE_BLOCK_MODEL.values()[index])));
                    ++index;
                }
            }
        }
    }

    public void method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
        if (!world.method_8608() && !player.method_31549().field_7477) {
            super.method_9576(world, pos, state, player);
            LinkedList<class_2338> queue = new LinkedList<class_2338>();
            queue.add(pos);
            HashSet<class_2338> visited = new HashSet<class_2338>();
            while (!queue.isEmpty()) {
                class_2338 currentPos = (class_2338)queue.poll();
                visited.add(currentPos);
                for (class_2350 direction : class_2350.values()) {
                    class_2338 neighborPos = currentPos.method_10093(direction);
                    class_2680 neighborState = world.method_8320(neighborPos);
                    if (!(neighborState.method_26204() instanceof BonfireBlock) || visited.contains(neighborPos)) continue;
                    world.method_8651(neighborPos, true, (class_1297)player);
                    queue.add(neighborPos);
                }
            }
        } else if (!world.method_8608() && player.method_31549().field_7477) {
            super.method_9576(world, pos, state, player);
            LinkedList<class_2338> queue = new LinkedList<class_2338>();
            queue.add(pos);
            HashSet<class_2338> visited = new HashSet<class_2338>();
            while (!queue.isEmpty()) {
                class_2338 currentPos = (class_2338)queue.poll();
                visited.add(currentPos);
                for (class_2350 direction : class_2350.values()) {
                    class_2338 neighborPos = currentPos.method_10093(direction);
                    class_2680 neighborState = world.method_8320(neighborPos);
                    if (!(neighborState.method_26204() instanceof BonfireBlock) || visited.contains(neighborPos)) continue;
                    world.method_8651(neighborPos, false, (class_1297)player);
                    queue.add(neighborPos);
                }
            }
        } else {
            super.method_9576(world, pos, state, player);
        }
    }

    public class_1269 method_9534(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        class_1799 itemInHand = player.method_5998(hand);
        if (player.method_31549().field_7476 && itemInHand.method_7909() == class_1802.field_8884 && !((Boolean)state.method_11654((class_2769)LIT)).booleanValue()) {
            this.setLitStateForConnectedBonfires(world, pos, true, player);
            world.method_8396(null, pos, class_3417.field_15145, class_3419.field_15245, 1.0f, 1.0f);
            if (!player.method_31549().field_7477) {
                itemInHand.method_7956(1, (class_1309)player, playerEntity -> playerEntity.method_20236(hand));
            }
            return class_1269.field_5812;
        }
        if (player.method_31549().field_7476 && itemInHand.method_7909() == class_1802.field_8814 && !((Boolean)state.method_11654((class_2769)LIT)).booleanValue()) {
            this.setLitStateForConnectedBonfires(world, pos, true, player);
            world.method_8396(null, pos, class_3417.field_15145, class_3419.field_15245, 1.0f, 1.0f);
            if (!player.method_31549().field_7477) {
                itemInHand.method_7934(1);
            }
            return class_1269.field_5812;
        }
        if (player.method_31549().field_7476 && itemInHand.method_7909() instanceof class_1821 && ((Boolean)state.method_11654((class_2769)LIT)).booleanValue()) {
            this.setLitStateForConnectedBonfires(world, pos, false, player);
            world.method_8396(null, pos, class_3417.field_15102, class_3419.field_15245, 1.0f, 0.8f);
            if (!player.method_31549().field_7477) {
                itemInHand.method_7956(1, (class_1309)player, playerEntity -> playerEntity.method_20236(hand));
            }
            return class_1269.field_5812;
        }
        return class_1269.field_5811;
    }

    private void setLitStateForConnectedBonfires(class_1937 world, class_2338 pos, boolean lit, class_1657 player) {
        LinkedList<class_2338> queue = new LinkedList<class_2338>();
        queue.add(pos);
        HashSet<class_2338> visited = new HashSet<class_2338>();
        world.method_8652(pos, (class_2680)world.method_8320(pos).method_11657((class_2769)LIT, (Comparable)Boolean.valueOf(lit)), 3);
        while (!queue.isEmpty()) {
            class_2338 currentPos = (class_2338)queue.poll();
            visited.add(currentPos);
            for (class_2350 direction : class_2350.values()) {
                class_2338 neighborPos = currentPos.method_10093(direction);
                class_2680 neighborState = world.method_8320(neighborPos);
                if (!(neighborState.method_26204() instanceof BonfireBlock) || visited.contains(neighborPos)) continue;
                world.method_8652(neighborPos, (class_2680)neighborState.method_11657((class_2769)LIT, (Comparable)Boolean.valueOf(lit)), 3);
                queue.add(neighborPos);
            }
        }
    }

    public boolean method_9516(class_2680 state, class_1922 world, class_2338 pos, class_10 type) {
        return false;
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        return BonfireBlock.checkAirAround(pos, (class_1937)world, true);
    }

    public void method_9567(class_1937 world, class_2338 pos, class_2680 state, @Nullable class_1309 placer, class_1799 itemStack) {
        this.placeBonfireBlocks(pos, world);
    }

    public void method_9568(class_1799 stack, @Nullable class_1922 world, List<class_2561> tooltip, class_1836 context) {
        tooltip.add((class_2561)class_2561.method_43471((String)"block.clutter.3x2x3_area_tooltip.tooltip").method_27692(class_124.field_1078));
        tooltip.add((class_2561)class_2561.method_43471((String)"block.clutter.not_next_to_tooltip.tooltip").method_27692(class_124.field_1078));
        super.method_9568(stack, world, tooltip, context);
    }

    public void method_9496(class_2680 state, class_1937 world, class_2338 pos, class_5819 random) {
        if (((Boolean)state.method_11654((class_2769)LIT)).booleanValue()) {
            if (((BONFIRE_BLOCK_MODEL)((Object)state.method_11654(BLOCK_SHAPE))).method_15434().startsWith("up_") && !((BONFIRE_BLOCK_MODEL)((Object)state.method_11654(BLOCK_SHAPE))).method_15434().contains("center_")) {
                BonfireBlock.spawnThickSmokeParticles(world, pos, state, 0.3);
                BonfireBlock.spawnSmokeParticles(world, pos, state, 0.0);
            } else if (((BONFIRE_BLOCK_MODEL)((Object)state.method_11654(BLOCK_SHAPE))).method_15434().contains("up_center")) {
                BonfireBlock.spawnThickSmokeParticles(world, pos, state, 1.0);
                BonfireBlock.spawnSmokeParticles(world, pos, state, 1.0);
            } else {
                BonfireBlock.spawnSmokeParticles(world, pos, state, 0.3);
            }
            if (random.method_43048(8) == 0 && state.method_11654(BLOCK_SHAPE) == BONFIRE_BLOCK_MODEL.CENTER && ((Boolean)state.method_11654((class_2769)LIT)).booleanValue()) {
                world.method_8486((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, class_3417.field_17483, class_3419.field_15245, 0.5f + random.method_43057(), random.method_43057() * 0.7f + 0.2f, false);
            }
            if (random.method_43048(5) == 0 && ((BONFIRE_BLOCK_MODEL)((Object)state.method_11654(BLOCK_SHAPE))).method_15434().startsWith("up_") && this == ModBlocks.BONFIRE) {
                for (int i = 0; i < random.method_43048(1) + 1; ++i) {
                    world.method_8406((class_2394)class_2398.field_11239, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, (double)(random.method_43057() / 2.0f), 5.0E-5, (double)(random.method_43057() / 2.0f));
                }
            }
        }
    }

    public void method_9548(class_2680 state, class_1937 world, class_2338 pos, class_1297 entity) {
        if (((Boolean)state.method_11654((class_2769)LIT)).booleanValue() && entity instanceof class_1309 && !class_1890.method_8216((class_1309)((class_1309)entity))) {
            entity.method_5643(world.method_48963().method_48794(), 2.0f);
        }
    }

    @Nullable
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new BonfireBlockEntity(pos, state);
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return world.method_8608() && type == ModBlockEntities.BONFIRE ? BonfireBlockEntity::clientTick : null;
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11458;
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        BONFIRE_BLOCK_MODEL model = (BONFIRE_BLOCK_MODEL)((Object)state.method_11654(BLOCK_SHAPE));
        return switch (model.ordinal()) {
            case 9 -> UP_NORTH_WEST_SHAPE;
            case 10 -> UP_WEST_SHAPE;
            case 11 -> UP_SOUTH_WEST_SHAPE;
            case 12 -> UP_NORTH_SHAPE;
            case 13 -> UP_CENTER_SHAPE;
            case 14 -> UP_SOUTH_SHAPE;
            case 15 -> UP_NORTH_EAST_SHAPE;
            case 16 -> UP_EAST_SHAPE;
            case 17 -> UP_SOUTH_EAST_SHAPE;
            default -> FULL_SHAPE;
        };
    }

    public static enum BONFIRE_BLOCK_MODEL implements class_3542
    {
        NORTH_WEST("north_west"),
        WEST("west"),
        SOUTH_WEST("south_west"),
        NORTH("north"),
        CENTER("center"),
        SOUTH("south"),
        NORTH_EAST("north_east"),
        EAST("east"),
        SOUTH_EAST("south_east"),
        UP_NORTH_WEST("up_north_west"),
        UP_WEST("up_west"),
        UP_SOUTH_WEST("up_south_west"),
        UP_NORTH("up_north"),
        UP_CENTER("up_center"),
        UP_SOUTH("up_south"),
        UP_NORTH_EAST("up_north_east"),
        UP_EAST("up_east"),
        UP_SOUTH_EAST("up_south_east");

        private final String name;

        private BONFIRE_BLOCK_MODEL(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

