/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutter.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.emilsg.clutter.config.Configs;
import net.emilsg.clutter.config.ModConfigEntry;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModConfigManager {
    private static final Logger LOGGER = LogManager.getLogger((String)"ClutterConfig");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String CONFIG_FILE_NAME = "clutter_config.json";
    private static final String CONFIG_FILE_FOLDER = "clutter";
    private static final Map<String, ModConfigEntry<?>> CONFIG_ENTRIES = new HashMap();
    private static final Map<Class<?>, Function<JsonElement, ?>> PARSERS = new HashMap();
    private static File configDir;
    private static File configFile;
    private static boolean isInitialized;

    private static void initConfigFiles() {
        if (!isInitialized) {
            configDir = new File(FabricLoader.getInstance().getConfigDir().toFile(), CONFIG_FILE_FOLDER);
            if (!configDir.exists()) {
                configDir.mkdirs();
            }
            configFile = new File(configDir, CONFIG_FILE_NAME);
            isInitialized = true;
        }
    }

    public static <T> ModConfigEntry<T> register(String key, T defaultValue, String comment) {
        ModConfigEntry<T> entry = new ModConfigEntry<T>(key, defaultValue, comment);
        CONFIG_ENTRIES.put(key, entry);
        return entry;
    }

    public static <T> T get(String key, T defaultValue) {
        ModConfigEntry<?> entry = CONFIG_ENTRIES.get(key);
        if (entry != null && entry.getValue() != null) {
            return (T)entry.getValue();
        }
        return defaultValue;
    }

    public static void loadConfig() {
        Configs.initConfigs();
        ModConfigManager.initConfigFiles();
        boolean needsSave = false;
        if (configFile.exists()) {
            try (FileReader reader = new FileReader(configFile);){
                JsonObject jsonObject = (JsonObject)GSON.fromJson((Reader)reader, JsonObject.class);
                for (Map.Entry entry : jsonObject.entrySet()) {
                    ModConfigEntry<?> configEntry = CONFIG_ENTRIES.get(entry.getKey());
                    if (configEntry != null) {
                        try {
                            JsonObject entryObject = ((JsonElement)entry.getValue()).getAsJsonObject();
                            JsonElement valueElement = entryObject.get("value");
                            ModConfigManager.setConfigEntryValue(configEntry, valueElement, (String)entry.getKey());
                        }
                        catch (Exception e) {
                            LOGGER.error("Invalid value for key: {}. Using default value.", entry.getKey());
                            configEntry.resetToDefault();
                            needsSave = true;
                        }
                        continue;
                    }
                    LOGGER.error("Unknown config entry: {}", entry.getKey());
                    needsSave = true;
                }
                for (Map.Entry entry : CONFIG_ENTRIES.entrySet()) {
                    if (jsonObject.has((String)entry.getKey())) continue;
                    LOGGER.error("Adding missing config entry: {}", entry.getKey());
                    needsSave = true;
                }
            }
            catch (IOException e) {
                LOGGER.error("Failed to load config file: {}", (Object)CONFIG_FILE_NAME);
                e.printStackTrace();
            }
        } else {
            needsSave = true;
        }
        if (needsSave) {
            ModConfigManager.saveConfig();
        }
    }

    private static <T> void setConfigEntryValue(ModConfigEntry<T> configEntry, JsonElement valueElement, String key) {
        Function<JsonElement, ?> parser = PARSERS.get(configEntry.getDefaultValue().getClass());
        if (parser != null) {
            configEntry.setValue(parser.apply(valueElement));
        } else {
            LOGGER.error("Unsupported type for key: {}. Skipping entry.", (Object)key);
        }
    }

    private static void saveConfig() {
        ModConfigManager.initConfigFiles();
        JsonObject jsonObject = new JsonObject();
        CONFIG_ENTRIES.forEach((key, entry) -> {
            JsonObject entryObject = new JsonObject();
            entryObject.addProperty("comment", entry.getComment());
            entryObject.add("value", GSON.toJsonTree(entry.getValue()));
            jsonObject.add(key, (JsonElement)entryObject);
        });
        try (FileWriter writer = new FileWriter(configFile);){
            GSON.toJson((JsonElement)jsonObject, (Appendable)writer);
        }
        catch (IOException e) {
            LOGGER.error("Error when saving config file: {}", (Object)CONFIG_FILE_NAME);
            e.printStackTrace();
        }
    }

    public static void resetConfigs() {
        CONFIG_ENTRIES.forEach((key, entry) -> entry.resetToDefault());
        ModConfigManager.saveConfig();
    }

    static {
        isInitialized = false;
        PARSERS.put(Boolean.class, JsonElement::getAsBoolean);
        PARSERS.put(Integer.class, JsonElement::getAsInt);
        PARSERS.put(Float.class, JsonElement::getAsFloat);
        PARSERS.put(Double.class, JsonElement::getAsDouble);
        PARSERS.put(String.class, JsonElement::getAsString);
    }
}

