/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.cobweb.api.pack;

import com.google.common.base.Suppliers;
import com.google.gson.JsonElement;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import it.crystalnest.cobweb.Constants;
import it.crystalnest.cobweb.api.pack.DynamicResourceType;
import it.crystalnest.cobweb.platform.Services;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.minecraft.class_155;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_3270;
import net.minecraft.class_3272;
import net.minecraft.class_3288;
import net.minecraft.class_5352;
import net.minecraft.class_7367;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DynamicResourcePack
implements class_3262 {
    private final class_3264 type;
    private final class_2960 name;
    private final String namespace;
    private final Set<String> namespaces = new HashSet<String>();
    private final Supplier<class_3272> metadata;
    private final Map<class_2960, Supplier<byte[]>> resources = new ConcurrentHashMap<class_2960, Supplier<byte[]>>();

    protected DynamicResourcePack(class_2960 name, class_3264 type) {
        this.type = type;
        this.name = name;
        this.namespace = name.method_12836();
        this.namespaces.add(this.namespace);
        this.metadata = Suppliers.memoize(() -> new class_3272((class_2561)class_2561.method_43471((String)(this.namespace + "_dynamic_" + name.method_12832())), class_155.method_16673().method_48017(type)));
    }

    public void register() {
        Services.REGISTRY.registerDynamicResourcePack(this.type, (Supplier<class_3288>)Suppliers.memoize(() -> {
            this.build();
            return class_3288.method_14456((String)this.method_14409(), (class_2561)class_2561.method_43471((String)this.method_14409()), (boolean)true, (class_3288.class_7680)new DynamicResourcesSupplier(this), (class_3288.class_7679)Services.PLATFORM.createPackInfo(this.metadata.get().method_14423(), this.metadata.get().method_14424()), (class_3264)this.type, (class_3288.class_3289)class_3288.class_3289.field_14280, (boolean)false, (class_5352)class_5352.field_25348);
        }));
    }

    public String toString() {
        return this.method_14409();
    }

    @Nullable
    public class_7367<InputStream> method_14410(String ... strings) {
        return null;
    }

    public class_7367<InputStream> method_14405(@NotNull class_3264 type, @NotNull class_2960 id) {
        if (this.resources.containsKey(id)) {
            return () -> {
                if (this.type == type) {
                    return new ByteArrayInputStream(this.resources.get(id).get());
                }
                throw new IOException(String.format("Tried to access wrong type of resource on %s.", this.name));
            };
        }
        return null;
    }

    public void method_14408(@NotNull class_3264 type, @NotNull String namespace, @NotNull String id, @NotNull class_3262.class_7664 output) {
        if (this.type == type && this.namespaces.contains(namespace)) {
            this.resources.entrySet().stream().filter(resource -> ((class_2960)resource.getKey()).method_12836().equals(namespace) && ((class_2960)resource.getKey()).method_12832().startsWith(id)).forEach(resource -> output.accept((Object)((class_2960)resource.getKey()), () -> new ByteArrayInputStream((byte[])((Supplier)resource.getValue()).get())));
        }
    }

    @NotNull
    public Set<String> method_14406(@NotNull class_3264 packType) {
        return this.namespaces;
    }

    public <T> T method_14407(class_3270<T> serializer) {
        return (T)(serializer.method_14420().equals(class_3272.field_14202.method_14420()) ? this.metadata : null);
    }

    @NotNull
    public String method_14409() {
        return this.name.toString();
    }

    public void close() {
    }

    private void build(class_2960 path, Supplier<byte[]> bytes) {
        this.namespaces.add(path.method_12836());
        this.resources.put(path, (Supplier<byte[]>)Suppliers.memoize(bytes::get));
    }

    protected void build(List<class_2960> paths, Supplier<JsonElement> json) {
        for (class_2960 path : paths) {
            JsonElement element = json.get();
            this.build(DynamicResourceType.GENERAL.getPath(path), () -> {
                try (StringWriter stringWriter = new StringWriter();){
                    byte[] byArray;
                    try (JsonWriter jsonWriter = new JsonWriter((Writer)stringWriter);){
                        jsonWriter.setIndent("  ");
                        Streams.write((JsonElement)element, (JsonWriter)jsonWriter);
                        jsonWriter.close();
                        byArray = stringWriter.toString().getBytes();
                    }
                    return byArray;
                }
                catch (IOException e) {
                    Constants.LOGGER.error("Failed to write JSON {} to resource pack\n{}.", new Object[]{path, this.name, e});
                    return new byte[0];
                }
            });
        }
    }

    protected abstract void build();

    public static class DynamicResourcesSupplier
    implements class_3288.class_7680 {
        private final class_3262 instance;

        DynamicResourcesSupplier(class_3262 instance) {
            this.instance = instance;
        }

        @NotNull
        public class_3262 open(@NotNull String name) {
            return this.instance;
        }
    }
}

