/*
 * Decompiled with CFR 0.152.
 */
package it.crystalnest.cobweb.api.pack;

import com.google.gson.JsonElement;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.crystalnest.cobweb.api.pack.DynamicResourceType;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3495;
import net.minecraft.class_3497;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7475;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public class DynamicTagBuilder<T>
extends class_3495 {
    private final Set<String> keys = new HashSet<String>();
    private final List<class_2960> tags;
    private final class_2378<T> registry;

    private DynamicTagBuilder(class_2378<T> registry, List<class_2960> tags) {
        this.tags = tags;
        this.registry = registry;
    }

    @SafeVarargs
    public static <R> DynamicTagBuilder<R> of(class_2378<R> registry, class_6862<? extends R> ... tags) {
        return new DynamicTagBuilder<R>(registry, Arrays.stream(tags).map(class_6862::comp_327).toList());
    }

    @SafeVarargs
    public static <R> DynamicTagBuilder<R> of(class_5321<? extends class_2378<R>> registryKey, class_6862<? extends R> ... tags) {
        return DynamicTagBuilder.of((class_2378)class_7923.field_41167.method_10223(registryKey.method_29177()), tags);
    }

    public List<class_2960> getTags() {
        return this.tags;
    }

    public List<class_2960> getPaths() {
        return this.getTags().stream().map(tag -> DynamicResourceType.TAG.getPath(new class_2960(tag.method_12836(), this.registry.method_30517().method_29177().method_12832() + "s/" + tag.method_12832()))).toList();
    }

    @NotNull
    public DynamicTagBuilder<T> add(@NotNull class_3497 entry) {
        if (this.keys.add(entry.toString())) {
            return (DynamicTagBuilder)super.method_27064(entry);
        }
        return this;
    }

    public DynamicTagBuilder<T> addTag(class_6862<? extends T> tagKey) {
        return (DynamicTagBuilder)this.method_26787(tagKey.comp_327());
    }

    public DynamicTagBuilder<T> addElement(T element) {
        return (DynamicTagBuilder)this.method_26784(Objects.requireNonNull(this.registry.method_10221(element)));
    }

    public DynamicTagBuilder<T> addElements(Collection<? extends T> elements) {
        for (T element : elements) {
            this.addElement(element);
        }
        return this;
    }

    public DynamicTagBuilder<T> addElements(T ... elements) {
        for (T element : elements) {
            this.addElement(element);
        }
        return this;
    }

    public JsonElement json() {
        return (JsonElement)class_7475.field_39269.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)new class_7475(this.method_26782(), false)).getOrThrow(false, error -> {});
    }
}

