/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable;

import com.mrcrayfish.controllable.Config;
import com.mrcrayfish.controllable.client.ControllerInput;
import com.mrcrayfish.controllable.client.ControllerProperties;
import com.mrcrayfish.controllable.client.InputProcessor;
import com.mrcrayfish.controllable.client.RumbleHandler;
import com.mrcrayfish.controllable.client.input.Controller;
import com.mrcrayfish.controllable.client.input.ControllerManager;
import com.mrcrayfish.controllable.client.settings.InputLibrary;
import com.mrcrayfish.framework.platform.Services;
import java.io.File;
import javax.annotation.Nullable;

public class Controllable {
    private static ControllerManager manager;
    private static File configFolder;
    private static boolean architecturyLoaded;
    private static boolean jeiLoaded;
    private static boolean emiLoaded;
    private static boolean reiLoaded;
    private static RumbleHandler rumbleHandler;

    public static void init() {
        configFolder = Services.CONFIG.getConfigPath().toFile();
        architecturyLoaded = Services.PLATFORM.isModLoaded("architectury");
        jeiLoaded = Services.PLATFORM.isModLoaded("jei");
        emiLoaded = Services.PLATFORM.isModLoaded("emi");
        reiLoaded = Services.PLATFORM.isModLoaded("roughlyenoughitems");
        ControllerProperties.load(configFolder);
        Controllable.getManager().init();
        rumbleHandler = new RumbleHandler();
    }

    public static ControllerInput getInput() {
        return InputProcessor.instance().getInput();
    }

    public static File getConfigFolder() {
        return configFolder;
    }

    public static boolean isArchitecturyLoaded() {
        return architecturyLoaded;
    }

    public static boolean isJeiLoaded() {
        return jeiLoaded && !emiLoaded && !reiLoaded;
    }

    public static boolean isEmiLoaded() {
        return emiLoaded;
    }

    public static boolean isReiLoaded() {
        return reiLoaded;
    }

    public static RumbleHandler getRumbleHandler() {
        return rumbleHandler;
    }

    @Nullable
    public static Controller getController() {
        return Controllable.getManager().getActiveController();
    }

    public static ControllerManager getManager() {
        if (manager == null) {
            manager = ((InputLibrary)((Object)Config.CLIENT.inputLibrary.get())).createManager();
        }
        return manager;
    }
}

