/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client;

import com.mrcrayfish.controllable.Config;
import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.RadialMenuHandler;
import com.mrcrayfish.controllable.client.Thumbstick;
import com.mrcrayfish.controllable.client.binding.ButtonBinding;
import com.mrcrayfish.controllable.client.binding.ButtonBindings;
import com.mrcrayfish.controllable.client.gui.navigation.BasicNavigationPoint;
import com.mrcrayfish.controllable.client.gui.navigation.ListEntryNavigationPoint;
import com.mrcrayfish.controllable.client.gui.navigation.ListWidgetNavigationPoint;
import com.mrcrayfish.controllable.client.gui.navigation.Navigatable;
import com.mrcrayfish.controllable.client.gui.navigation.NavigationPoint;
import com.mrcrayfish.controllable.client.gui.navigation.SkipItem;
import com.mrcrayfish.controllable.client.gui.navigation.SlotNavigationPoint;
import com.mrcrayfish.controllable.client.gui.navigation.WidgetNavigationPoint;
import com.mrcrayfish.controllable.client.gui.screens.ControllerLayoutScreen;
import com.mrcrayfish.controllable.client.gui.screens.SettingsScreen;
import com.mrcrayfish.controllable.client.input.Controller;
import com.mrcrayfish.controllable.client.util.ClientHelper;
import com.mrcrayfish.controllable.client.util.EventHelper;
import com.mrcrayfish.controllable.client.util.ScreenHelper;
import com.mrcrayfish.controllable.event.ControllerEvents;
import com.mrcrayfish.controllable.event.Value;
import com.mrcrayfish.controllable.integration.EmiSupport;
import com.mrcrayfish.controllable.integration.JeiSupport;
import com.mrcrayfish.controllable.integration.ReiSupport;
import com.mrcrayfish.controllable.mixin.client.OverlayRecipeComponentAccessor;
import com.mrcrayfish.controllable.mixin.client.RecipeBookComponentAccessor;
import com.mrcrayfish.controllable.mixin.client.RecipeBookPageAccessor;
import com.mrcrayfish.controllable.platform.ClientServices;
import com.mrcrayfish.framework.api.event.ClientEvents;
import com.mrcrayfish.framework.api.event.IFrameworkEvent;
import com.mrcrayfish.framework.api.event.ScreenEvents;
import com.mrcrayfish.framework.api.event.TickEvents;
import com.mrcrayfish.framework.event.IClientEvent;
import com.mrcrayfish.framework.event.IScreenEvent;
import com.mrcrayfish.framework.event.ITickEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.class_1041;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1690;
import net.minecraft.class_1726;
import net.minecraft.class_1729;
import net.minecraft.class_1735;
import net.minecraft.class_1890;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2596;
import net.minecraft.class_276;
import net.minecraft.class_2846;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_318;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_344;
import net.minecraft.class_350;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_3673;
import net.minecraft.class_3971;
import net.minecraft.class_3979;
import net.minecraft.class_4069;
import net.minecraft.class_4185;
import net.minecraft.class_433;
import net.minecraft.class_437;
import net.minecraft.class_457;
import net.minecraft.class_465;
import net.minecraft.class_481;
import net.minecraft.class_486;
import net.minecraft.class_490;
import net.minecraft.class_492;
import net.minecraft.class_494;
import net.minecraft.class_507;
import net.minecraft.class_508;
import net.minecraft.class_512;
import net.minecraft.class_513;
import net.minecraft.class_514;
import net.minecraft.class_518;
import net.minecraft.class_5498;
import net.minecraft.class_6880;
import net.minecraft.class_744;
import net.minecraft.class_746;
import net.minecraft.class_8089;
import net.minecraft.class_8209;
import org.joml.Vector3d;
import org.lwjgl.glfw.GLFW;

public class ControllerInput {
    private static final class_2960 RECIPE_BUTTON_LOCATION = new class_2960("textures/gui/recipe_button.png");
    private int lastUse = 0;
    private boolean keyboardSneaking = false;
    private boolean sneaking = false;
    private boolean isFlying = false;
    private class_1735 nearSlot = null;
    private boolean moving = false;
    private boolean preventReset;
    private boolean ignoreInput;
    private boolean hideVirtualCursor;
    private double virtualCursorX;
    private double virtualCursorY;
    private int prevCursorX;
    private int prevCursorY;
    private int cursorX;
    private int cursorY;
    private double cursorSpeedX;
    private double cursorSpeedY;
    private boolean moved;
    private boolean snapToSlot;
    private float targetPitch;
    private float targetYaw;
    private long lastMerchantScroll;
    private int dropCounter = -1;

    public ControllerInput() {
        TickEvents.START_CLIENT.register((IFrameworkEvent)((ITickEvent.StartClient)this::onClientTick));
        TickEvents.START_CLIENT.register((IFrameworkEvent)((ITickEvent.StartClient)this::onClientTickStart));
        TickEvents.END_RENDER.register((IFrameworkEvent)((ITickEvent.EndRender)this::onRenderTickEnd));
        ScreenEvents.OPENED.register((IFrameworkEvent)((IScreenEvent.Opened)this::onScreenOpened));
        ScreenEvents.BEFORE_DRAW.register((IFrameworkEvent)((IScreenEvent.BeforeDraw)this::onScreenRenderPre));
        ClientEvents.PLAYER_INPUT_UPDATE.register((IFrameworkEvent)((IClientEvent.PlayerInputUpdate)this::onInputUpdate));
    }

    public double getVirtualCursorX() {
        return this.virtualCursorX;
    }

    public double getVirtualCursorY() {
        return this.virtualCursorY;
    }

    public double getScaledCursorX() {
        class_1041 window = class_310.method_1551().method_22683();
        return this.virtualCursorX * (double)window.method_4486() / (double)window.method_4489();
    }

    public double getScaledCursorY() {
        class_1041 window = class_310.method_1551().method_22683();
        return this.virtualCursorY * (double)window.method_4502() / (double)window.method_4506();
    }

    public boolean isVirtualCursorActive() {
        return Controllable.getController() != null && this.lastUse > 0 && (Boolean)Config.CLIENT.client.options.virtualCursor.get() != false;
    }

    private void setControllerInUse() {
        this.lastUse = 100;
    }

    public boolean isControllerInUse() {
        return this.lastUse > 0;
    }

    public int getLastUse() {
        return this.lastUse;
    }

    public void resetLastUse() {
        if (!this.preventReset) {
            this.lastUse = 0;
        }
        this.preventReset = false;
    }

    public boolean isMovingCursor() {
        return this.moving;
    }

    public boolean isVirtualCursorHidden() {
        return this.hideVirtualCursor;
    }

    public double getVirtualCursorX(float partialTick) {
        return (float)this.prevCursorX + (float)(this.cursorX - this.prevCursorX) * partialTick;
    }

    public double getVirtualCursorY(float partialTick) {
        return (float)this.prevCursorY + (float)(this.cursorY - this.prevCursorY) * partialTick;
    }

    public class_1735 getNearSlot() {
        return this.nearSlot;
    }

    private void onClientTick() {
        Controller controller;
        this.prevCursorX = this.cursorX;
        this.prevCursorY = this.cursorY;
        this.cursorSpeedX = 0.0;
        this.cursorSpeedY = 0.0;
        if (this.lastUse > 0) {
            --this.lastUse;
        }
        if ((controller = Controllable.getController()) == null) {
            return;
        }
        if ((Math.abs(controller.getLTriggerValue()) > 0.0f || Math.abs(controller.getRTriggerValue()) > 0.0f) && !(class_310.method_1551().field_1755 instanceof ControllerLayoutScreen)) {
            this.setControllerInUse();
        }
        class_310 mc = class_310.method_1551();
        if (mc.field_1755 == null || mc.field_1755 instanceof ControllerLayoutScreen) {
            return;
        }
        float threshold = 0.35f;
        boolean lastMoving = this.moving;
        float inputX = Config.CLIENT.client.options.cursorThumbstick.get() == Thumbstick.LEFT ? controller.getLThumbStickXValue() : controller.getRThumbStickXValue();
        float inputY = Config.CLIENT.client.options.cursorThumbstick.get() == Thumbstick.LEFT ? controller.getLThumbStickYValue() : controller.getRThumbStickYValue();
        boolean bl = this.moving = Math.abs(inputX) >= threshold || Math.abs(inputY) >= threshold;
        if (this.moving) {
            if (!lastMoving) {
                double cursorX = mc.field_1729.method_1603();
                double cursorY = mc.field_1729.method_1604();
                if (Controllable.getController() != null && ((Boolean)Config.CLIENT.client.options.virtualCursor.get()).booleanValue()) {
                    cursorX = this.virtualCursorX;
                    cursorY = this.virtualCursorY;
                }
                this.prevCursorX = this.cursorX = (int)cursorX;
                this.prevCursorY = this.cursorY = (int)cursorY;
            }
            this.cursorSpeedX = Math.abs(inputX) >= threshold ? (double)ClientHelper.applyDeadzone(inputX, threshold) : 0.0;
            this.cursorSpeedY = Math.abs(inputY) >= threshold ? (double)ClientHelper.applyDeadzone(inputY, threshold) : 0.0;
            this.setControllerInUse();
        }
        if (this.lastUse <= 0) {
            return;
        }
        if (Math.abs(this.cursorSpeedX) > 0.0 || Math.abs(this.cursorSpeedY) > 0.0) {
            class_364 hoveredListener;
            class_507 recipeBook;
            class_465 screen;
            double cursorSpeed = (Double)Config.CLIENT.client.options.cursorSpeed.get() * mc.method_22683().method_4495();
            class_437 class_4372 = mc.field_1755;
            if (class_4372 instanceof class_465 && ClientServices.CLIENT.getSlotUnderMouse(screen = (class_465)class_4372) != null) {
                cursorSpeed *= ((Double)Config.CLIENT.client.options.hoverModifier.get()).doubleValue();
            }
            double cursorX = this.virtualCursorX * (double)mc.method_22683().method_4486() / (double)mc.method_22683().method_4489();
            double cursorY = this.virtualCursorY * (double)mc.method_22683().method_4502() / (double)mc.method_22683().method_4506();
            ArrayList<Object> eventListeners = new ArrayList<Object>(mc.field_1755.method_25396());
            if (mc.field_1755 instanceof class_518 && (recipeBook = ((class_518)mc.field_1755).method_2659()).method_2605()) {
                eventListeners.add(((RecipeBookComponentAccessor)recipeBook).controllableGetFilterButton());
                eventListeners.addAll(((RecipeBookComponentAccessor)recipeBook).controllableGetRecipeTabs());
                class_513 recipeBookPage = ((RecipeBookComponentAccessor)recipeBook).controllableGetRecipeBookPage();
                eventListeners.addAll(((RecipeBookPageAccessor)recipeBookPage).controllableGetButtons());
                eventListeners.add(((RecipeBookPageAccessor)recipeBookPage).controllableGetForwardButton());
                eventListeners.add(((RecipeBookPageAccessor)recipeBookPage).controllableGetBackButton());
            }
            if ((hoveredListener = (class_364)eventListeners.stream().filter(o -> o != null && o.method_25405(cursorX, cursorY)).findFirst().orElse(null)) instanceof class_350) {
                class_350 list = (class_350)hoveredListener;
                hoveredListener = null;
                int count = list.method_25396().size();
                for (int i = 0; i < count; ++i) {
                    class_4069 handler;
                    class_364 hovered;
                    Object entry;
                    int rowTop = ClientServices.CLIENT.getAbstractListRowTop(list, i);
                    int rowBottom = ClientServices.CLIENT.getAbstractListRowBottom(list, i);
                    int listTop = ClientServices.CLIENT.getAbstractListTop(list);
                    int listBottom = ClientServices.CLIENT.getAbstractListBottom(list);
                    if (rowTop < listTop && rowBottom > listBottom || !((entry = list.method_25396().get(i)) instanceof class_4069) || (hovered = (class_364)(handler = (class_4069)entry).method_25396().stream().filter(o -> o != null && o.method_25405(cursorX, cursorY)).findFirst().orElse(null)) == null) continue;
                    hoveredListener = hovered;
                    break;
                }
            }
            if (hoveredListener != null) {
                cursorSpeed *= ((Double)Config.CLIENT.client.options.hoverModifier.get()).doubleValue();
            }
            this.cursorX = (int)((double)this.cursorX + cursorSpeed * this.cursorSpeedX);
            this.cursorY = (int)((double)this.cursorY + cursorSpeed * this.cursorSpeedY);
            this.clampCursorToWindowBounds();
            this.setControllerInUse();
            this.moved = true;
            this.snapToSlot = true;
            this.hideVirtualCursor = false;
        } else if (this.snapToSlot) {
            this.snapToContainerSlot();
            this.snapToSlot = false;
        }
        if (mc.field_1755 instanceof class_481) {
            this.handleCreativeScrolling((class_481)mc.field_1755, controller);
        }
        if (((Boolean)Config.CLIENT.client.options.virtualCursor.get()).booleanValue() && (this.cursorX != this.prevCursorX || this.cursorY != this.prevCursorY)) {
            this.performMouseDrag(this.virtualCursorX, this.virtualCursorY, this.cursorX - this.prevCursorX, this.cursorY - this.prevCursorY);
        }
    }

    private void onScreenOpened(class_437 screen) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1755 == null) {
            this.nearSlot = null;
            this.moved = false;
            this.cursorSpeedX = 0.0;
            this.cursorSpeedY = 0.0;
            this.cursorX = this.prevCursorX = (int)((float)mc.method_22683().method_4489() / 2.0f);
            this.virtualCursorX = this.prevCursorX;
            this.cursorY = this.prevCursorY = (int)((float)mc.method_22683().method_4506() / 2.0f);
            this.virtualCursorY = this.prevCursorY;
        }
        this.hideVirtualCursor = false;
    }

    private void onScreenRenderPre(class_437 screen, class_332 graphics, int mouseX, int mouseY, float partialTick) {
        class_310 mc = class_310.method_1551();
        if (!(mc.field_1755 == null || this.cursorX == this.prevCursorX && this.cursorY == this.prevCursorY || mc.field_1755 instanceof ControllerLayoutScreen)) {
            float partialTicks = class_310.method_1551().method_1488();
            double renderCursorX = (double)((float)this.prevCursorX + (float)(this.cursorX - this.prevCursorX) * partialTicks) + 0.5;
            double renderCursorY = (double)((float)this.prevCursorY + (float)(this.cursorY - this.prevCursorY) * partialTicks) + 0.5;
            this.setCursorPosition(renderCursorX, renderCursorY);
        }
        this.nearSlot = null;
        class_437 renderCursorX = mc.field_1755;
        if (renderCursorX instanceof class_465) {
            class_465 containerScreen = (class_465)renderCursorX;
            if (this.moved) {
                int guiLeft = ClientServices.CLIENT.getScreenLeft(containerScreen);
                int guiTop = ClientServices.CLIENT.getScreenTop(containerScreen);
                double guiScale = mc.method_22683().method_4495();
                int cursorX = (int)((double)this.cursorX / guiScale);
                int cursorY = (int)((double)this.cursorY / guiScale);
                class_1735 closestSlot = null;
                double closestDistance = -1.0;
                for (class_1735 slot : containerScreen.method_17577().field_7761) {
                    int posX = guiLeft + slot.field_7873 + 8;
                    int posY = guiTop + slot.field_7872 + 8;
                    double distance = Math.sqrt(Math.pow(posX - cursorX, 2.0) + Math.pow(posY - cursorY, 2.0));
                    if (closestDistance != -1.0 && !(distance < closestDistance) || !(distance <= 14.0)) continue;
                    closestSlot = slot;
                    closestDistance = distance;
                }
                if (closestSlot != null && (closestSlot.method_7681() || !containerScreen.method_17577().method_34255().method_7960())) {
                    this.nearSlot = closestSlot;
                }
            }
        }
    }

    private void performMouseDrag(double cursorX, double cursorY, double dragX, double dragY) {
        if (Controllable.getController() != null) {
            class_310 mc = class_310.method_1551();
            class_437 screen = mc.field_1755;
            if (screen != null && mc.method_18506() == null) {
                double finalCursorX = cursorX * (double)mc.method_22683().method_4486() / (double)mc.method_22683().method_4489();
                double finalCursorY = cursorY * (double)mc.method_22683().method_4502() / (double)mc.method_22683().method_4506();
                class_437.method_25412(() -> screen.method_16014(finalCursorX, finalCursorY), (String)"mouseMoved event handler", (String)screen.getClass().getCanonicalName());
                int activeMouseButton = ClientServices.CLIENT.getActiveMouseButton();
                double lastMouseEventTime = ClientServices.CLIENT.getLastMouseEventTime();
                if (activeMouseButton != -1 && lastMouseEventTime > 0.0) {
                    if (screen instanceof class_465 && Controllable.isEmiLoaded() && EmiSupport.invokeMouseDragged(activeMouseButton, finalCursorX, finalCursorY, dragX, dragY)) {
                        return;
                    }
                    ClientServices.CLIENT.sendMouseDrag(screen, dragX, dragY, finalCursorX, finalCursorY, activeMouseButton);
                }
            }
        }
    }

    private void onRenderTickEnd(float partialTick) {
        class_746 player;
        Controller controller = Controllable.getController();
        if (controller == null) {
            return;
        }
        class_310 mc = class_310.method_1551();
        double cursorX = this.virtualCursorX * (double)mc.method_22683().method_4486() / (double)mc.method_22683().method_4489();
        double cursorY = this.virtualCursorY * (double)mc.method_22683().method_4502() / (double)mc.method_22683().method_4506();
        if (mc.field_1755 != null && this.lastUse > 0) {
            class_364 hoveredListener;
            float yValue;
            class_437 class_4372 = mc.field_1755;
            if (class_4372 instanceof class_492) {
                class_492 screen = (class_492)class_4372;
                this.handleMerchantScrolling(screen, controller);
                return;
            }
            float f = yValue = Config.CLIENT.client.options.cursorThumbstick.get() == Thumbstick.LEFT ? controller.getRThumbStickYValue() : controller.getLThumbStickYValue();
            if (Math.abs(yValue) >= 0.2f && (hoveredListener = (class_364)ScreenHelper.findHoveredListener(mc.field_1755, cursorX, cursorY, listener -> listener instanceof class_350).orElse(null)) instanceof class_350) {
                class_350 selectionList = (class_350)hoveredListener;
                this.handleListScrolling(selectionList, controller);
            }
        }
        if ((player = mc.field_1724) == null) {
            return;
        }
        if (mc.field_1755 == null && (this.targetYaw != 0.0f || this.targetPitch != 0.0f)) {
            float elapsedTicks = class_310.method_1551().method_1534();
            if (!RadialMenuHandler.instance().isVisible()) {
                player.method_5872((double)this.targetYaw / 0.15 * (double)((Boolean)Config.CLIENT.client.options.invertRotation.get() != false ? -1 : 1) * (double)elapsedTicks, (double)this.targetPitch / 0.15 * (double)((Boolean)Config.CLIENT.client.options.invertLook.get() != false ? -1 : 1) * (double)elapsedTicks);
            }
            if (player.method_5854() != null) {
                player.method_5854().method_5644((class_1297)player);
            }
        }
    }

    private void onClientTickStart() {
        this.targetYaw = 0.0f;
        this.targetPitch = 0.0f;
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        if (player == null) {
            return;
        }
        Controller controller = Controllable.getController();
        if (controller == null) {
            return;
        }
        if (mc.field_1755 == null) {
            boolean canMoveVertically;
            float inputX = controller.getRThumbStickXValue();
            float inputY = controller.getRThumbStickYValue();
            boolean canMoveHorizontally = Math.abs(inputX) > 0.0f;
            boolean bl = canMoveVertically = Math.abs(inputY) > 0.0f;
            if (canMoveHorizontally || canMoveVertically) {
                Value<Float> pitchSpeed;
                float spyglassSensitivity;
                float pitchSensitivity = ((Double)Config.CLIENT.client.options.pitchSensitivity.get()).floatValue();
                float yawSensitivity = ((Double)Config.CLIENT.client.options.yawSensitivity.get()).floatValue();
                float rotationSpeed = ((Double)Config.CLIENT.client.options.rotationSpeed.get()).floatValue();
                Value<Float> yawSpeed = new Value<Float>(Float.valueOf(rotationSpeed * yawSensitivity * (spyglassSensitivity = player.method_31550() ? ((Double)Config.CLIENT.client.options.spyglassSensitivity.get()).floatValue() : 1.0f)));
                if (!EventHelper.postUpdateCameraEvent(yawSpeed, pitchSpeed = new Value<Float>(Float.valueOf(rotationSpeed * pitchSensitivity * spyglassSensitivity)))) {
                    if (canMoveHorizontally) {
                        this.targetYaw = yawSpeed.get().floatValue() * inputX * 0.33f;
                    }
                    if (canMoveVertically) {
                        this.targetPitch = pitchSpeed.get().floatValue() * inputY * 0.33f;
                    }
                }
                this.setControllerInUse();
            }
        }
        if (mc.field_1755 == null && ButtonBindings.DROP_ITEM.isButtonDown()) {
            this.setControllerInUse();
            ++this.dropCounter;
        }
        if (this.dropCounter > 20) {
            if (!mc.field_1724.method_7325()) {
                mc.field_1724.method_7290(true);
            }
            this.dropCounter = 0;
        } else if (this.dropCounter > 0 && !ButtonBindings.DROP_ITEM.isButtonDown()) {
            if (!mc.field_1724.method_7325()) {
                mc.field_1724.method_7290(false);
            }
            this.dropCounter = 0;
        }
    }

    private void onInputUpdate(class_1657 p, class_744 input) {
        class_746 player = (class_746)p;
        if (player == null) {
            return;
        }
        Controller controller = Controllable.getController();
        if (controller == null) {
            return;
        }
        class_310 mc = class_310.method_1551();
        if (this.keyboardSneaking && !mc.field_1690.field_1832.method_1434()) {
            this.sneaking = false;
            this.keyboardSneaking = false;
        }
        if (!((Boolean)mc.field_1690.method_42449().method_41753()).booleanValue()) {
            this.sneaking = ButtonBindings.SNEAK.isButtonDown();
        }
        if (mc.field_1690.field_1832.method_1434()) {
            this.sneaking = true;
            this.keyboardSneaking = true;
        }
        if (player.method_31549().field_7479 || player.method_5765()) {
            this.sneaking = mc.field_1690.field_1832.method_1434();
            this.sneaking |= ButtonBindings.SNEAK.isButtonDown();
            if (ButtonBindings.SNEAK.isButtonDown()) {
                this.setControllerInUse();
            }
            this.isFlying = true;
        } else if (this.isFlying) {
            this.isFlying = false;
        }
        input.field_3903 = this.sneaking;
        if (mc.field_1755 == null) {
            if (!(RadialMenuHandler.instance().isVisible() && Config.CLIENT.client.options.radialThumbstick.get() == Thumbstick.LEFT || EventHelper.postMoveEvent())) {
                float threshold;
                float sneakBonus = player.method_20303() ? class_3532.method_15363((float)(0.3f + class_1890.method_42304((class_1309)player)), (float)0.0f, (float)1.0f) : 1.0f;
                float inputX = controller.getLThumbStickXValue();
                float inputY = controller.getLThumbStickYValue();
                if (Math.abs(inputY) > 0.0f) {
                    input.field_3910 = inputY < 0.0f;
                    input.field_3909 = inputY > 0.0f;
                    input.field_3905 = -inputY;
                    input.field_3905 *= sneakBonus;
                    this.setControllerInUse();
                }
                float f = threshold = player.method_5854() instanceof class_1690 ? 0.5f : 0.0f;
                if (Math.abs(inputX) > threshold) {
                    input.field_3906 = inputX > 0.0f;
                    input.field_3908 = inputX < 0.0f;
                    input.field_3907 = -inputX;
                    input.field_3907 *= sneakBonus;
                    this.setControllerInUse();
                }
            }
            if (this.ignoreInput && !ButtonBindings.JUMP.isButtonDown()) {
                this.ignoreInput = false;
            }
            if (ButtonBindings.JUMP.isButtonDown() && !this.ignoreInput) {
                input.field_3904 = true;
            }
        }
        int rightClickDelay = ClientServices.CLIENT.getRightClickDelay(mc);
        if (ButtonBindings.USE_ITEM.isButtonDown() && rightClickDelay == 0 && !player.method_6115()) {
            ClientServices.CLIENT.startUseItem(mc);
        }
    }

    public void handleButtonInput(Controller controller, int button, boolean state, boolean virtual) {
        if (controller == null) {
            return;
        }
        this.setControllerInUse();
        if (button != -1) {
            Value<Integer> newButton = new Value<Integer>(button);
            if (EventHelper.postInputEvent(controller, newButton, button, state)) {
                return;
            }
            button = newButton.get();
            ButtonBinding.setButtonState(button, state);
        }
        if (EventHelper.postButtonEvent(controller)) {
            return;
        }
        class_310 mc = class_310.method_1551();
        if (state) {
            if (ButtonBindings.FULLSCREEN.isButtonPressed()) {
                mc.method_22683().method_4500();
                mc.field_1690.method_42447().method_41748((Object)mc.method_22683().method_4498());
                mc.field_1690.method_1640();
            } else if (ButtonBindings.SCREENSHOT.isButtonPressed()) {
                if (mc.field_1687 != null) {
                    class_318.method_1659((File)mc.field_1697, (class_276)mc.method_1522(), component -> mc.execute(() -> mc.field_1705.method_1743().method_1812(component)));
                }
            } else if (mc.field_1755 == null) {
                if (ButtonBindings.OPEN_INVENTORY.isButtonPressed() && mc.field_1761 != null && mc.field_1724 != null) {
                    if (mc.field_1761.method_2895()) {
                        mc.field_1724.method_3132();
                    } else {
                        mc.method_1577().method_4912();
                        mc.method_1507((class_437)new class_490((class_1657)mc.field_1724));
                    }
                } else if (ButtonBindings.SPRINT.isButtonPressed()) {
                    if (mc.field_1724 != null) {
                        boolean hasRequiredFood;
                        class_746 player = mc.field_1724;
                        boolean canSprint = !player.method_5624() && !player.method_6059(class_1294.field_5919);
                        boolean bl = hasRequiredFood = (float)player.method_7344().method_7586() > 6.0f || player.method_31549().field_7478;
                        boolean hasImpulse = player.method_5869() ? player.field_3913.method_20622() : (double)player.field_3913.field_3905 >= 0.8;
                        boolean canSwimInFluid = ClientServices.CLIENT.canLocalPlayerSwimInFluid(player);
                        boolean usingItem = player.method_6115();
                        if (canSprint && canSwimInFluid && hasImpulse && hasRequiredFood && !usingItem) {
                            player.method_5728(true);
                        }
                    }
                } else if (ButtonBindings.SNEAK.isButtonPressed()) {
                    if (mc.field_1724 != null && !mc.field_1724.method_31549().field_7479 && !this.isFlying && !mc.field_1724.method_5765() && ((Boolean)mc.field_1690.method_42449().method_41753()).booleanValue()) {
                        boolean bl = this.sneaking = !this.sneaking;
                        if (!this.sneaking && mc.field_1690.field_1832.method_1434()) {
                            this.keyboardSneaking = false;
                            mc.field_1690.field_1832.method_23481(true);
                        } else if (this.sneaking && !mc.field_1690.field_1832.method_1434()) {
                            this.keyboardSneaking = true;
                            mc.field_1690.field_1832.method_23481(true);
                        }
                    }
                } else if (ButtonBindings.SCROLL_RIGHT.isButtonPressed()) {
                    if (mc.field_1724 != null) {
                        mc.field_1724.method_31548().method_7373(-1.0);
                    }
                } else if (ButtonBindings.SCROLL_LEFT.isButtonPressed()) {
                    if (mc.field_1724 != null) {
                        mc.field_1724.method_31548().method_7373(1.0);
                    }
                } else if (ButtonBindings.SWAP_HANDS.isButtonPressed()) {
                    if (mc.field_1724 != null && !mc.field_1724.method_7325() && mc.method_1562() != null) {
                        mc.method_1562().method_2883((class_2596)new class_2846(class_2846.class_2847.field_12969, class_2338.field_10980, class_2350.field_11033));
                    }
                } else if (ButtonBindings.TOGGLE_PERSPECTIVE.isButtonPressed()) {
                    this.cycleThirdPersonView();
                } else if (ButtonBindings.PAUSE_GAME.isButtonPressed()) {
                    if (mc.field_1724 != null) {
                        mc.method_20539(false);
                    }
                } else if (ButtonBindings.ADVANCEMENTS.isButtonPressed()) {
                    if (mc.field_1724 != null) {
                        mc.method_1507((class_437)new class_457(mc.field_1724.field_3944.method_2869()));
                    }
                } else if (ButtonBindings.CINEMATIC_CAMERA.isButtonPressed()) {
                    if (mc.field_1724 != null) {
                        mc.field_1690.field_1914 = !mc.field_1690.field_1914;
                    }
                } else if (ButtonBindings.DEBUG_INFO.isButtonPressed()) {
                    mc.field_1690.field_1866 = !mc.field_1690.field_1866;
                } else if (ButtonBindings.RADIAL_MENU.isButtonPressed() && !virtual) {
                    RadialMenuHandler.instance().interact();
                } else if (mc.field_1724 != null) {
                    if (ButtonBindings.OPEN_CONTROLLABLE_SETTINGS.isButtonPressed()) {
                        mc.method_1507((class_437)new SettingsScreen(null, 1));
                        return;
                    }
                    if (ButtonBindings.OPEN_CHAT.isButtonPressed()) {
                        ClientServices.CLIENT.openChatScreen("");
                        return;
                    }
                    for (int i = 0; i < 9; ++i) {
                        if (!ButtonBindings.HOTBAR_SLOTS[i].isButtonPressed()) continue;
                        mc.field_1724.method_31548().field_7545 = i;
                        return;
                    }
                    if (!mc.field_1724.method_6115()) {
                        if (ButtonBindings.ATTACK.isButtonPressed()) {
                            ClientServices.CLIENT.startAttack(mc);
                        } else if (ButtonBindings.PICK_BLOCK.isButtonPressed()) {
                            ClientServices.CLIENT.pickBlock(mc);
                        }
                    }
                }
            } else if (ButtonBindings.CLOSE_INVENTORY.isButtonPressed()) {
                if (mc.field_1755 != null) {
                    mc.field_1755.method_25404(256, GLFW.glfwGetKeyScancode((int)256), 0);
                }
            } else if (ButtonBindings.PREVIOUS_CREATIVE_TAB.isButtonPressed()) {
                if (mc.field_1755.method_25396().stream().anyMatch(listener -> listener instanceof class_8089)) {
                    this.navigateTabBar(mc.field_1755, 1);
                } else if (mc.field_1755 instanceof class_481) {
                    this.scrollCreativeTabs((class_481)mc.field_1755, 1);
                    class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
                } else {
                    class_437 canSprint = mc.field_1755;
                    if (canSprint instanceof class_518) {
                        class_518 listener2 = (class_518)canSprint;
                        this.scrollRecipePage(listener2.method_2659(), 1);
                    }
                }
            } else if (ButtonBindings.NEXT_CREATIVE_TAB.isButtonPressed()) {
                if (mc.field_1755.method_25396().stream().anyMatch(listener -> listener instanceof class_8089)) {
                    this.navigateTabBar(mc.field_1755, -1);
                } else if (mc.field_1755 instanceof class_481) {
                    this.scrollCreativeTabs((class_481)mc.field_1755, -1);
                    class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
                } else {
                    class_437 canSprint = mc.field_1755;
                    if (canSprint instanceof class_518) {
                        class_518 listener3 = (class_518)canSprint;
                        this.scrollRecipePage(listener3.method_2659(), -1);
                    }
                }
            } else if (ButtonBindings.NEXT_RECIPE_TAB.isButtonPressed()) {
                class_437 canSprint = mc.field_1755;
                if (canSprint instanceof class_518) {
                    class_518 listener4 = (class_518)canSprint;
                    this.scrollRecipeTab(listener4.method_2659(), -1);
                }
            } else if (ButtonBindings.PREVIOUS_RECIPE_TAB.isButtonPressed()) {
                class_437 canSprint = mc.field_1755;
                if (canSprint instanceof class_518) {
                    class_518 listener5 = (class_518)canSprint;
                    this.scrollRecipeTab(listener5.method_2659(), 1);
                }
            } else if (ButtonBindings.TOGGLE_CRAFT_BOOK.isButtonPressed()) {
                class_437 canSprint = mc.field_1755;
                if (canSprint instanceof class_518) {
                    class_518 listener6 = (class_518)canSprint;
                    ClientServices.CLIENT.getScreenRenderables(mc.field_1755).stream().filter(widget -> {
                        class_344 btn;
                        return widget instanceof class_344 && RECIPE_BUTTON_LOCATION.equals((Object)ClientServices.CLIENT.getImageButtonResource(btn = (class_344)widget));
                    }).findFirst().ifPresent(btn -> ((class_4185)btn).method_25306());
                    boolean visible = listener6.method_2659().method_2605();
                    class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)(visible ? 1.0f : 0.95f)));
                }
            } else if (ButtonBindings.PAUSE_GAME.isButtonPressed()) {
                if (mc.field_1755 instanceof class_433) {
                    mc.method_1507(null);
                }
            } else if (ButtonBindings.NAVIGATE_UP.isButtonPressed()) {
                this.navigateCursor(mc.field_1755, Navigate.UP);
            } else if (ButtonBindings.NAVIGATE_DOWN.isButtonPressed()) {
                this.navigateCursor(mc.field_1755, Navigate.DOWN);
            } else if (ButtonBindings.NAVIGATE_LEFT.isButtonPressed()) {
                this.navigateCursor(mc.field_1755, Navigate.LEFT);
            } else if (ButtonBindings.NAVIGATE_RIGHT.isButtonPressed()) {
                this.navigateCursor(mc.field_1755, Navigate.RIGHT);
            } else if (button == ButtonBindings.PICKUP_ITEM.getButton()) {
                this.invokeMouseClick(mc.field_1755, 0);
                if (mc.field_1755 == null) {
                    this.ignoreInput = true;
                }
                if (((Boolean)Config.CLIENT.client.options.quickCraft.get()).booleanValue()) {
                    this.craftRecipeBookItem();
                }
            } else if (button == ButtonBindings.SPLIT_STACK.getButton()) {
                this.invokeMouseClick(mc.field_1755, 1);
            } else if (button == ButtonBindings.QUICK_MOVE.getButton() && mc.field_1724 != null) {
                if (mc.field_1724.field_7498.method_34255().method_7960()) {
                    this.invokeMouseClick(mc.field_1755, 0);
                } else {
                    this.invokeMouseReleased(mc.field_1755, 1);
                }
            }
        } else if (mc.field_1755 != null) {
            if (button == ButtonBindings.PICKUP_ITEM.getButton()) {
                this.invokeMouseReleased(mc.field_1755, 0);
            } else if (button == ButtonBindings.SPLIT_STACK.getButton()) {
                this.invokeMouseReleased(mc.field_1755, 1);
            }
        }
    }

    private void cycleThirdPersonView() {
        class_310 mc = class_310.method_1551();
        class_5498 cameraType = mc.field_1690.method_31044();
        mc.field_1690.method_31043(cameraType.method_31036());
        if (cameraType.method_31034() != mc.field_1690.method_31044().method_31034()) {
            mc.field_1773.method_3167(mc.field_1690.method_31044().method_31034() ? mc.method_1560() : null);
        }
    }

    private void scrollCreativeTabs(class_481 screen, int dir) {
        this.setControllerInUse();
        ClientServices.CLIENT.scrollCreativeTabs(screen, dir);
    }

    private void scrollRecipeTab(class_507 recipeBook, int dir) {
        if (!recipeBook.method_2605()) {
            return;
        }
        RecipeBookComponentAccessor recipeBookMixin = (RecipeBookComponentAccessor)recipeBook;
        class_512 currentTab = recipeBookMixin.controllableGetCurrentTab();
        List<class_512> tabs = recipeBookMixin.controllableGetRecipeTabs();
        int currentTabIndex = tabs.indexOf(currentTab);
        class_512 newTab = null;
        if (dir > 0) {
            for (int i = currentTabIndex + 1; i < tabs.size(); ++i) {
                if (!tabs.get((int)i).field_22764) continue;
                newTab = tabs.get(i);
                break;
            }
        } else {
            for (int i = currentTabIndex - 1; i >= 0; --i) {
                if (!tabs.get((int)i).field_22764) continue;
                newTab = tabs.get(i);
                break;
            }
        }
        if (newTab != null) {
            currentTab.method_1964(false);
            recipeBookMixin.controllableSetCurrentTab(newTab);
            newTab.method_1964(true);
            recipeBookMixin.controllableUpdateCollections(true);
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
        }
    }

    private void scrollRecipePage(class_507 recipeBook, int dir) {
        if (!recipeBook.method_2605()) {
            return;
        }
        RecipeBookPageAccessor page = (RecipeBookPageAccessor)((RecipeBookComponentAccessor)recipeBook).controllableGetRecipeBookPage();
        if (dir > 0 && page.controllableGetForwardButton().field_22764 || dir < 0 && page.controllableGetBackButton().field_22764) {
            int currentPage = page.controllableGetCurrentPage();
            page.controllableSetCurrentPage(currentPage + dir);
            page.controllableUpdateButtonsForPage();
            class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15015, (float)1.0f));
        }
    }

    private void navigateTabBar(class_437 screen, int dir) {
        class_8089 bar = screen.method_25396().stream().filter(listener -> listener instanceof class_8089).map(listener -> (class_8089)listener).findFirst().orElse(null);
        if (bar != null) {
            int newIndex;
            ArrayList buttons = new ArrayList();
            bar.method_25396().forEach(listener -> {
                if (listener instanceof class_8209) {
                    class_8209 button = (class_8209)listener;
                    buttons.add(button);
                }
            });
            int selectedIndex = buttons.stream().filter(class_8209::method_49611).map(buttons::indexOf).findFirst().orElse(-1);
            if (selectedIndex != -1 && (newIndex = selectedIndex + dir) >= 0 && newIndex < buttons.size()) {
                bar.method_48987(newIndex, true);
            }
        }
    }

    private void navigateCursor(class_437 screen, Navigate navigate) {
        class_310 mc = class_310.method_1551();
        int cursorX = (int)((double)this.cursorX * (double)mc.method_22683().method_4486() / (double)mc.method_22683().method_4489());
        int cursorY = (int)((double)this.cursorY * (double)mc.method_22683().method_4502() / (double)mc.method_22683().method_4506());
        List<NavigationPoint> points = this.gatherNavigationPoints(screen, navigate, cursorX, cursorY);
        ((ControllerEvents.GatherNavigationPoints)ControllerEvents.GATHER_NAVIGATION_POINTS.post()).handle(points);
        points.removeIf(p -> !navigate.getPredicate().test((NavigationPoint)p, cursorX, cursorY));
        if (points.isEmpty()) {
            return;
        }
        Vector3d cursorVec = new Vector3d((double)cursorX, (double)cursorY, 0.0);
        Optional<NavigationPoint> minimumPointOptional = points.stream().min(navigate.getMinComparator(cursorX, cursorY));
        if (minimumPointOptional.isEmpty()) {
            return;
        }
        double maxOffset = 18.0;
        double minimumDelta = navigate.getKeyExtractor().apply(minimumPointOptional.get(), cursorVec) + maxOffset;
        Optional<NavigationPoint> targetPointOptional = points.stream().filter(point -> navigate.getKeyExtractor().apply((NavigationPoint)point, cursorVec) <= minimumDelta).min(Comparator.comparing(p -> p.distanceTo(cursorX, cursorY)));
        if (targetPointOptional.isPresent()) {
            NavigationPoint targetPoint = targetPointOptional.get();
            targetPoint.onNavigate();
            mc.method_18858(() -> {
                this.performMouseDrag(this.cursorX, this.cursorY, 0.0, 0.0);
                double guiScale = mc.method_22683().method_4495();
                int screenX = (int)(targetPoint.getX() * guiScale);
                int screenY = (int)(targetPoint.getY() * guiScale);
                double lastTargetX = this.cursorX;
                double lastTargetY = this.cursorY;
                this.cursorX = this.prevCursorX = screenX;
                this.cursorY = this.prevCursorY = screenY;
                this.setCursorPosition(screenX, screenY);
                if (((Boolean)Config.CLIENT.client.options.uiSounds.get()).booleanValue()) {
                    mc.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15197, (float)2.0f));
                }
                this.performMouseDrag(this.cursorX, this.cursorY, (double)screenX - lastTargetX, (double)screenY - lastTargetY);
                this.hideVirtualCursor = targetPoint.shouldHide();
                this.moved = true;
            });
        }
    }

    private List<NavigationPoint> gatherNavigationPoints(class_437 screen, Navigate navigate, int cursorX, int cursorY) {
        int buttonHeight;
        int startX;
        class_507 recipeBook;
        ArrayList<NavigationPoint> points = new ArrayList<NavigationPoint>();
        ArrayList<Object> widgets = new ArrayList<Object>();
        if (screen instanceof class_465) {
            class_465 containerScreen = (class_465)screen;
            int n = ClientServices.CLIENT.getScreenLeft(containerScreen);
            int guiTop = ClientServices.CLIENT.getScreenTop(containerScreen);
            for (class_1735 slot : containerScreen.method_17577().field_7761) {
                if (ClientServices.CLIENT.getSlotUnderMouse(containerScreen) == slot) continue;
                int posX = n + slot.field_7873 + 8;
                int posY = guiTop + slot.field_7872 + 8;
                points.add(new SlotNavigationPoint((double)posX, (double)posY, slot));
            }
        }
        for (class_364 class_3642 : screen.method_25396()) {
            this.gatherNavigationPointsFromListener(class_3642, navigate, cursorX, cursorY, points, null, null);
        }
        if (screen instanceof class_518 && (recipeBook = ((class_518)screen).method_2659()).method_2605()) {
            widgets.add(((RecipeBookComponentAccessor)recipeBook).controllableGetFilterButton());
            widgets.addAll(((RecipeBookComponentAccessor)recipeBook).controllableGetRecipeTabs());
            class_513 class_5132 = ((RecipeBookComponentAccessor)recipeBook).controllableGetRecipeBookPage();
            class_508 overlay = ((RecipeBookPageAccessor)class_5132).controllableGetOverlay();
            if (overlay.method_2616()) {
                widgets.addAll(((OverlayRecipeComponentAccessor)overlay).controllableGetRecipeButtons());
            } else {
                class_513 recipeBookPage = ((RecipeBookComponentAccessor)recipeBook).controllableGetRecipeBookPage();
                widgets.addAll(((RecipeBookPageAccessor)recipeBookPage).controllableGetButtons());
                widgets.add(((RecipeBookPageAccessor)recipeBookPage).controllableGetForwardButton());
                widgets.add(((RecipeBookPageAccessor)recipeBookPage).controllableGetBackButton());
            }
        }
        if (screen instanceof class_486) {
            class_486 enchantmentScreen = (class_486)screen;
            int n = ClientServices.CLIENT.getScreenLeft((class_465<?>)enchantmentScreen) + 60;
            int startY = ClientServices.CLIENT.getScreenTop((class_465<?>)enchantmentScreen) + 14;
            int itemWidth = 108;
            int itemHeight = 19;
            for (int i = 0; i < 3; ++i) {
                double itemX = (double)n + (double)itemWidth / 2.0;
                double itemY = (double)(startY + itemHeight * i) + (double)itemHeight / 2.0;
                points.add(new BasicNavigationPoint(itemX, itemY));
            }
        }
        if (screen instanceof class_3979) {
            int offsetIndex;
            class_3979 stonecutter = (class_3979)screen;
            class_3971 class_39712 = (class_3971)stonecutter.method_17577();
            startX = ClientServices.CLIENT.getScreenLeft((class_465<?>)stonecutter) + 52;
            int startY = ClientServices.CLIENT.getScreenTop((class_465<?>)stonecutter) + 14;
            int buttonWidth = 16;
            buttonHeight = 18;
            for (int index = offsetIndex = ClientServices.CLIENT.getStonecutterStartIndex(stonecutter); index < offsetIndex + 12 && index < class_39712.method_17864(); ++index) {
                int buttonIndex = index - offsetIndex;
                int buttonX = startX + buttonIndex % 4 * buttonWidth;
                int buttonY = startY + buttonIndex / 4 * buttonHeight + 2;
                points.add(new BasicNavigationPoint((double)buttonX + (double)buttonWidth / 2.0, (double)buttonY + (double)buttonHeight / 2.0));
            }
        }
        if (screen instanceof class_494) {
            class_494 loom = (class_494)screen;
            List list = ((class_1726)loom.method_17577()).method_43706();
            startX = ClientServices.CLIENT.getScreenLeft((class_465<?>)loom) + 60;
            int startY = ClientServices.CLIENT.getScreenTop((class_465<?>)loom) + 13;
            int buttonWidth = 14;
            buttonHeight = 14;
            int offsetRow = ClientServices.CLIENT.getLoomStartRow(loom);
            for (int i = 0; i < 4; ++i) {
                int buttonIndex;
                for (int j = 0; j < 4 && (buttonIndex = (i + offsetRow) * 4 + j) < list.size(); ++j) {
                    int buttonX = startX + j * buttonWidth;
                    int buttonY = startY + i * buttonHeight;
                    points.add(new BasicNavigationPoint((double)buttonX + (double)buttonWidth / 2.0, (double)buttonY + (double)buttonHeight / 2.0));
                }
            }
        }
        for (class_339 class_3392 : widgets) {
            if (class_3392 == null || class_3392.method_49606() || !class_3392.field_22764 || !class_3392.field_22763) continue;
            points.add(new WidgetNavigationPoint(class_3392));
        }
        if (screen instanceof class_481) {
            class_481 creativeScreen = (class_481)screen;
            ClientServices.CLIENT.gatherCreativeTabNavigationPoints(creativeScreen, points);
        }
        if (Controllable.isJeiLoaded() && ClientHelper.isPlayingGame()) {
            points.addAll(JeiSupport.getNavigationPoints());
        }
        if (Controllable.isEmiLoaded() && ClientHelper.isPlayingGame()) {
            points.addAll(EmiSupport.getNavigationPoints(screen));
        }
        if (Controllable.isReiLoaded() && ClientHelper.isPlayingGame()) {
            points.addAll(ReiSupport.getNavigationPoints(screen));
        }
        return points;
    }

    private void gatherNavigationPointsFromListener(class_364 listener, Navigate navigate, int cursorX, int cursorY, List<NavigationPoint> points, @Nullable class_350<?> list, @Nullable class_364 entry) {
        if (listener instanceof Navigatable) {
            Navigatable navigatable = (Navigatable)listener;
            navigatable.elements().forEach(child -> this.gatherNavigationPointsFromListener((class_364)child, navigate, cursorX, cursorY, points, list, entry));
        } else if (listener instanceof class_350) {
            class_350 selectionList = (class_350)listener;
            this.gatherNavigationPointsFromAbstractList(selectionList, navigate, cursorX, cursorY, points);
        } else if (listener instanceof class_8089) {
            class_8089 navigationBar = (class_8089)listener;
            navigationBar.method_25396().forEach(child -> {
                if (child instanceof class_8209) {
                    class_8209 button = (class_8209)child;
                    this.createWidgetNavigationPoint((class_339)button, points, list, entry);
                }
            });
        } else if (listener instanceof class_4069) {
            class_4069 handler = (class_4069)listener;
            handler.method_25396().forEach(child -> this.gatherNavigationPointsFromListener((class_364)child, navigate, cursorX, cursorY, points, list, entry));
        } else if (listener instanceof class_339) {
            class_339 widget = (class_339)listener;
            if (widget.field_22763 && widget.field_22764) {
                this.createWidgetNavigationPoint(widget, points, list, entry);
            }
        }
    }

    private void createWidgetNavigationPoint(class_339 widget, List<NavigationPoint> points, @Nullable class_350<?> list, @Nullable class_364 entry) {
        if (widget == null || widget.method_49606() || !widget.field_22764 || !widget.field_22763) {
            return;
        }
        if (list != null && entry != null) {
            points.add(new ListWidgetNavigationPoint(widget, list, entry));
        } else {
            points.add(new WidgetNavigationPoint(widget));
        }
    }

    private void gatherNavigationPointsFromAbstractList(class_350<?> list, Navigate navigate, int cursorX, int cursorY, List<NavigationPoint> points) {
        List children = list.method_25396();
        int dir = navigate == Navigate.UP ? -1 : 1;
        int itemHeight = ClientServices.CLIENT.getListItemHeight(list);
        for (int i = 0; i < children.size(); ++i) {
            class_364 entry = (class_364)children.get(i);
            int rowTop = ClientServices.CLIENT.getAbstractListRowTop(list, i);
            int rowBottom = ClientServices.CLIENT.getAbstractListRowBottom(list, i);
            int listTop = ClientServices.CLIENT.getAbstractListTop(list);
            int listBottom = ClientServices.CLIENT.getAbstractListBottom(list);
            if (rowTop > listTop - itemHeight && rowBottom < listBottom + itemHeight) {
                if (!(navigate != Navigate.UP && navigate != Navigate.DOWN || entry instanceof SkipItem && (i == 0 || i == children.size() - 1))) {
                    points.add(new ListEntryNavigationPoint(list, entry, i, dir));
                }
                this.gatherNavigationPointsFromListener(entry, navigate, cursorX, cursorY, points, list, entry);
                continue;
            }
            if (!list.method_25405((double)cursorX, (double)cursorY)) continue;
            points.add(new ListEntryNavigationPoint(list, entry, i, dir));
        }
    }

    private void craftRecipeBookItem() {
        class_465 screen;
        class_437 class_4372;
        block10: {
            block9: {
                class_310 mc = class_310.method_1551();
                if (mc.field_1724 == null) {
                    return;
                }
                class_4372 = mc.field_1755;
                if (!(class_4372 instanceof class_465)) break block9;
                screen = (class_465)class_4372;
                class_4372 = mc.field_1755;
                if (class_4372 instanceof class_518) break block10;
            }
            return;
        }
        class_518 listener = (class_518)class_4372;
        if (!listener.method_2659().method_2605()) {
            return;
        }
        if (!(screen.method_17577() instanceof class_1729)) {
            return;
        }
        class_513 recipeBookPage = ((RecipeBookComponentAccessor)listener.method_2659()).controllableGetRecipeBookPage();
        class_514 recipeButton = ((RecipeBookPageAccessor)recipeBookPage).controllableGetButtons().stream().filter(class_339::method_25367).findFirst().orElse(null);
        if (recipeButton != null) {
            class_1729 menu = (class_1729)screen.method_17577();
            class_1735 slot = menu.method_7611(menu.method_7655());
            int screenLeft = ClientServices.CLIENT.getScreenLeft(screen);
            int screenTop = ClientServices.CLIENT.getScreenTop(screen);
            if (menu.method_34255().method_7960()) {
                this.invokeMouseClick((class_437)screen, 0, screenLeft + slot.field_7873 + 8, screenTop + slot.field_7872 + 8);
            } else {
                this.invokeMouseReleased((class_437)screen, 0, screenLeft + slot.field_7873 + 8, screenTop + slot.field_7872 + 8);
            }
        }
    }

    private void setCursorPosition(double cursorX, double cursorY) {
        if (((Boolean)Config.CLIENT.client.options.virtualCursor.get()).booleanValue()) {
            this.virtualCursorX = cursorX;
            this.virtualCursorY = cursorY;
        } else {
            class_310 mc = class_310.method_1551();
            GLFW.glfwSetCursorPos((long)mc.method_22683().method_4490(), (double)cursorX, (double)cursorY);
            this.preventReset = true;
        }
    }

    private void handleCreativeScrolling(class_481 screen, Controller controller) {
        int i = (((class_481.class_483)screen.method_17577()).field_2897.size() + 9 - 1) / 9 - 5;
        int dir = 0;
        if (controller.getRThumbStickYValue() <= -0.8f) {
            dir = 1;
        } else if (controller.getRThumbStickYValue() >= 0.8f) {
            dir = -1;
        }
        float currentScroll = ClientServices.CLIENT.getCreativeScrollOffset(screen);
        currentScroll = (float)((double)currentScroll - (double)dir / (double)i);
        currentScroll = class_3532.method_15363((float)currentScroll, (float)0.0f, (float)1.0f);
        ClientServices.CLIENT.setCreativeScrollOffset(screen, currentScroll);
        ((class_481.class_483)screen.method_17577()).method_2473(currentScroll);
    }

    private void handleListScrolling(class_350<?> list, Controller controller) {
        float yValue;
        double dir = 0.0;
        float f = yValue = Config.CLIENT.client.options.cursorThumbstick.get() == Thumbstick.LEFT ? controller.getRThumbStickYValue() : controller.getLThumbStickYValue();
        if (Math.abs(yValue) >= 0.2f) {
            this.setControllerInUse();
            dir = yValue;
        }
        list.method_25307(list.method_25341() + (dir *= (double)class_310.method_1551().method_1534()) * (Double)Config.CLIENT.client.options.listScrollSpeed.get());
    }

    private void handleMerchantScrolling(class_492 screen, Controller controller) {
        float yValue;
        double dir = 0.0;
        float f = yValue = Config.CLIENT.client.options.cursorThumbstick.get() == Thumbstick.LEFT ? controller.getRThumbStickYValue() : controller.getLThumbStickYValue();
        if (Math.abs(yValue) >= 0.5f) {
            this.setControllerInUse();
            dir = -yValue;
        } else {
            this.lastMerchantScroll = 0L;
        }
        long scrollTime = class_156.method_658();
        if (dir != 0.0 && scrollTime - this.lastMerchantScroll >= 150L) {
            screen.method_25401(this.getCursorX(), this.getCursorY(), Math.signum(dir));
            this.lastMerchantScroll = scrollTime;
        }
    }

    private double getCursorX() {
        class_310 mc = class_310.method_1551();
        double cursorX = mc.field_1729.method_1603();
        if (Controllable.getController() != null && ((Boolean)Config.CLIENT.client.options.virtualCursor.get()).booleanValue() && this.lastUse > 0) {
            cursorX = this.virtualCursorX;
        }
        return cursorX * (double)mc.method_22683().method_4486() / (double)mc.method_22683().method_4489();
    }

    private double getCursorY() {
        class_310 mc = class_310.method_1551();
        double cursorY = mc.field_1729.method_1604();
        if (Controllable.getController() != null && ((Boolean)Config.CLIENT.client.options.virtualCursor.get()).booleanValue() && this.lastUse > 0) {
            cursorY = this.virtualCursorY;
        }
        return cursorY * (double)mc.method_22683().method_4502() / (double)mc.method_22683().method_4506();
    }

    private void clampCursorToWindowBounds() {
        class_310 mc = class_310.method_1551();
        this.cursorX = Math.max(0, Math.min(this.cursorX, mc.method_22683().method_4489()));
        this.cursorY = Math.max(0, Math.min(this.cursorY, mc.method_22683().method_4506()));
    }

    private void snapToContainerSlot() {
        class_465 screen;
        class_1735 slot;
        class_437 class_4372;
        class_310 mc = class_310.method_1551();
        if (mc.field_1724 != null && (class_4372 = mc.field_1755) instanceof class_465 && (slot = ClientServices.CLIENT.getSlotUnderMouse(screen = (class_465)class_4372)) != null && slot.method_7682() && (slot.method_7681() || !screen.method_17577().method_34255().method_7960())) {
            int slotX = ClientServices.CLIENT.getScreenLeft(screen) + slot.field_7873 + 8;
            int slotY = ClientServices.CLIENT.getScreenTop(screen) + slot.field_7872 + 8;
            this.cursorX = slotX *= (int)mc.method_22683().method_4495();
            this.cursorY = slotY *= (int)mc.method_22683().method_4495();
            this.clampCursorToWindowBounds();
            this.prevCursorX = slotX;
            this.prevCursorY = slotY;
            this.setCursorPosition(slotX, slotY);
        }
    }

    private void invokeMouseClick(class_437 screen, int button) {
        if (screen != null) {
            double cursorX = this.getCursorX();
            double cursorY = this.getCursorY();
            if (screen instanceof class_465 && Controllable.isEmiLoaded() && EmiSupport.invokeMouseClick(button, cursorX, cursorY)) {
                return;
            }
            this.invokeMouseClick(screen, button, cursorX, cursorY);
        }
    }

    private void invokeMouseClick(class_437 screen, int button, double cursorX, double cursorY) {
        if (screen != null) {
            ClientServices.CLIENT.setActiveMouseButton(button);
            ClientServices.CLIENT.setLastMouseEventTime(class_3673.method_15974());
            ClientServices.CLIENT.sendScreenMouseClick(screen, cursorX, cursorY, button);
        }
    }

    private void invokeMouseReleased(class_437 screen, int button) {
        if (screen != null) {
            double cursorX = this.getCursorX();
            double cursorY = this.getCursorY();
            if (screen instanceof class_465 && Controllable.isEmiLoaded() && EmiSupport.invokeMouseReleased(button, cursorX, cursorY)) {
                return;
            }
            this.invokeMouseReleased(screen, button, cursorX, cursorY);
        }
    }

    private void invokeMouseReleased(class_437 screen, int button, double cursorX, double cursorY) {
        if (screen != null) {
            ClientServices.CLIENT.setActiveMouseButton(-1);
            ClientServices.CLIENT.sendScreenMouseReleased(screen, cursorX, cursorY, button);
        }
    }

    private static enum Navigate {
        UP((p, x, y) -> p.getY() < (double)y, (p, v) -> Math.abs(p.getX() - v.x)),
        DOWN((p, x, y) -> p.getY() > (double)(y + 1), (p, v) -> Math.abs(p.getX() - v.x)),
        LEFT((p, x, y) -> p.getX() < (double)x, (p, v) -> Math.abs(p.getY() - v.y)),
        RIGHT((p, x, y) -> p.getX() > (double)(x + 1), (p, v) -> Math.abs(p.getY() - v.y));

        private final NavigatePredicate predicate;
        private final BiFunction<? super NavigationPoint, Vector3d, Double> keyExtractor;

        private Navigate(NavigatePredicate predicate, BiFunction<? super NavigationPoint, Vector3d, Double> keyExtractor) {
            this.predicate = predicate;
            this.keyExtractor = keyExtractor;
        }

        public NavigatePredicate getPredicate() {
            return this.predicate;
        }

        public BiFunction<? super NavigationPoint, Vector3d, Double> getKeyExtractor() {
            return this.keyExtractor;
        }

        public Comparator<NavigationPoint> getMinComparator(int cursorX, int cursorY) {
            return Comparator.comparing(p -> this.keyExtractor.apply((NavigationPoint)p, new Vector3d((double)cursorX, (double)cursorY, 0.0)));
        }
    }

    private static interface NavigatePredicate {
        public boolean test(NavigationPoint var1, int var2, int var3);
    }
}

