/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.controllable.client;

import com.google.common.base.Charsets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mrcrayfish.controllable.Config;
import com.mrcrayfish.controllable.Controllable;
import com.mrcrayfish.controllable.client.Thumbstick;
import com.mrcrayfish.controllable.client.binding.BindingRegistry;
import com.mrcrayfish.controllable.client.binding.ButtonBinding;
import com.mrcrayfish.controllable.client.binding.ButtonBindings;
import com.mrcrayfish.controllable.client.gui.ButtonBindingData;
import com.mrcrayfish.controllable.client.gui.screens.RadialMenuConfigureScreen;
import com.mrcrayfish.controllable.client.input.Controller;
import com.mrcrayfish.controllable.platform.ClientServices;
import com.mrcrayfish.framework.api.event.IFrameworkEvent;
import com.mrcrayfish.framework.api.event.TickEvents;
import com.mrcrayfish.framework.event.ITickEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3518;
import net.minecraft.class_3532;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5253;
import net.minecraft.class_5348;
import net.minecraft.class_757;

public class RadialMenuHandler {
    private static final class_2960 TEXTURE = new class_2960("controllable", "textures/gui/controller.png");
    private static final int ANIMATE_DURATION = 5;
    private static RadialMenuHandler instance;
    private boolean loaded;
    private boolean visible;
    private int animateTicks;
    private int prevAnimateTicks;
    private Set<ButtonBindingData> bindings = new LinkedHashSet<ButtonBindingData>();
    private AbstractRadialItem settingsItem;
    private AbstractRadialItem closeItem;
    private List<AbstractRadialItem> allItems = new ArrayList<AbstractRadialItem>();
    private List<AbstractRadialItem> leftItems = new ArrayList<AbstractRadialItem>();
    private List<AbstractRadialItem> rightItems = new ArrayList<AbstractRadialItem>();
    private AbstractRadialItem selected;

    public static RadialMenuHandler instance() {
        if (instance == null) {
            instance = new RadialMenuHandler();
        }
        return instance;
    }

    private RadialMenuHandler() {
        TickEvents.START_CLIENT.register((IFrameworkEvent)((ITickEvent.StartClient)this::onClientTickStart));
        TickEvents.END_CLIENT.register((IFrameworkEvent)((ITickEvent.EndClient)this::onClientTickEnd));
        TickEvents.END_RENDER.register((IFrameworkEvent)((ITickEvent.EndRender)this::onRenderEnd));
    }

    private void load() {
        if (this.loaded) {
            return;
        }
        File file = new File(Controllable.getConfigFolder(), "controllable/radial_menu_items.json");
        if (file.exists()) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), Charsets.UTF_8));){
                JsonArray bindings = (JsonArray)new Gson().fromJson((Reader)reader, JsonArray.class);
                bindings.forEach(element -> {
                    JsonObject object = element.getAsJsonObject();
                    String key = class_3518.method_15265((JsonObject)object, (String)"key");
                    String colorName = class_3518.method_15265((JsonObject)object, (String)"color");
                    ButtonBinding binding = BindingRegistry.getInstance().getBindingByDescriptionKey(key);
                    if (binding != null) {
                        class_124 color = class_124.method_533((String)colorName);
                        if (color == null || color.method_532() == null) {
                            color = class_124.field_1054;
                        }
                        this.bindings.add(new ButtonBindingData(binding, color));
                    }
                });
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this.bindings.addAll(this.getBindings());
            this.save();
        }
        this.loaded = true;
    }

    private void save() {
        JsonArray array = new JsonArray();
        this.bindings.forEach(data -> {
            JsonObject object = new JsonObject();
            object.addProperty("key", data.getBinding().getDescription());
            object.addProperty("color", data.getColor().name());
            array.add((JsonElement)object);
        });
        String json = new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)array);
        File file = new File(Controllable.getConfigFolder(), "controllable/radial_menu_items.json");
        try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));){
            writer.write(json);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public List<ButtonBindingData> getDefaults() {
        ArrayList<ButtonBindingData> defaults = new ArrayList<ButtonBindingData>();
        defaults.add(new ButtonBindingData(ButtonBindings.OPEN_CONTROLLABLE_SETTINGS, class_124.field_1078));
        defaults.add(new ButtonBindingData(ButtonBindings.ADVANCEMENTS, class_124.field_1054));
        defaults.add(new ButtonBindingData(ButtonBindings.SCREENSHOT, class_124.field_1054));
        defaults.add(new ButtonBindingData(ButtonBindings.FULLSCREEN, class_124.field_1054));
        return defaults;
    }

    public void interact() {
        if (this.visible) {
            if (this.selected != null) {
                this.selected.onUseItem(this);
            }
        } else {
            this.load();
            this.setVisibility(true);
            this.populateAndConstruct();
            class_310 mc = class_310.method_1551();
            mc.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15096, (float)1.5f));
        }
    }

    public AbstractRadialItem getSelected() {
        return this.selected;
    }

    public LinkedHashSet<ButtonBindingData> getBindings() {
        return new LinkedHashSet<ButtonBindingData>(this.bindings);
    }

    public void setBindings(Set<ButtonBindingData> bindings) {
        this.bindings = bindings;
        this.save();
        this.populateAndConstruct();
    }

    public void removeBinding(ButtonBinding binding) {
        if (this.bindings.removeIf(data -> data.getBinding() == binding)) {
            this.save();
            this.populateAndConstruct();
        }
    }

    public void setVisibility(boolean visible) {
        this.visible = visible;
    }

    public void clearAnimation() {
        this.animateTicks = 0;
        this.prevAnimateTicks = 0;
    }

    private void populateAndConstruct() {
        this.rightItems.clear();
        this.leftItems.clear();
        ArrayList<AbstractRadialItem> items = new ArrayList<AbstractRadialItem>();
        this.bindings.forEach(binding -> items.add(new ButtonBindingItem((ButtonBindingData)binding)));
        int rightSize = items.size() / 2;
        for (int i = 0; i < rightSize; ++i) {
            float gap = 180.0f / (float)(rightSize + 1);
            AbstractRadialItem item = (AbstractRadialItem)items.get(i);
            item.setAngle(gap * (float)i + gap);
            this.rightItems.add(item);
        }
        int leftSize = items.size() - rightSize;
        for (int i = rightSize; i < items.size(); ++i) {
            float gap = 180.0f / (float)(leftSize + 1);
            AbstractRadialItem item = (AbstractRadialItem)items.get(i);
            item.setAngle(360.0f - gap * (float)(i - rightSize) - gap);
            this.leftItems.add((AbstractRadialItem)items.get(i));
        }
        this.settingsItem = new RadialSettingsItem();
        this.settingsItem.setAngle(0.0f);
        items.add(this.settingsItem);
        this.closeItem = new CloseRadialMenuItem();
        this.closeItem.setAngle(180.0f);
        items.add(this.closeItem);
        this.selected = this.closeItem;
        this.allItems = items;
    }

    public boolean isVisible() {
        return this.visible;
    }

    private void onClientTickStart() {
        if (!this.visible || !Controllable.getInput().isControllerInUse()) {
            // empty if block
        }
    }

    public void onRenderEnd(float partialTick) {
        class_310 mc = class_310.method_1551();
        if (mc.field_1690.field_1842 || mc.field_1755 != null) {
            return;
        }
        if (Controllable.getController() != null && (this.visible || this.animateTicks > 0 || this.prevAnimateTicks > 0)) {
            this.renderRadialMenu(partialTick);
        }
    }

    private void onClientTickEnd() {
        this.prevAnimateTicks = this.animateTicks;
        if (this.visible) {
            if (this.animateTicks < 5) {
                ++this.animateTicks;
            }
        } else if (this.animateTicks > 0) {
            --this.animateTicks;
        }
    }

    private void renderRadialMenu(float partialTick) {
        this.updateSelected();
        class_4587 modelStack = RenderSystem.getModelViewStack();
        modelStack.method_22903();
        modelStack.method_34426();
        modelStack.method_46416(0.0f, 0.0f, 1000.0f - ClientServices.CLIENT.getGuiFarPlane());
        RenderSystem.applyModelViewMatrix();
        class_308.method_24211();
        class_310 mc = class_310.method_1551();
        class_332 graphics = new class_332(mc, mc.method_22940().method_23000());
        class_4587 poseStack = graphics.method_51448();
        float animation = class_3532.method_16439((float)partialTick, (float)this.prevAnimateTicks, (float)this.animateTicks) / 5.0f;
        float c1 = 1.70158f;
        float c3 = c1 + 1.0f;
        animation = (float)(1.0 + (double)c3 * Math.pow(animation - 1.0f, 3.0) + (double)c1 * Math.pow(animation - 1.0f, 2.0));
        graphics.method_25294(0, 0, mc.method_22683().method_4489(), mc.method_22683().method_4506(), 2014318608);
        poseStack.method_46416(0.0f, -10.0f, 0.0f);
        poseStack.method_46416((float)((int)((float)mc.method_22683().method_4486() / 2.0f)), (float)((int)((float)mc.method_22683().method_4502() / 2.0f)), 0.0f);
        poseStack.method_22903();
        this.settingsItem.draw(graphics, mc, false, this.selected == this.settingsItem, animation);
        poseStack.method_22909();
        poseStack.method_22903();
        this.closeItem.draw(graphics, mc, false, this.selected == this.closeItem, animation);
        poseStack.method_22909();
        this.drawRadialItems(this.rightItems, graphics, mc, animation);
        this.drawRadialItems(this.leftItems, graphics, mc, animation);
        modelStack.method_22909();
        RenderSystem.applyModelViewMatrix();
    }

    private void drawRadialItems(List<AbstractRadialItem> items, class_332 graphics, class_310 mc, float animation) {
        for (int i = 0; i < items.size(); ++i) {
            AbstractRadialItem item = items.get(i);
            class_4587 poseStack = graphics.method_51448();
            poseStack.method_22903();
            if (i == 0) {
                poseStack.method_46416(0.0f, -10.0f, 0.0f);
            }
            if (i == items.size() - 1) {
                poseStack.method_46416(0.0f, 10.0f, 0.0f);
            }
            boolean left = item.angle >= 180.0f;
            float x = (float)Math.cos(Math.toRadians(item.angle - 90.0f)) * 70.0f;
            float y = (float)Math.sin(Math.toRadians(item.angle - 90.0f)) * 70.0f;
            poseStack.method_46416((float)((int)x), (float)((int)y), 0.0f);
            item.draw(graphics, mc, left, this.selected == item, animation);
            poseStack.method_22909();
        }
    }

    private void updateSelected() {
        float inputY;
        if (!this.visible) {
            return;
        }
        Controller controller = Controllable.getController();
        if (controller == null) {
            return;
        }
        float threshold = 0.5f;
        float inputX = Config.CLIENT.client.options.radialThumbstick.get() == Thumbstick.RIGHT ? controller.getRThumbStickXValue() : controller.getLThumbStickXValue();
        float f = inputY = Config.CLIENT.client.options.radialThumbstick.get() == Thumbstick.RIGHT ? controller.getRThumbStickYValue() : controller.getLThumbStickYValue();
        if (Math.abs(inputX) <= threshold && Math.abs(inputY) <= threshold) {
            return;
        }
        float selectedAngle = (float)(class_3532.method_15338((double)(Math.toDegrees(Math.atan2(inputY, inputX)) - 90.0)) + 180.0);
        Optional closest = this.allItems.stream().min((o1, o2) -> class_3532.method_15356((float)o1.angle, (float)selectedAngle) > class_3532.method_15356((float)o2.angle, (float)selectedAngle) ? 1 : 0);
        if (closest.isEmpty()) {
            return;
        }
        if (closest.get() == this.selected) {
            return;
        }
        this.selected = (AbstractRadialItem)closest.get();
        class_310 mc = class_310.method_1551();
        if (((Boolean)Config.CLIENT.client.options.uiSounds.get()).booleanValue()) {
            mc.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15197, (float)1.5f));
        }
    }

    private Optional<AbstractRadialItem> getSelectedItem() {
        return Optional.empty();
    }

    public static abstract class AbstractRadialItem {
        protected class_2561 label;
        protected class_2561 description;
        private float angle;

        protected AbstractRadialItem(class_2561 label) {
            this(label, null);
        }

        protected AbstractRadialItem(class_2561 label, class_2561 description) {
            this.label = label;
            this.description = description;
        }

        public class_2561 getLabel() {
            return this.label;
        }

        @Nullable
        public class_2561 getDescription() {
            return this.description;
        }

        public boolean isEmpty() {
            return false;
        }

        public abstract void onUseItem(RadialMenuHandler var1);

        protected abstract void draw(class_332 var1, class_310 var2, boolean var3, boolean var4, float var5);

        protected void playSound(class_3414 event, float pitch) {
            class_310 mc = class_310.method_1551();
            mc.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)event, (float)pitch));
        }

        void setAngle(float angle) {
            this.angle = angle;
        }
    }

    public static final class RadialSettingsItem
    extends AbstractRadialItem {
        private static final class_2561 LABEL = class_2561.method_43471((String)"controllable.gui.configure");

        public RadialSettingsItem() {
            super((class_2561)class_2561.method_43471((String)"controllable.gui.radial.settings"));
        }

        @Override
        public void onUseItem(RadialMenuHandler handler) {
            handler.setVisibility(false);
            handler.clearAnimation();
            class_310.method_1551().method_1507((class_437)new RadialMenuConfigureScreen(handler.getBindings()));
        }

        @Override
        protected void draw(class_332 graphics, class_310 mc, boolean left, boolean selected, float animation) {
            int color = selected ? -3355444 : mc.field_1690.method_19345(0.7f);
            float alpha = (float)class_5253.class_5254.method_27762((int)color) / 255.0f;
            float red = (float)class_5253.class_5254.method_27765((int)color) / 255.0f;
            float green = (float)class_5253.class_5254.method_27766((int)color) / 255.0f;
            float blue = (float)class_5253.class_5254.method_27767((int)color) / 255.0f;
            class_4587 poseStack = graphics.method_51448();
            poseStack.method_46416(0.0f, -90.0f, 0.0f);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableCull();
            alpha = Math.min(1.0f, alpha * animation);
            RenderSystem.setShader(class_757::method_34540);
            class_287 buffer = class_289.method_1348().method_1349();
            buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
            buffer.method_22918(poseStack.method_23760().method_23761(), -14.0f, -15.0f, 0.0f).method_22915(red, green, blue, alpha).method_1344();
            buffer.method_22918(poseStack.method_23760().method_23761(), -14.0f, -14.0f, 0.0f).method_22915(red, green, blue, alpha).method_1344();
            buffer.method_22918(poseStack.method_23760().method_23761(), 14.0f, -14.0f, 0.0f).method_22915(red, green, blue, alpha).method_1344();
            buffer.method_22918(poseStack.method_23760().method_23761(), 14.0f, -15.0f, 0.0f).method_22915(red, green, blue, alpha).method_1344();
            buffer.method_22918(poseStack.method_23760().method_23761(), -15.0f, -14.0f, 0.0f).method_22915(red, green, blue, alpha).method_1344();
            buffer.method_22918(poseStack.method_23760().method_23761(), -15.0f, 14.0f, 0.0f).method_22915(red, green, blue, alpha).method_1344();
            buffer.method_22918(poseStack.method_23760().method_23761(), 15.0f, 14.0f, 0.0f).method_22915(red, green, blue, alpha).method_1344();
            buffer.method_22918(poseStack.method_23760().method_23761(), 15.0f, -14.0f, 0.0f).method_22915(red, green, blue, alpha).method_1344();
            buffer.method_22918(poseStack.method_23760().method_23761(), -14.0f, 14.0f, 0.0f).method_22915(red, green, blue, alpha).method_1344();
            buffer.method_22918(poseStack.method_23760().method_23761(), -14.0f, 15.0f, 0.0f).method_22915(red, green, blue, alpha).method_1344();
            buffer.method_22918(poseStack.method_23760().method_23761(), 14.0f, 15.0f, 0.0f).method_22915(red, green, blue, alpha).method_1344();
            buffer.method_22918(poseStack.method_23760().method_23761(), 14.0f, 14.0f, 0.0f).method_22915(red, green, blue, alpha).method_1344();
            class_286.method_43433((class_287.class_7433)buffer.method_1326());
            RenderSystem.disableBlend();
            RenderSystem.enableCull();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            graphics.method_25293(TEXTURE, -10, -10, 20, 20, 88.0f, 15.0f, 10, 10, 256, 256);
            if (selected) {
                graphics.method_27534(mc.field_1772, LABEL, 0, 21, 0xFFFFFF);
            }
        }
    }

    public static final class CloseRadialMenuItem
    extends AbstractRadialItem {
        private static final class_2561 LABEL = class_2561.method_43471((String)"controllable.gui.close");

        public CloseRadialMenuItem() {
            super((class_2561)class_2561.method_43471((String)"controllable.gui.radial.close"));
        }

        @Override
        public void onUseItem(RadialMenuHandler handler) {
            handler.setVisibility(false);
            class_310 mc = class_310.method_1551();
            mc.method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)class_3417.field_15096, (float)1.3f));
        }

        @Override
        protected void draw(class_332 graphics, class_310 mc, boolean left, boolean selected, float animation) {
            int color = selected ? -3355444 : mc.field_1690.method_19345(0.7f);
            float alpha = (float)class_5253.class_5254.method_27762((int)color) / 255.0f;
            float red = (float)class_5253.class_5254.method_27765((int)color) / 255.0f;
            float green = (float)class_5253.class_5254.method_27766((int)color) / 255.0f;
            float blue = (float)class_5253.class_5254.method_27767((int)color) / 255.0f;
            class_4587 poseStack = graphics.method_51448();
            poseStack.method_46416(0.0f, 90.0f, 0.0f);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableCull();
            alpha = Math.min(1.0f, alpha * animation);
            RenderSystem.setShader(class_757::method_34540);
            class_287 buffer = class_289.method_1348().method_1349();
            buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
            buffer.method_22918(poseStack.method_23760().method_23761(), -14.0f, -15.0f, 0.0f).method_22915(red, green, blue, alpha).method_1344();
            buffer.method_22918(poseStack.method_23760().method_23761(), -14.0f, -14.0f, 0.0f).method_22915(red, green, blue, alpha).method_1344();
            buffer.method_22918(poseStack.method_23760().method_23761(), 14.0f, -14.0f, 0.0f).method_22915(red, green, blue, alpha).method_1344();
            buffer.method_22918(poseStack.method_23760().method_23761(), 14.0f, -15.0f, 0.0f).method_22915(red, green, blue, alpha).method_1344();
            buffer.method_22918(poseStack.method_23760().method_23761(), -15.0f, -14.0f, 0.0f).method_22915(red, green, blue, alpha).method_1344();
            buffer.method_22918(poseStack.method_23760().method_23761(), -15.0f, 14.0f, 0.0f).method_22915(red, green, blue, alpha).method_1344();
            buffer.method_22918(poseStack.method_23760().method_23761(), 15.0f, 14.0f, 0.0f).method_22915(red, green, blue, alpha).method_1344();
            buffer.method_22918(poseStack.method_23760().method_23761(), 15.0f, -14.0f, 0.0f).method_22915(red, green, blue, alpha).method_1344();
            buffer.method_22918(poseStack.method_23760().method_23761(), -14.0f, 14.0f, 0.0f).method_22915(red, green, blue, alpha).method_1344();
            buffer.method_22918(poseStack.method_23760().method_23761(), -14.0f, 15.0f, 0.0f).method_22915(red, green, blue, alpha).method_1344();
            buffer.method_22918(poseStack.method_23760().method_23761(), 14.0f, 15.0f, 0.0f).method_22915(red, green, blue, alpha).method_1344();
            buffer.method_22918(poseStack.method_23760().method_23761(), 14.0f, 14.0f, 0.0f).method_22915(red, green, blue, alpha).method_1344();
            class_286.method_43433((class_287.class_7433)buffer.method_1326());
            RenderSystem.disableBlend();
            RenderSystem.enableCull();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            graphics.method_25293(TEXTURE, -10, -10, 20, 20, 98.0f, 15.0f, 10, 10, 256, 256);
            if (selected) {
                graphics.method_27534(mc.field_1772, LABEL, 0, -30, 0xFFFFFF);
            }
        }
    }

    private static class ButtonBindingItem
    extends AbstractRadialItem {
        public ButtonBindingData entry;

        public ButtonBindingItem(ButtonBindingData entry) {
            super((class_2561)class_2561.method_43471((String)entry.getBinding().getLabelKey()).method_27692(entry.getColor()), (class_2561)class_2561.method_43471((String)entry.getBinding().getCategory()));
            this.entry = entry;
        }

        @Override
        public void onUseItem(RadialMenuHandler radialMenu) {
            radialMenu.setVisibility(false);
            radialMenu.clearAnimation();
            this.entry.getBinding().setActiveAndPressed();
            Controllable.getInput().handleButtonInput(Controllable.getController(), -1, true, true);
        }

        @Override
        protected void draw(class_332 graphics, class_310 mc, boolean left, boolean selected, float animation) {
            int offset;
            class_4587 poseStack = graphics.method_51448();
            poseStack.method_22903();
            int color = selected ? -3355444 : mc.field_1690.method_19345(0.7f);
            float alpha = (float)class_5253.class_5254.method_27762((int)color) / 255.0f;
            float red = (float)class_5253.class_5254.method_27765((int)color) / 255.0f;
            float green = (float)class_5253.class_5254.method_27766((int)color) / 255.0f;
            float blue = (float)class_5253.class_5254.method_27767((int)color) / 255.0f;
            float start = left ? -1.0f : 1.0f;
            float end = (left ? -150.0f : 150.0f) * animation;
            poseStack.method_46416((1.0f - animation) * (float)(left ? -20 : 20), 0.0f, 0.0f);
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableCull();
            RenderSystem.setShader(class_757::method_34540);
            class_287 buffer = class_289.method_1348().method_1349();
            buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
            buffer.method_22918(poseStack.method_23760().method_23761(), start, -15.0f, 0.0f).method_22915(red, green, blue, alpha * animation).method_1344();
            buffer.method_22918(poseStack.method_23760().method_23761(), start, -14.0f, 0.0f).method_22915(red, green, blue, alpha * animation).method_1344();
            buffer.method_22918(poseStack.method_23760().method_23761(), end, -14.0f, 0.0f).method_22915(red, green, blue, 0.0f).method_1344();
            buffer.method_22918(poseStack.method_23760().method_23761(), end, -15.0f, 0.0f).method_22915(red, green, blue, 0.0f).method_1344();
            buffer.method_22918(poseStack.method_23760().method_23761(), 0.0f, -14.0f, 0.0f).method_22915(red, green, blue, alpha * animation).method_1344();
            buffer.method_22918(poseStack.method_23760().method_23761(), 0.0f, 14.0f, 0.0f).method_22915(red, green, blue, alpha * animation).method_1344();
            buffer.method_22918(poseStack.method_23760().method_23761(), end, 14.0f, 0.0f).method_22915(red, green, blue, 0.0f).method_1344();
            buffer.method_22918(poseStack.method_23760().method_23761(), end, -14.0f, 0.0f).method_22915(red, green, blue, 0.0f).method_1344();
            buffer.method_22918(poseStack.method_23760().method_23761(), start, 14.0f, 0.0f).method_22915(red, green, blue, alpha * animation).method_1344();
            buffer.method_22918(poseStack.method_23760().method_23761(), start, 15.0f, 0.0f).method_22915(red, green, blue, alpha * animation).method_1344();
            buffer.method_22918(poseStack.method_23760().method_23761(), end, 15.0f, 0.0f).method_22915(red, green, blue, 0.0f).method_1344();
            buffer.method_22918(poseStack.method_23760().method_23761(), end, 14.0f, 0.0f).method_22915(red, green, blue, 0.0f).method_1344();
            class_286.method_43433((class_287.class_7433)buffer.method_1326());
            RenderSystem.disableBlend();
            RenderSystem.enableCull();
            if (this.label != null) {
                offset = !left ? 5 : -mc.field_1772.method_27525((class_5348)this.label) - 5;
                graphics.method_27535(mc.field_1772, this.label, offset, -10, -1);
            }
            if (this.description != null) {
                offset = !left ? 5 : -mc.field_1772.method_27525((class_5348)this.description) - 5;
                graphics.method_27535(mc.field_1772, this.description, offset, 2, -1);
            }
            poseStack.method_22909();
        }
    }
}

